/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Frame;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import net.sf.fmj.filtergraph.SimpleGraphBuilder;
import net.sf.fmj.media.BasicInputConnector;
import net.sf.fmj.media.BasicModule;
import net.sf.fmj.media.BasicOutputConnector;
import net.sf.fmj.media.Connector;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.PlaybackEngine;

public class BasicFilterModule
extends BasicModule {
    protected Codec codec;
    protected InputConnector ic = new BasicInputConnector();
    protected OutputConnector oc;
    protected FrameProcessingControl frameControl = null;
    protected float curFramesBehind = 0.0f;
    protected float prevFramesBehind = 0.0f;
    protected Frame controlFrame;
    protected final boolean VERBOSE_CONTROL = false;
    protected Buffer storedInputBuffer;
    protected Buffer storedOutputBuffer;
    protected boolean readPendingFlag = false;
    protected boolean writePendingFlag = false;
    private boolean failed = false;
    private boolean markerSet = false;
    private Object lastHdr = null;

    public BasicFilterModule(Codec codec) {
        this.registerInputConnector("input", this.ic);
        this.oc = new BasicOutputConnector();
        this.registerOutputConnector("output", this.oc);
        this.setCodec(codec);
        this.protocol = 0;
        Object object = codec.getControl(FrameProcessingControl.class.getName());
        if (object instanceof FrameProcessingControl) {
            this.frameControl = (FrameProcessingControl)object;
        }
    }

    public void doClose() {
        if (this.codec != null) {
            this.codec.close();
        }
        if (this.controlFrame != null) {
            this.controlFrame.dispose();
            this.controlFrame = null;
        }
    }

    public boolean doPrefetch() {
        return super.doPrefetch();
    }

    public boolean doRealize() {
        if (this.codec != null) {
            try {
                this.codec.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return false;
            }
        }
        return true;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public Object getControl(String string) {
        return this.codec.getControl(string);
    }

    public Object[] getControls() {
        return this.codec.getControls();
    }

    public boolean isThreaded() {
        return this.getProtocol() == 1;
    }

    public void process() {
        do {
            int n;
            Buffer buffer;
            Buffer buffer2;
            block34: {
                if (this.readPendingFlag) {
                    buffer2 = this.storedInputBuffer;
                } else {
                    buffer2 = this.ic.getValidBuffer();
                    Format format = buffer2.getFormat();
                    if (format == null) {
                        format = this.ic.getFormat();
                        buffer2.setFormat(format);
                    }
                    if (format != this.ic.getFormat() && format != null && !format.equals(this.ic.getFormat()) && !buffer2.isDiscard()) {
                        if (this.writePendingFlag) {
                            this.storedOutputBuffer.setDiscard(true);
                            this.oc.writeReport();
                            this.writePendingFlag = false;
                        }
                        if (!this.reinitCodec(buffer2.getFormat())) {
                            buffer2.setDiscard(true);
                            this.ic.readReport();
                            this.failed = true;
                            if (this.moduleListener != null) {
                                this.moduleListener.formatChangedFailure(this, this.ic.getFormat(), buffer2.getFormat());
                            }
                            return;
                        }
                        Format format2 = this.ic.getFormat();
                        this.ic.setFormat(buffer2.getFormat());
                        if (this.moduleListener != null) {
                            this.moduleListener.formatChanged(this, format2, buffer2.getFormat());
                        }
                    }
                    if ((buffer2.getFlags() & 0x400) != 0) {
                        this.markerSet = true;
                    }
                }
                if (this.writePendingFlag) {
                    buffer = this.storedOutputBuffer;
                } else {
                    buffer = this.oc.getEmptyBuffer();
                    if (buffer != null) {
                        buffer.setLength(0);
                        buffer.setOffset(0);
                        this.lastHdr = buffer.getHeader();
                    }
                }
                buffer.setTimeStamp(buffer2.getTimeStamp());
                buffer.setRtpTimeStamp(buffer2.getRtpTimeStamp());
                buffer.setHeaderExtension(buffer2.getHeaderExtension());
                buffer.setDuration(buffer2.getDuration());
                buffer.setSequenceNumber(buffer2.getSequenceNumber());
                buffer.setFlags(buffer2.getFlags());
                buffer.setHeader(buffer2.getHeader());
                if (this.resetted) {
                    if ((buffer2.getFlags() & 0x200) != 0) {
                        this.codec.reset();
                        this.resetted = false;
                    }
                    this.writePendingFlag = false;
                    this.readPendingFlag = false;
                    this.ic.readReport();
                    this.oc.writeReport();
                    return;
                }
                if (this.failed || buffer2.isDiscard()) {
                    if (this.markerSet) {
                        buffer.setFlags(buffer.getFlags() & 0xFFFFFBFF);
                        this.markerSet = false;
                    }
                    this.curFramesBehind = 0.0f;
                    this.ic.readReport();
                    if (!this.writePendingFlag) {
                        this.oc.writeReport();
                    }
                    return;
                }
                if (this.frameControl != null && this.curFramesBehind != this.prevFramesBehind && (buffer2.getFlags() & 0x20) == 0) {
                    this.frameControl.setFramesBehind(this.curFramesBehind);
                    this.prevFramesBehind = this.curFramesBehind;
                }
                n = 0;
                try {
                    n = this.codec.process(buffer2, buffer);
                }
                catch (Throwable throwable) {
                    Log.dumpStack(throwable);
                    if (this.moduleListener == null) break block34;
                    this.moduleListener.internalErrorOccurred(this);
                }
            }
            if (PlaybackEngine.TRACE_ON && !this.verifyBuffer(buffer)) {
                System.err.println("verify buffer failed: " + this.codec);
                Thread.dumpStack();
                if (this.moduleListener != null) {
                    this.moduleListener.internalErrorOccurred(this);
                }
            }
            if ((n & 8) != 0) {
                this.failed = true;
                if (this.moduleListener != null) {
                    this.moduleListener.pluginTerminated(this);
                }
                this.writePendingFlag = false;
                this.readPendingFlag = false;
                this.ic.readReport();
                this.oc.writeReport();
                return;
            }
            if (this.curFramesBehind > 0.0f && buffer.isDiscard()) {
                this.curFramesBehind -= 1.0f;
                if (this.curFramesBehind < 0.0f) {
                    this.curFramesBehind = 0.0f;
                }
                n &= 0xFFFFFFFB;
            }
            if ((n & 1) != 0) {
                buffer.setDiscard(true);
                if (this.markerSet) {
                    buffer.setFlags(buffer.getFlags() & 0xFFFFFBFF);
                    this.markerSet = false;
                }
                this.ic.readReport();
                this.oc.writeReport();
                this.writePendingFlag = false;
                this.readPendingFlag = false;
                return;
            }
            if (buffer.isEOM() && ((n & 2) != 0 || (n & 4) != 0)) {
                buffer.setEOM(false);
            }
            if ((n & 4) != 0) {
                this.writePendingFlag = true;
                this.storedOutputBuffer = buffer;
            } else {
                if (this.markerSet) {
                    buffer.setFlags(buffer.getFlags() | 0x400);
                    this.markerSet = false;
                }
                this.oc.writeReport();
                this.writePendingFlag = false;
            }
            if ((n & 2) != 0 || buffer2.isEOM() && !buffer.isEOM()) {
                this.readPendingFlag = true;
                this.storedInputBuffer = buffer2;
                continue;
            }
            buffer2.setHeader(this.lastHdr);
            this.ic.readReport();
            this.readPendingFlag = false;
        } while (this.readPendingFlag);
    }

    protected boolean reinitCodec(Format format) {
        Codec codec;
        if (this.codec != null) {
            if (this.codec.setInputFormat(format) != null) {
                return true;
            }
            this.codec.close();
            this.codec = null;
        }
        if ((codec = SimpleGraphBuilder.findCodec(format, null, null, null)) == null) {
            return false;
        }
        this.setCodec(codec);
        return true;
    }

    public boolean setCodec(Codec codec) {
        this.codec = codec;
        return true;
    }

    public boolean setCodec(String string) {
        return true;
    }

    public void setFormat(Connector connector, Format format) {
        if (connector == this.ic) {
            if (this.codec != null) {
                this.codec.setInputFormat(format);
            }
        } else if (connector == this.oc && this.codec != null) {
            this.codec.setOutputFormat(format);
        }
    }

    protected void setFramesBehind(float f) {
        this.curFramesBehind = f;
    }
}

