/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.Controller;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DurationUpdateEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.TransitionEvent;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.media.AbstractController;
import net.sf.fmj.ejmf.toolkit.media.event.ManagedControllerErrorEvent;

public abstract class AbstractPlayer
extends AbstractController
implements Player,
ControllerListener {
    private DataSource source;
    private Vector controllers = new Vector();
    private Time duration = new Time(0L);
    private ControllerErrorEvent controllerError;
    private GainControl gainControl;
    private Component visualComponent;
    private Component controlPanelComponent;

    public synchronized void addController(Controller controller) throws IncompatibleTimeBaseException {
        if (this.controllers.contains(controller) || this == controller) {
            return;
        }
        int n = this.getState();
        if (n == 100 || n == 200) {
            throw new NotRealizedError("Cannot add Controller to an Unrealized Player");
        }
        if (n == 600) {
            throw new ClockStartedError("Cannot add Controller to a Started Player");
        }
        int n2 = controller.getState();
        if (n2 == 100 || n2 == 200) {
            throw new NotRealizedError("Cannot add Unrealized Controller to a Player");
        }
        if (n2 == 600) {
            throw new ClockStartedError("Cannot add Started Controller to a Player");
        }
        controller.setTimeBase(this.getTimeBase());
        this.stop();
        controller.stop();
        n = this.getState();
        n2 = controller.getState();
        if (n2 < 500 && n > 300) {
            this.deallocate();
        }
        controller.setMediaTime(this.getMediaTime());
        controller.setStopTime(Clock.RESET);
        float f = this.getRate();
        if (f != controller.setRate(f)) {
            controller.setRate(1.0f);
            this.setRate(1.0f);
        }
        this.controllers.addElement(controller);
        controller.addControllerListener(this);
        this.updateDuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areControllersStopped() {
        Vector vector = this.controllers;
        synchronized (vector) {
            int n = this.controllers.size();
            for (int i = 0; i < n; ++i) {
                Controller controller = (Controller)this.controllers.elementAt(i);
                if (controller.getState() != 600) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void controllerUpdate(ControllerEvent controllerEvent) {
        Vector vector = this.controllers;
        synchronized (vector) {
            if (controllerEvent instanceof TransitionEvent) {
                this.controllers.notifyAll();
            } else if (controllerEvent instanceof ControllerErrorEvent) {
                this.setControllerError((ControllerErrorEvent)controllerEvent);
                this.controllers.notifyAll();
            }
        }
    }

    public final synchronized void doClose() {
        Vector vector = this.getControllers();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Controller controller = (Controller)vector.elementAt(i);
            controller.close();
        }
        try {
            this.source.stop();
            this.source.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.doPlayerClose();
        vector = null;
        this.source = null;
        this.gainControl = null;
        this.controllerError = null;
    }

    public final boolean doDeallocate() {
        int n;
        this.resetControllerError();
        int n2 = this.controllers.size();
        Thread[] threadArray = new Thread[n2];
        for (n = 0; n < n2; ++n) {
            final Controller controller = (Controller)this.controllers.elementAt(n);
            threadArray[n] = new Thread("Player Deallocate Thread"){

                public void run() {
                    controller.deallocate();
                }
            };
            threadArray[n].start();
        }
        if (!this.doPlayerDeallocate()) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.controllerError != null) {
            this.postManagedControllerErrorEvent();
            return false;
        }
        return true;
    }

    public abstract void doPlayerClose();

    public abstract boolean doPlayerDeallocate();

    public abstract boolean doPlayerPrefetch();

    public abstract boolean doPlayerRealize();

    public abstract void doPlayerSetMediaTime(Time var1);

    public abstract float doPlayerSetRate(float var1);

    public abstract boolean doPlayerStop();

    public abstract boolean doPlayerSyncStart(Time var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doPrefetch() {
        this.resetControllerError();
        for (int i = 0; i < this.controllers.size(); ++i) {
            Controller controller = (Controller)this.controllers.elementAt(i);
            controller.prefetch();
        }
        if (!this.doPlayerPrefetch()) {
            return false;
        }
        Vector vector = this.controllers;
        synchronized (vector) {
            while (this.controllerError == null && !this.isStateReached(500)) {
                try {
                    this.controllers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.controllerError != null) {
            this.postManagedControllerErrorEvent();
            return false;
        }
        this.updateDuration();
        return true;
    }

    public final boolean doRealize() {
        try {
            this.source.start();
        }
        catch (IOException iOException) {
            this.postEvent(new ResourceUnavailableEvent(this, "Could not start DataSource"));
            return false;
        }
        if (!this.doPlayerRealize()) {
            return false;
        }
        this.updateDuration();
        return true;
    }

    public final synchronized void doSetMediaTime(Time time) {
        int n = this.controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller controller = (Controller)this.controllers.elementAt(i);
            controller.setMediaTime(time);
        }
        this.doPlayerSetMediaTime(time);
    }

    public final synchronized float doSetRate(float f) {
        float f2;
        int n = this.controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller controller = (Controller)this.controllers.elementAt(i);
            f2 = controller.setRate(f);
            if (f == 1.0f || f2 == f) continue;
            this.doSetRate(1.0f);
            return 1.0f;
        }
        f2 = this.doPlayerSetRate(f);
        if (!this.controllers.isEmpty() && f != 1.0f && f2 != f) {
            this.doSetRate(1.0f);
            return 1.0f;
        }
        return f2;
    }

    public final boolean doStop() {
        int n;
        this.resetControllerError();
        int n2 = this.controllers.size();
        Thread[] threadArray = new Thread[n2];
        for (n = 0; n < n2; ++n) {
            final Controller controller = (Controller)this.controllers.elementAt(n);
            threadArray[n] = new Thread("Player Stop Thread"){

                public void run() {
                    controller.stop();
                }
            };
            threadArray[n].start();
        }
        if (!this.doPlayerStop()) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.controllerError != null) {
            this.postManagedControllerErrorEvent();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doSyncStart(Time time) {
        this.resetControllerError();
        for (int i = 0; i < this.controllers.size(); ++i) {
            Controller controller = (Controller)this.controllers.elementAt(i);
            controller.syncStart(time);
        }
        if (!this.doPlayerSyncStart(time)) {
            return false;
        }
        Vector vector = this.controllers;
        synchronized (vector) {
            while (this.controllerError == null && !this.isStateReached(600)) {
                try {
                    this.controllers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.controllerError != null) {
            this.postManagedControllerErrorEvent();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endOfMedia() throws ClockStoppedException {
        Vector vector = this.controllers;
        synchronized (vector) {
            while (!this.areControllersStopped()) {
                try {
                    this.controllers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        super.endOfMedia();
    }

    private ControllerErrorEvent getControllerError() {
        return this.controllerError;
    }

    protected Vector getControllers() {
        return (Vector)this.controllers.clone();
    }

    public Component getControlPanelComponent() {
        int n = this.getState();
        if (n == 100 || n == 200) {
            throw new NotRealizedError("Cannot get control panel Component on an Unrealized Player");
        }
        return this.controlPanelComponent;
    }

    public final synchronized Time getDuration() {
        if (this.duration == null) {
            this.updateDuration();
        }
        return this.duration;
    }

    public GainControl getGainControl() {
        int n = this.getState();
        if (n == 100 || n == 200) {
            throw new NotRealizedError("Cannot get gain control on an Unrealized Player");
        }
        return this.gainControl;
    }

    public abstract Time getPlayerDuration();

    public abstract Time getPlayerStartLatency();

    public DataSource getSource() {
        return this.source;
    }

    public synchronized Time getStartLatency() {
        int n = this.getState();
        if (n == 100 || n == 200) {
            throw new NotRealizedError("Cannot get start latency from an Unrealized Controller");
        }
        Time time = this.getPlayerStartLatency();
        int n2 = this.controllers.size();
        for (int i = 0; i < n2; ++i) {
            Controller controller = (Controller)this.controllers.elementAt(i);
            Time time2 = controller.getStartLatency();
            if (time2 == LATENCY_UNKNOWN || time != LATENCY_UNKNOWN && time2.getNanoseconds() <= time.getNanoseconds()) continue;
            time = time2;
        }
        return time;
    }

    public Component getVisualComponent() {
        int n = this.getState();
        if (n == 100 || n == 200) {
            throw new NotRealizedError("Cannot get visual Component on an Unrealized Player");
        }
        return this.visualComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStateReached(int n) {
        Vector vector = this.controllers;
        synchronized (vector) {
            int n2 = this.controllers.size();
            for (int i = 0; i < n2; ++i) {
                Controller controller = (Controller)this.controllers.elementAt(i);
                if (controller.getState() >= n) continue;
                return false;
            }
            return true;
        }
    }

    private void postManagedControllerErrorEvent() {
        String string = "Managing Player " + this.getClass().getName() + " received ControllerErrorEvent from " + this.controllerError.getSourceController().getClass().getName();
        this.postEvent(new ManagedControllerErrorEvent(this, this.controllerError, string));
        this.resetControllerError();
    }

    public synchronized void removeController(Controller controller) {
        int n = this.getState();
        if (n == 100 || n == 200) {
            throw new NotRealizedError("Cannot remove Controller from an Unrealized Player");
        }
        if (n == 600) {
            throw new ClockStartedError("Cannot remove Controller from a Started Player");
        }
        if (this.controllers.indexOf(controller) == -1) {
            return;
        }
        this.stop();
        this.controllers.removeElement(controller);
        controller.removeControllerListener(this);
        try {
            controller.setTimeBase(null);
        }
        catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
            // empty catch block
        }
        this.updateDuration();
    }

    private void resetControllerError() {
        this.setControllerError(null);
    }

    private void setControllerError(ControllerErrorEvent controllerErrorEvent) {
        this.controllerError = controllerErrorEvent;
    }

    protected void setControlPanelComponent(Component component) {
        this.controlPanelComponent = component;
    }

    protected void setGainControl(GainControl gainControl) {
        if (this.gainControl != null) {
            this.removeControl(this.gainControl);
        }
        this.addControl(gainControl);
        this.gainControl = gainControl;
    }

    public synchronized void setMediaTime(Time time) {
        boolean bl;
        boolean bl2 = bl = this.getState() == 600;
        if (bl) {
            this.stopInRestart();
        }
        super.setMediaTime(time);
        if (bl) {
            this.start();
        }
    }

    public synchronized float setRate(float f) {
        boolean bl;
        boolean bl2 = bl = this.getState() == 600;
        if (bl) {
            this.stopInRestart();
        }
        float f2 = super.setRate(f);
        if (bl) {
            this.start();
        }
        return f2;
    }

    public void setSource(DataSource dataSource) throws IncompatibleSourceException {
        if (this.source != null) {
            throw new IncompatibleSourceException("Datasource already set in MediaHandler " + this.getClass().getName());
        }
        this.source = dataSource;
    }

    protected void setVisualComponent(Component component) {
        this.visualComponent = component;
    }

    public final void start() {
        int n = this.getState();
        int n2 = this.getTargetState();
        if (n == 600) {
            this.postStartEvent();
            return;
        }
        if (n2 < 600) {
            this.setTargetState(600);
        }
        Thread thread = new Thread("Player Start Thread"){

            public void run() {
                if (AbstractPlayer.this.getState() < 600) {
                    AbstractPlayer.this.synchronousStart();
                }
            }
        };
        thread.setName("SynchronousStart Thread for " + this);
        this.getThreadQueue().addThread(thread);
    }

    protected void synchronousStart() {
        if (this.getState() < 500) {
            this.synchronousPrefetch();
            if (this.getState() < 500) {
                return;
            }
        }
        this.synchronousSyncStart(this.getTimeBase().getTime());
    }

    private final synchronized void updateDuration() {
        int n;
        Time time = this.getPlayerDuration();
        if (time != DURATION_UNKNOWN) {
            int n2 = this.controllers.size();
            for (n = 0; n < n2; ++n) {
                Controller controller = (Controller)this.controllers.elementAt(n);
                Time time2 = controller.getDuration();
                if (time2 == DURATION_UNKNOWN) {
                    time = time2;
                    break;
                }
                if (time == DURATION_UNBOUNDED || time2 != DURATION_UNBOUNDED && time2.getNanoseconds() <= time.getNanoseconds()) continue;
                time = time2;
            }
        }
        n = 0;
        if (time == DURATION_UNKNOWN || time == DURATION_UNBOUNDED || this.duration == DURATION_UNKNOWN || this.duration == DURATION_UNBOUNDED) {
            if (this.duration != time) {
                n = 1;
            }
        } else if (this.duration == null || time.getNanoseconds() != this.duration.getNanoseconds()) {
            n = 1;
        }
        if (n != 0) {
            this.duration = time;
            this.postEvent(new DurationUpdateEvent(this, time));
        }
    }
}

