/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.parser.RawParser;

public class RawPullStreamParser
extends RawParser {
    protected SourceStream[] streams;
    protected Track[] tracks = null;
    static final String NAME = "Raw pull stream parser";

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public String getName() {
        return NAME;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        for (int i = 0; i < this.streams.length; ++i) {
            this.tracks[i] = new FrameTrack(this, (PullSourceStream)this.streams[i]);
        }
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        SourceStream[] streams = ((PullDataSource)source).getStreams();
        if (streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
        this.streams = streams;
    }

    public void start() throws IOException {
        this.source.start();
    }

    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PullSourceStream;
    }

    class FrameTrack
    implements Track {
        Demultiplexer parser;
        PullSourceStream pss;
        boolean enabled = true;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);

        public FrameTrack(Demultiplexer parser, PullSourceStream pss) {
            this.pss = pss;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Format getFormat() {
            return this.format;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int frameNumber) {
            return new Time(0L);
        }

        public int mapTimeToFrame(Time t) {
            return -1;
        }

        public void readFrame(Buffer buffer) {
            byte[] data = (byte[])buffer.getData();
            if (data == null) {
                data = new byte[500];
                buffer.setData(data);
            }
            try {
                int len = this.pss.read(data, 0, data.length);
                buffer.setLength(len);
            }
            catch (IOException e) {
                buffer.setDiscard(true);
            }
        }

        public void setEnabled(boolean t) {
            this.enabled = t;
        }

        public void setTrackListener(TrackListener l) {
            this.listener = l;
        }
    }
}

