/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.colorspace;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.BasicCodec;

public class RGBScaler
extends BasicCodec {
    protected float quality = 0.5f;
    private int nativeData = 0;
    private static boolean nativeAvailable = false;

    public RGBScaler() {
        this(null);
    }

    public RGBScaler(Dimension sizeOut) {
        this.inputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 0, -1)};
        if (sizeOut != null) {
            this.setOutputSize(sizeOut);
        }
    }

    public void close() {
        super.close();
        if (nativeAvailable && this.nativeData != 0) {
            try {
                this.nativeClose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return "RGB Scaler";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (RGBScaler.matches(input, this.inputFormats) != null) {
            float frameRate = ((VideoFormat)input).getFrameRate();
            VideoFormat frameRateFormat = new VideoFormat(null, null, -1, null, frameRate);
            return new Format[]{this.outputFormats[0].intersects(frameRateFormat)};
        }
        return new Format[0];
    }

    private native void nativeClose();

    private native void nativeScale(Object var1, long var2, Object var4, long var5, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    protected void nearestNeighbour(Buffer inBuffer, Buffer outBuffer) {
        Object outObj;
        Object inObj;
        RGBFormat vfIn = (RGBFormat)inBuffer.getFormat();
        Dimension sizeIn = vfIn.getSize();
        RGBFormat vfOut = (RGBFormat)outBuffer.getFormat();
        Dimension sizeOut = vfOut.getSize();
        int pixStrideIn = vfIn.getPixelStride();
        int pixStrideOut = vfOut.getPixelStride();
        int lineStrideIn = vfIn.getLineStride();
        int lineStrideOut = vfOut.getLineStride();
        float horRatio = (float)sizeIn.width / (float)sizeOut.width;
        float verRatio = (float)sizeIn.height / (float)sizeOut.height;
        long inBytes = 0L;
        long outBytes = 0L;
        if (nativeAvailable) {
            inObj = this.getInputData(inBuffer);
            outObj = this.validateData(outBuffer, 0, true);
            inBytes = this.getNativeData(inObj);
            outBytes = this.getNativeData(outObj);
        } else {
            inObj = inBuffer.getData();
            outObj = outBuffer.getData();
        }
        if (nativeAvailable) {
            try {
                this.nativeScale(inObj, inBytes, outObj, outBytes, pixStrideIn, lineStrideIn, sizeIn.width, sizeIn.height, pixStrideOut, lineStrideOut, sizeOut.width, sizeOut.height);
            }
            catch (Throwable t) {
                nativeAvailable = false;
            }
        }
        if (!nativeAvailable) {
            byte[] inData = (byte[])inObj;
            byte[] outData = (byte[])outObj;
            for (int y = 0; y < sizeOut.height; ++y) {
                int ptrOut = y * lineStrideOut;
                int ptrIn = (int)((float)y * verRatio) * lineStrideIn;
                for (int x = 0; x < sizeOut.width; ++x) {
                    int ptrIn2 = ptrIn + (int)((float)x * horRatio) * pixStrideIn;
                    outData[ptrOut] = inData[ptrIn2];
                    outData[ptrOut + 1] = inData[ptrIn2 + 1];
                    outData[ptrOut + 2] = inData[ptrIn2 + 2];
                    ptrOut += pixStrideOut;
                }
            }
        }
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        int outputDataLength = ((VideoFormat)this.outputFormat).getMaxDataLength();
        outBuffer.setLength(outputDataLength);
        outBuffer.setFormat(this.outputFormat);
        if (this.quality <= 0.5f) {
            this.nearestNeighbour(inBuffer, outBuffer);
        }
        return 0;
    }

    public Format setInputFormat(Format input) {
        if (RGBScaler.matches(input, this.inputFormats) == null) {
            return null;
        }
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (output == null || RGBScaler.matches(output, this.outputFormats) == null) {
            return null;
        }
        RGBFormat incoming = (RGBFormat)output;
        Dimension size = incoming.getSize();
        int maxDataLength = incoming.getMaxDataLength();
        int lineStride = incoming.getLineStride();
        float frameRate = incoming.getFrameRate();
        int flipped = incoming.getFlipped();
        int endian = incoming.getEndian();
        if (size == null) {
            return null;
        }
        if (maxDataLength < size.width * size.height * 3) {
            maxDataLength = size.width * size.height * 3;
        }
        if (lineStride < size.width * 3) {
            lineStride = size.width * 3;
        }
        if (flipped != 0) {
            flipped = 0;
        }
        this.outputFormat = this.outputFormats[0].intersects(new RGBFormat(size, maxDataLength, null, frameRate, -1, -1, -1, -1, -1, lineStride, -1, -1));
        return this.outputFormat;
    }

    public void setOutputSize(Dimension sizeOut) {
        this.outputFormats = new Format[]{new RGBFormat(sizeOut, sizeOut.width * sizeOut.height * 3, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, sizeOut.width * 3, 0, -1)};
    }
}

