/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rtcp;

import java.util.LinkedList;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import org.jitsi.impl.neomedia.rtcp.NACKPacket;
import org.jitsi.service.neomedia.Transformer;
import org.jitsi.videobridge.rtcp.NACKHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NACKNotifier
implements Transformer<RTCPCompoundPacket> {
    private NACKHandler handler;
    private boolean enabled = true;

    public NACKNotifier(NACKHandler handler) {
        this.handler = handler;
    }

    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket inPacket) {
        if (!this.enabled || inPacket == null || inPacket.packets == null || inPacket.packets.length == 0) {
            return inPacket;
        }
        LinkedList<RTCPPacket> outPackets = new LinkedList<RTCPPacket>();
        boolean removed = false;
        for (RTCPPacket p : inPacket.packets) {
            if (p != null && p instanceof NACKPacket) {
                NACKPacket nack = (NACKPacket)p;
                this.handler.handleNACK(nack);
                removed = true;
                continue;
            }
            outPackets.add(p);
        }
        if (removed) {
            if (outPackets.size() > 0) {
                return new RTCPCompoundPacket(outPackets.toArray(new RTCPPacket[outPackets.size()]));
            }
            return null;
        }
        return inPacket;
    }

    public void close() {
    }

    public RTCPCompoundPacket transform(RTCPCompoundPacket inPacket) {
        return inPacket;
    }
}

