/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import net.sf.jqql.QQClient;
import net.sf.jqql.net.IConnection;
import net.sf.jqql.net.IConnectionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum QQPort {
    MAIN("Main"),
    CLUSTER_CUSTOM_FACE("Cluster Custom Face"),
    CUSTOM_HEAD_INFO("Custom Head Info"),
    CUSTOM_HEAD_DATA("Custom Head Data");

    public String name;
    static final Log log;

    private QQPort(String string2) {
        this.name = string2;
    }

    public IConnection create(QQClient qQClient, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, boolean bl) throws IOException {
        return this.create(qQClient, inetSocketAddress, inetSocketAddress2, null, null, bl);
    }

    public IConnection create(QQClient qQClient, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, String string2, boolean bl) throws IOException, UnknownHostException {
        IConnection iConnection = null;
        IConnectionPolicy iConnectionPolicy = null;
        switch (this) {
            case MAIN: {
                iConnectionPolicy = qQClient.getConnectionPolicyFactory().createPolicy(qQClient, this.name, 1, 1, inetSocketAddress2, string, string2);
                int n = qQClient.getProxyType();
                if (qQClient.getUser().isUdp()) {
                    log.debug((Object)("\u8fde\u63a5UDP\u670d\u52a1\u5668: " + inetSocketAddress));
                    if (n == 2) {
                        log.debug((Object)("\u4f7f\u7528Socks 5\u4ee3\u7406 " + inetSocketAddress2));
                        iConnection = qQClient.getConnectionPool().newUDPSocks5Connection(iConnectionPolicy, inetSocketAddress, bl);
                        break;
                    }
                    iConnection = qQClient.getConnectionPool().newUDPConnection(iConnectionPolicy, inetSocketAddress, bl);
                    break;
                }
                log.debug((Object)("\u8fde\u63a5TCP\u670d\u52a1\u5668: " + inetSocketAddress));
                if (n == 2) {
                    log.debug((Object)("\u4f7f\u7528Socks 5\u4ee3\u7406 " + inetSocketAddress2));
                    iConnection = qQClient.getConnectionPool().newTCPSocks5Connection(iConnectionPolicy, inetSocketAddress, bl);
                    break;
                }
                if (n == 1) {
                    log.debug((Object)("\u4f7f\u7528HTTP\u4ee3\u7406 " + inetSocketAddress2));
                    iConnection = qQClient.getConnectionPool().newTCPHttpConnection(iConnectionPolicy, inetSocketAddress, bl);
                    break;
                }
                iConnection = qQClient.getConnectionPool().newTCPConnection(iConnectionPolicy, inetSocketAddress, bl);
                break;
            }
            case CLUSTER_CUSTOM_FACE: {
                iConnectionPolicy = qQClient.getConnectionPolicyFactory().createPolicy(qQClient, this.name, 2, 2, inetSocketAddress2, string, string2);
                iConnection = qQClient.getConnectionPool().newTCPConnection(iConnectionPolicy, inetSocketAddress, bl);
                break;
            }
            case CUSTOM_HEAD_INFO: 
            case CUSTOM_HEAD_DATA: {
                iConnectionPolicy = qQClient.getConnectionPolicyFactory().createPolicy(qQClient, this.name, 4, 4, inetSocketAddress2, string, string2);
                iConnection = qQClient.getConnectionPool().newUDPConnection(iConnectionPolicy, inetSocketAddress, bl);
            }
        }
        return iConnection;
    }

    static {
        log = LogFactory.getLog(QQPort.class);
    }
}

