/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.outgoing;

import net.sf.jml.MsnProtocol;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.util.StringUtils;

public class OutgoingUUN
extends MsnOutgoingMessage {
    private boolean accept = false;
    private String machineGuid = null;

    public OutgoingUUN(MsnProtocol msnProtocol) {
        super(msnProtocol);
        this.setCommand("UUN");
    }

    protected boolean isSupportChunkData() {
        return true;
    }

    public void setData(String string, boolean bl) {
        this.machineGuid = string;
        this.accept = bl;
        this.buildData();
    }

    private void buildData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SNM opcode=\"");
        if (this.accept) {
            stringBuffer.append("ACK");
        } else {
            stringBuffer.append("NAK");
        }
        stringBuffer.append("\" csid=\"");
        if (this.machineGuid != null) {
            stringBuffer.append(StringUtils.xmlEscaping(this.machineGuid));
        }
        if (!this.accept) {
            stringBuffer.append("\" reason=\"0x80070490");
        }
        stringBuffer.append("\" />");
        this.setChunkData(stringBuffer.toString());
    }
}

