/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnGroup;
import net.sf.jml.impl.MsnContactImpl;

public class MsnGroupImpl
implements MsnGroup {
    private final MsnContactList contactList;
    private final boolean defaultGroup;
    private String groupId;
    private String groupName;
    private final Set<MsnContact> contacts = new LinkedHashSet<MsnContact>();

    public MsnGroupImpl(MsnContactList msnContactList) {
        this(msnContactList, false);
    }

    public MsnGroupImpl(MsnContactList msnContactList, boolean bl) {
        this.contactList = msnContactList;
        this.defaultGroup = bl;
    }

    public MsnContactList getContactList() {
        return this.contactList;
    }

    public boolean isDefaultGroup() {
        return this.defaultGroup;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnContact[] getContacts() {
        Set<MsnContact> set = this.contacts;
        synchronized (set) {
            MsnContact[] msnContactArray = new MsnContact[this.contacts.size()];
            this.contacts.toArray(msnContactArray);
            return msnContactArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containContact(MsnContact msnContact) {
        Set<MsnContact> set = this.contacts;
        synchronized (set) {
            return this.contacts.contains(msnContact);
        }
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void addContact(String string) {
        MsnContact msnContact = this.getContactList().getContactById(string);
        if (msnContact != null) {
            this.addContact(msnContact);
        }
    }

    public void removeContact(String string) {
        MsnContact msnContact = this.getContactList().getContactById(string);
        if (msnContact != null) {
            this.removeContact(msnContact);
        }
    }

    public void clear() {
        MsnContact[] msnContactArray;
        for (MsnContact msnContact : msnContactArray = this.getContacts()) {
            this.removeContact(msnContact);
        }
    }

    void addContact(MsnContact msnContact) {
        this.contacts.add(msnContact);
        if (!msnContact.belongGroup(this)) {
            ((MsnContactImpl)msnContact).addBelongGroup(this);
        }
    }

    void removeContact(MsnContact msnContact) {
        if (this.contacts.remove(msnContact) && msnContact.belongGroup(this)) {
            ((MsnContactImpl)msnContact).removeBelongGroup(this);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MsnGroupImpl)) {
            return false;
        }
        MsnGroupImpl msnGroupImpl = (MsnGroupImpl)object;
        if (this.defaultGroup != msnGroupImpl.defaultGroup) {
            return false;
        }
        if (!(this.groupId != null ? this.groupId.equals(msnGroupImpl.groupId) : msnGroupImpl.groupId == null)) {
            return false;
        }
        return this.contactList == null ? msnGroupImpl.contactList == null : this.contactList.equals(msnGroupImpl.contactList);
    }

    public int hashCode() {
        return this.groupId == null ? 0 : this.groupId.hashCode();
    }

    public String toString() {
        return "MsnGroup: [GroupId] " + this.groupId + " [GroupName] " + this.groupName;
    }
}

