/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.xa.FinalizeRemoteTransactionOperation;
import java.io.IOException;
import java.security.Permission;

public class FinalizeXATransactionRequest
extends PartitionClientRequest {
    private Data xidData;
    private boolean isCommit;

    public FinalizeXATransactionRequest() {
    }

    public FinalizeXATransactionRequest(Data xidData, boolean isCommit) {
        this.xidData = xidData;
        this.isCommit = isCommit;
    }

    @Override
    protected Operation prepareOperation() {
        return new FinalizeRemoteTransactionOperation(this.xidData, this.isCommit);
    }

    @Override
    protected int getPartition() {
        return this.getClientEngine().getPartitionService().getPartitionId(this.xidData);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeBoolean("c", this.isCommit);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        rawDataOutput.writeData(this.xidData);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.isCommit = reader.readBoolean("c");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.xidData = rawDataInput.readData();
    }
}

