/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

final class FinalizeMigrationOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    private final MigrationEndpoint endpoint;
    private final boolean success;

    public FinalizeMigrationOperation(MigrationEndpoint endpoint, boolean success) {
        this.endpoint = endpoint;
        this.success = success;
    }

    @Override
    public void run() {
        int partitionId;
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        MigrationInfo migrationInfo = partitionService.getActiveMigration(partitionId = this.getPartitionId());
        if (migrationInfo == null) {
            return;
        }
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionMigrationEvent event = new PartitionMigrationEvent(this.endpoint, partitionId);
        for (MigrationAwareService service : nodeEngine.getServices(MigrationAwareService.class)) {
            this.finishMigration(event, service);
        }
        if (this.endpoint == MigrationEndpoint.SOURCE && this.success) {
            partitionService.clearPartitionReplicaVersions(partitionId);
        } else if (this.endpoint == MigrationEndpoint.DESTINATION && !this.success) {
            partitionService.clearPartitionReplicaVersions(partitionId);
        }
        partitionService.removeActiveMigration(partitionId);
        if (this.success) {
            nodeEngine.onPartitionMigrate(migrationInfo);
        }
    }

    private void finishMigration(PartitionMigrationEvent event, MigrationAwareService service) {
        try {
            if (this.success) {
                service.commitMigration(event);
            } else {
                service.rollbackMigration(event);
            }
        }
        catch (Throwable e) {
            this.getLogger().warning("Error while finalizing migration -> " + event, e);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

