/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mathzrtp.ec;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import java.util.Random;
import org.bouncycastle.mathzrtp.ec.ECConstants;
import org.bouncycastle.mathzrtp.ec.ECFieldElement;
import org.bouncycastle.mathzrtp.ec.ECPoint;
import org.bouncycastle.mathzrtp.ec.Tnaf;

public abstract class ECCurve {
    ECFieldElement a;
    ECFieldElement b;

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigIntegerCrypto var1);

    public abstract ECPoint createPoint(BigIntegerCrypto var1, BigIntegerCrypto var2, boolean var3);

    public abstract ECPoint decodePoint(byte[] var1);

    public abstract ECPoint getInfinity();

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public static class F2m
    extends ECCurve {
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private BigIntegerCrypto n;
        private BigIntegerCrypto h;
        private ECPoint.F2m infinity;
        private byte mu = 0;
        private BigIntegerCrypto[] si = null;

        public F2m(int m, int k, BigIntegerCrypto a, BigIntegerCrypto b) {
            this(m, k, 0, 0, a, b, null, null);
        }

        public F2m(int m, int k, BigIntegerCrypto a, BigIntegerCrypto b, BigIntegerCrypto n, BigIntegerCrypto h) {
            this(m, k, 0, 0, a, b, n, h);
        }

        public F2m(int m, int k1, int k2, int k3, BigIntegerCrypto a, BigIntegerCrypto b) {
            this(m, k1, k2, k3, a, b, null, null);
        }

        public F2m(int m, int k1, int k2, int k3, BigIntegerCrypto a, BigIntegerCrypto b, BigIntegerCrypto n, BigIntegerCrypto h) {
            this.m = m;
            this.k1 = k1;
            this.k2 = k2;
            this.k3 = k3;
            this.n = n;
            this.h = h;
            if (k1 == 0) {
                throw new IllegalArgumentException("k1 must be > 0");
            }
            if (k2 == 0) {
                if (k3 != 0) {
                    throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
                }
            } else {
                if (k2 <= k1) {
                    throw new IllegalArgumentException("k2 must be > k1");
                }
                if (k3 <= k2) {
                    throw new IllegalArgumentException("k3 must be > k2");
                }
            }
            this.a = this.fromBigInteger(a);
            this.b = this.fromBigInteger(b);
            this.infinity = new ECPoint.F2m(this, null, null);
        }

        public int getFieldSize() {
            return this.m;
        }

        public ECFieldElement fromBigInteger(BigIntegerCrypto x) {
            return new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, x);
        }

        public ECPoint createPoint(BigIntegerCrypto x, BigIntegerCrypto y, boolean withCompression) {
            return new ECPoint.F2m(this, this.fromBigInteger(x), this.fromBigInteger(y), withCompression);
        }

        public ECPoint decodePoint(byte[] encoded) {
            ECPoint p = null;
            switch (encoded[0]) {
                case 0: {
                    p = this.getInfinity();
                    break;
                }
                case 2: 
                case 3: {
                    byte[] enc = new byte[encoded.length - 1];
                    System.arraycopy(encoded, 1, enc, 0, enc.length);
                    if (encoded[0] == 2) {
                        p = this.decompressPoint(enc, 0);
                        break;
                    }
                    p = this.decompressPoint(enc, 1);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    byte[] xEnc = new byte[(encoded.length - 1) / 2];
                    byte[] yEnc = new byte[(encoded.length - 1) / 2];
                    System.arraycopy(encoded, 1, xEnc, 0, xEnc.length);
                    System.arraycopy(encoded, xEnc.length + 1, yEnc, 0, yEnc.length);
                    p = new ECPoint.F2m(this, new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigIntegerCrypto(1, xEnc)), new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigIntegerCrypto(1, yEnc)), false);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(encoded[0], 16));
                }
            }
            return p;
        }

        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean isKoblitz() {
            return this.n != null && this.h != null && (this.a.toBigInteger().equals(ECConstants.ZERO) || this.a.toBigInteger().equals(ECConstants.ONE)) && this.b.toBigInteger().equals(ECConstants.ONE);
        }

        synchronized byte getMu() {
            if (this.mu == 0) {
                this.mu = Tnaf.getMu(this);
            }
            return this.mu;
        }

        synchronized BigIntegerCrypto[] getSi() {
            if (this.si == null) {
                this.si = Tnaf.getSi(this);
            }
            return this.si;
        }

        private ECPoint decompressPoint(byte[] xEnc, int ypBit) {
            ECFieldElement.F2m xp = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigIntegerCrypto(1, xEnc));
            ECFieldElement yp = null;
            if (((ECFieldElement)xp).toBigInteger().equals(ECConstants.ZERO)) {
                yp = this.b;
                for (int i = 0; i < this.m - 1; ++i) {
                    yp = yp.square();
                }
            } else {
                ECFieldElement beta = ((ECFieldElement)xp).add(this.a).add(this.b.multiply(((ECFieldElement)xp).square().invert()));
                ECFieldElement z = this.solveQuadradicEquation(beta);
                if (z == null) {
                    throw new RuntimeException("Invalid point compression");
                }
                int zBit = 0;
                if (z.toBigInteger().testBit(0)) {
                    zBit = 1;
                }
                if (zBit != ypBit) {
                    z = z.add(new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, ECConstants.ONE));
                }
                yp = ((ECFieldElement)xp).multiply(z);
            }
            return new ECPoint.F2m(this, xp, yp);
        }

        private ECFieldElement solveQuadradicEquation(ECFieldElement beta) {
            ECFieldElement.F2m zeroElement = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, ECConstants.ZERO);
            if (beta.toBigInteger().equals(ECConstants.ZERO)) {
                return zeroElement;
            }
            ECFieldElement z = null;
            ECFieldElement gamma = zeroElement;
            Random rand = new Random();
            do {
                ECFieldElement.F2m t = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigIntegerCrypto(this.m, rand));
                z = zeroElement;
                ECFieldElement w = beta;
                for (int i = 1; i <= this.m - 1; ++i) {
                    ECFieldElement w2 = w.square();
                    z = ((ECFieldElement)z).square().add(w2.multiply(t));
                    w = w2.add(beta);
                }
                if (w.toBigInteger().equals(ECConstants.ZERO)) continue;
                return null;
            } while ((gamma = ((ECFieldElement)z).square().add(z)).toBigInteger().equals(ECConstants.ZERO));
            return z;
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof F2m)) {
                return false;
            }
            F2m other = (F2m)anObject;
            return this.m == other.m && this.k1 == other.k1 && this.k2 == other.k2 && this.k3 == other.k3 && this.a.equals(other.a) && this.b.equals(other.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
        }

        public int getM() {
            return this.m;
        }

        public boolean isTrinomial() {
            return this.k2 == 0 && this.k3 == 0;
        }

        public int getK1() {
            return this.k1;
        }

        public int getK2() {
            return this.k2;
        }

        public int getK3() {
            return this.k3;
        }

        public BigIntegerCrypto getN() {
            return this.n;
        }

        public BigIntegerCrypto getH() {
            return this.h;
        }
    }

    public static class Fp
    extends ECCurve {
        BigIntegerCrypto q;
        ECPoint.Fp infinity;

        public Fp(BigIntegerCrypto q, BigIntegerCrypto a, BigIntegerCrypto b) {
            this.q = q;
            this.a = this.fromBigInteger(a);
            this.b = this.fromBigInteger(b);
            this.infinity = new ECPoint.Fp(this, null, null);
        }

        public BigIntegerCrypto getQ() {
            return this.q;
        }

        public int getFieldSize() {
            return this.q.bitLength();
        }

        public ECFieldElement fromBigInteger(BigIntegerCrypto x) {
            return new ECFieldElement.Fp(this.q, x);
        }

        public ECPoint createPoint(BigIntegerCrypto x, BigIntegerCrypto y, boolean withCompression) {
            return new ECPoint.Fp(this, this.fromBigInteger(x), this.fromBigInteger(y), withCompression);
        }

        public ECPoint decodePoint(byte[] encoded) {
            ECPoint p = null;
            switch (encoded[0]) {
                case 0: {
                    p = this.getInfinity();
                    break;
                }
                case 2: 
                case 3: {
                    int bit0;
                    int ytilde = encoded[0] & 1;
                    byte[] i = new byte[encoded.length - 1];
                    System.arraycopy(encoded, 1, i, 0, i.length);
                    ECFieldElement.Fp x = new ECFieldElement.Fp(this.q, new BigIntegerCrypto(1, i));
                    ECFieldElement alpha = ((ECFieldElement)x).multiply(((ECFieldElement)x).square().add(this.a)).add(this.b);
                    ECFieldElement beta = alpha.sqrt();
                    if (beta == null) {
                        throw new RuntimeException("Invalid point compression");
                    }
                    int n = bit0 = beta.toBigInteger().testBit(0) ? 1 : 0;
                    if (bit0 == ytilde) {
                        p = new ECPoint.Fp(this, x, beta, true);
                        break;
                    }
                    p = new ECPoint.Fp(this, x, new ECFieldElement.Fp(this.q, this.q.subtract(beta.toBigInteger())), true);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    byte[] xEnc = new byte[(encoded.length - 1) / 2];
                    byte[] yEnc = new byte[(encoded.length - 1) / 2];
                    System.arraycopy(encoded, 1, xEnc, 0, xEnc.length);
                    System.arraycopy(encoded, xEnc.length + 1, yEnc, 0, yEnc.length);
                    p = new ECPoint.Fp(this, new ECFieldElement.Fp(this.q, new BigIntegerCrypto(1, xEnc)), new ECFieldElement.Fp(this.q, new BigIntegerCrypto(1, yEnc)));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(encoded[0], 16));
                }
            }
            return p;
        }

        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof Fp)) {
                return false;
            }
            Fp other = (Fp)anObject;
            return this.q.equals(other.q) && this.a.equals(other.a) && this.b.equals(other.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.q.hashCode();
        }
    }
}

