/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.GGException;
import pl.mn.communicator.MessageStatus;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.handlers.PacketContext;
import pl.mn.communicator.packet.handlers.PacketHandler;
import pl.mn.communicator.packet.in.GGSendMsgAck;

public class GGSentMessageAckPacketHandler
implements PacketHandler {
    private static final Log logger = LogFactory.getLog((Class)GGSentMessageAckPacketHandler.class);

    public void handle(PacketContext context) throws GGException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"GGSentMessageAck packet received.");
            logger.debug((Object)("PacketHeader: " + context.getHeader()));
            logger.debug((Object)("PacketBody: " + GGUtils.prettyBytesToString(context.getPackageContent())));
        }
        GGSendMsgAck sendMessageAck = new GGSendMsgAck(context.getPackageContent());
        context.getSessionAccessor().notifyGGPacketReceived(sendMessageAck);
        int uin = sendMessageAck.getRecipientUin();
        int messageID = sendMessageAck.getMessageSeq();
        MessageStatus messageStatus = GGConversion.getClientMessageStatus(sendMessageAck.getMessageStatus());
        context.getSessionAccessor().notifyMessageDelivered(uin, messageID, messageStatus);
    }
}

