/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicInstantMessagingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ChatState;
import org.jivesoftware.smackx.ChatStateListener;
import org.jivesoftware.smackx.ChatStateManager;
import org.jivesoftware.smackx.MessageEventManager;
import org.jivesoftware.smackx.MessageEventNotificationListener;
import org.jivesoftware.smackx.MessageEventRequestListener;

public class OperationSetTypingNotificationsJabberImpl
extends AbstractOperationSetTypingNotifications<ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetTypingNotificationsJabberImpl.class);
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private OperationSetBasicInstantMessagingJabberImpl opSetBasicIM = null;
    private ProviderRegListener providerRegListener = new ProviderRegListener();
    private MessageEventManager messageEventManager = null;
    private SmackChatStateListener smackChatStateListener = null;
    private SmackChatManagerListener smackChatManagerListener = null;

    OperationSetTypingNotificationsJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        super((ProtocolProviderService)provider);
        provider.addRegistrationStateChangeListener(this.providerRegListener);
    }

    public void sendTypingNotification(Contact notifiedContact, int typingState) throws IllegalStateException, IllegalArgumentException {
        this.assertConnected();
        if (!(notifiedContact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not a Jabber contact." + notifiedContact);
        }
        this.sendXep85ChatState(notifiedContact, typingState);
    }

    private void sendXep85ChatState(Contact contact, int state) {
        String toJID = null;
        if (toJID == null) {
            toJID = this.opSetBasicIM.getJidForAddress(contact.getAddress());
        }
        if (toJID == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Sending XEP-0085 chat state=" + state + " to " + toJID));
        }
        Chat chat = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().getChatManager().createChat(toJID, null);
        ChatState chatState = null;
        chatState = state == 1 ? ChatState.composing : (state == 4 ? ChatState.inactive : (state == 3 ? ChatState.paused : ChatState.gone));
        try {
            ChatStateManager.getInstance((Connection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection()).setCurrentState(chatState, chat);
        }
        catch (XMPPException exc) {
            logger.warn((Object)("Failed to send state [" + state + "] to [" + contact.getAddress() + "]."), (Throwable)exc);
        }
    }

    protected void assertConnected() throws IllegalStateException {
        if (this.parentProvider != null && !((ProtocolProviderServiceJabberImpl)this.parentProvider).isRegistered() && this.opSetPersPresence.getPresenceStatus().isOnline()) {
            this.opSetPersPresence.fireProviderStatusChangeEvent(this.opSetPersPresence.getPresenceStatus(), (PresenceStatus)((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline"));
        }
        super.assertConnected();
    }

    private class IncomingMessageEventsListener
    implements MessageEventNotificationListener {
        private IncomingMessageEventsListener() {
        }

        public void deliveredNotification(String from, String packetID) {
        }

        public void displayedNotification(String from, String packetID) {
        }

        public void composingNotification(String from, String packetID) {
            String fromID = StringUtils.parseBareAddress((String)from);
            Object sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID(fromID);
            if (sourceContact == null) {
                sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(from);
            }
            OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, 1);
        }

        public void offlineNotification(String from, String packetID) {
        }

        public void cancelledNotification(String from, String packetID) {
            String fromID = StringUtils.parseBareAddress((String)from);
            Object sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID(fromID);
            if (sourceContact == null) {
                sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(from);
            }
            OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, 4);
        }
    }

    private class JabberMessageEventRequestListener
    implements MessageEventRequestListener {
        private JabberMessageEventRequestListener() {
        }

        public void deliveredNotificationRequested(String from, String packetID, MessageEventManager messageEventManager) {
            messageEventManager.sendDeliveredNotification(from, packetID);
        }

        public void displayedNotificationRequested(String from, String packetID, MessageEventManager messageEventManager) {
            messageEventManager.sendDisplayedNotification(from, packetID);
        }

        public void composingNotificationRequested(String from, String packetID, MessageEventManager messageEventManager) {
        }

        public void offlineNotificationRequested(String from, String packetID, MessageEventManager messageEventManager) {
        }
    }

    private class ProviderRegListener
    implements RegistrationStateChangeListener {
        private ProviderRegListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetPersistentPresence.class);
                OperationSetTypingNotificationsJabberImpl.this.opSetBasicIM = (OperationSetBasicInstantMessagingJabberImpl)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetBasicInstantMessaging.class);
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager = new MessageEventManager((Connection)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection());
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager.addMessageEventRequestListener((MessageEventRequestListener)new JabberMessageEventRequestListener());
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager.addMessageEventNotificationListener((MessageEventNotificationListener)new IncomingMessageEventsListener());
                ChatStateManager.getInstance((Connection)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection());
                if (OperationSetTypingNotificationsJabberImpl.this.smackChatManagerListener == null) {
                    OperationSetTypingNotificationsJabberImpl.this.smackChatManagerListener = new SmackChatManagerListener();
                }
                ((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection().getChatManager().addChatListener((ChatManagerListener)OperationSetTypingNotificationsJabberImpl.this.smackChatManagerListener);
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                if (((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection() != null && ((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection().getChatManager() != null) {
                    ((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection().getChatManager().removeChatListener((ChatManagerListener)OperationSetTypingNotificationsJabberImpl.this.smackChatManagerListener);
                }
                OperationSetTypingNotificationsJabberImpl.this.smackChatManagerListener = null;
                if (OperationSetTypingNotificationsJabberImpl.this.messageEventManager != null) {
                    OperationSetTypingNotificationsJabberImpl.this.messageEventManager.destroy();
                    OperationSetTypingNotificationsJabberImpl.this.messageEventManager = null;
                }
            }
        }
    }

    private class SmackChatManagerListener
    implements ChatManagerListener {
        private SmackChatManagerListener() {
        }

        public void chatCreated(Chat chat, boolean isLocal) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Created a chat with " + chat.getParticipant() + " local=" + isLocal));
            }
            if (OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener == null) {
                OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener = new SmackChatStateListener();
            }
            chat.addMessageListener((MessageListener)OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener);
        }
    }

    private class SmackChatStateListener
    implements ChatStateListener {
        private SmackChatStateListener() {
        }

        public void stateChanged(Chat chat, ChatState state, Message message) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(String.valueOf(chat.getParticipant()) + " entered the " + state.name() + " state."));
            }
            String fromID = StringUtils.parseBareAddress((String)chat.getParticipant());
            List chatRooms = ((OperationSetMultiUserChat)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetMultiUserChat.class)).getCurrentlyJoinedChatRooms();
            boolean isPrivateMessagingAddress = false;
            for (ChatRoom chatRoom : chatRooms) {
                if (!chatRoom.getName().equals(fromID)) continue;
                isPrivateMessagingAddress = true;
                break;
            }
            Object sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID(isPrivateMessagingAddress ? message.getFrom() : fromID);
            if (sourceContact == null) {
                sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(chat.getParticipant(), isPrivateMessagingAddress);
            }
            int evtCode = 0;
            if (ChatState.composing.equals((Object)state)) {
                evtCode = 1;
            } else if (ChatState.paused.equals((Object)state) || ChatState.active.equals((Object)state)) {
                evtCode = 3;
            } else if (ChatState.inactive.equals((Object)state) || ChatState.gone.equals((Object)state)) {
                evtCode = 4;
            }
            if (message.getError() != null) {
                OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsDeliveryFailedEvent((Contact)sourceContact, evtCode);
            } else if (evtCode != 0) {
                OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, evtCode);
            } else {
                logger.warn((Object)"Unknown typing state!");
            }
        }

        public void processMessage(Chat chat, Message msg) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"ignoring a process message");
            }
        }
    }
}

