/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.control.BufferControl;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceStream;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.Participant;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.TimeoutEvent;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.MediaStreamStatsImpl;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.StreamRTPManager;
import org.jitsi.impl.neomedia.device.AbstractMediaDevice;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.device.VideoMediaDeviceSession;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.protocol.TranscodingDataSource;
import org.jitsi.impl.neomedia.transform.RTPTransformTCPConnector;
import org.jitsi.impl.neomedia.transform.RTPTransformUDPConnector;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.impl.neomedia.transform.TransformTCPInputStream;
import org.jitsi.impl.neomedia.transform.TransformTCPOutputStream;
import org.jitsi.impl.neomedia.transform.TransformUDPInputStream;
import org.jitsi.impl.neomedia.transform.TransformUDPOutputStream;
import org.jitsi.impl.neomedia.transform.csrc.CsrcTransformEngine;
import org.jitsi.impl.neomedia.transform.csrc.SsrcTransformEngine;
import org.jitsi.impl.neomedia.transform.dtmf.DtmfTransformEngine;
import org.jitsi.impl.neomedia.transform.pt.PayloadTypeTransformEngine;
import org.jitsi.impl.neomedia.transform.rtcp.StatisticsEngine;
import org.jitsi.impl.neomedia.transform.zrtp.ZRTPTransformEngine;
import org.jitsi.service.neomedia.AbstractMediaStream;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStreamStats;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.SSRCFactory;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.control.PacketLossAwareEncoder;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.Logger;

public class MediaStreamImpl
extends AbstractMediaStream
implements ReceiveStreamListener,
SendStreamListener,
SessionListener,
RemoteListener {
    private static final Logger logger = Logger.getLogger(MediaStreamImpl.class);
    protected static final String PROPERTY_NAME_RECEIVE_BUFFER_LENGTH = "net.java.sip.communicator.impl.neomedia.RECEIVE_BUFFER_LENGTH";
    private MediaDeviceSession deviceSession;
    private final PropertyChangeListener deviceSessionPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String propertyName = ev.getPropertyName();
            if ("OUTPUT_DATA_SOURCE".equals(propertyName)) {
                MediaStreamImpl.this.deviceSessionOutputDataSourceChanged();
            } else if ("SSRC_LIST".equals(propertyName)) {
                MediaStreamImpl.this.deviceSessionSsrcListChanged(ev);
            }
        }
    };
    private MediaDirection direction;
    private final Map<Byte, MediaFormat> dynamicRTPPayloadTypes = new HashMap<Byte, MediaFormat>();
    private final List<ReceiveStream> receiveStreams = new LinkedList<ReceiveStream>();
    private final ReadWriteLock receiveStreamsLock = new ReentrantReadWriteLock();
    private AbstractRTPConnector rtpConnector;
    private MediaStreamTarget rtpConnectorTarget;
    private StreamRTPManager rtpManager;
    private RTPTranslator rtpTranslator;
    protected boolean sendStreamsAreCreated = false;
    private boolean started = false;
    private MediaDirection startedDirection;
    private final Vector<Long> remoteSourceIDs = new Vector(1, 1);
    private long localSourceID = -1L;
    private long[] localContributingSourceIDs;
    private boolean mute = false;
    private final Map<Byte, RTPExtension> activeRTPExtensions = new Hashtable<Byte, RTPExtension>();
    private CsrcTransformEngine csrcEngine;
    private final SrtpControl srtpControl;
    private long numberOfReceivedSenderReports = 0L;
    private long numberOfReceivedReceiverReports = 0L;
    private long maxRemoteInterArrivalJitter = 0L;
    private long minRemoteInterArrivalJitter = -1L;
    private StatisticsEngine statisticsEngine = null;
    private MediaStreamStatsImpl mediaStreamStatsImpl;
    private PayloadTypeTransformEngine ptTransformEngine;
    private SSRCFactory ssrcFactory;

    public MediaStreamImpl(MediaDevice device, SrtpControl srtpControl) {
        this(null, device, srtpControl);
    }

    public MediaStreamImpl(StreamConnector connector, MediaDevice device, SrtpControl srtpControl) {
        if (device != null) {
            this.setDevice(device);
        }
        SrtpControl srtpControl2 = this.srtpControl = srtpControl == null ? NeomediaServiceUtils.getMediaServiceImpl().createSrtpControl(SrtpControlType.ZRTP) : srtpControl;
        if (connector != null) {
            this.setConnector(connector);
        }
        this.mediaStreamStatsImpl = new MediaStreamStatsImpl(this);
        if (logger.isTraceEnabled()) {
            logger.trace("Created " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode());
        }
    }

    protected void configureDataOutputStream(RTPConnectorOutputStream dataOutputStream) {
        dataOutputStream.setPriority(this.getPriority());
    }

    protected void configureDataInputStream(RTPConnectorInputStream dataInputStream) {
        dataInputStream.setPriority(this.getPriority());
    }

    protected void configureRTPManagerBufferControl(StreamRTPManager rtpManager, BufferControl bufferControl) {
    }

    private TransformEngineChain createTransformEngineChain() {
        ArrayList<Object> engineChain = new ArrayList<Object>(5);
        if (this.csrcEngine == null) {
            this.csrcEngine = new CsrcTransformEngine(this);
        }
        engineChain.add(this.csrcEngine);
        DtmfTransformEngine dtmfEngine = this.createDtmfTransformEngine();
        if (dtmfEngine != null) {
            engineChain.add(dtmfEngine);
        }
        if (this.statisticsEngine == null) {
            this.statisticsEngine = new StatisticsEngine(this);
        }
        engineChain.add(this.statisticsEngine);
        if (this.ptTransformEngine == null) {
            this.ptTransformEngine = new PayloadTypeTransformEngine();
        }
        engineChain.add(this.ptTransformEngine);
        engineChain.add(this.srtpControl.getTransformEngine());
        SsrcTransformEngine ssrcEngine = this.createSsrcTransformEngine();
        if (ssrcEngine != null) {
            engineChain.add(ssrcEngine);
        }
        return new TransformEngineChain(engineChain.toArray(new TransformEngine[engineChain.size()]));
    }

    protected DtmfTransformEngine createDtmfTransformEngine() {
        return null;
    }

    protected SsrcTransformEngine createSsrcTransformEngine() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDynamicRTPPayloadType(byte rtpPayloadType, MediaFormat format) {
        MediaFormatImpl mediaFormatImpl = (MediaFormatImpl)format;
        Map<Byte, MediaFormat> map = this.dynamicRTPPayloadTypes;
        synchronized (map) {
            this.dynamicRTPPayloadTypes.put(rtpPayloadType, format);
            if (this.rtpManager != null) {
                this.rtpManager.addFormat((Format)mediaFormatImpl.getFormat(), rtpPayloadType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRTPExtension(byte extensionID, RTPExtension rtpExtension) {
        Map<Byte, RTPExtension> map = this.activeRTPExtensions;
        synchronized (map) {
            if (MediaDirection.INACTIVE.equals((Object)rtpExtension.getDirection())) {
                this.activeRTPExtensions.remove(extensionID);
            } else {
                this.activeRTPExtensions.put(extensionID, rtpExtension);
            }
        }
    }

    private void assertDirection(MediaDirection direction, MediaDirection deviceDirection, String illegalArgumentExceptionMessage) throws IllegalArgumentException {
        if (direction != null && !direction.and(deviceDirection).equals((Object)direction)) {
            throw new IllegalArgumentException(illegalArgumentExceptionMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Byte, RTPExtension> getActiveRTPExtensions() {
        Map<Byte, RTPExtension> map = this.activeRTPExtensions;
        synchronized (map) {
            return new HashMap<Byte, RTPExtension>(this.activeRTPExtensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getActiveRTPExtensionID(RTPExtension rtpExtension) {
        Map<Byte, RTPExtension> map = this.activeRTPExtensions;
        synchronized (map) {
            for (Map.Entry<Byte, RTPExtension> entry : this.activeRTPExtensions.entrySet()) {
                if (!entry.getValue().equals(rtpExtension)) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    protected CsrcTransformEngine getCsrcEngine() {
        return this.csrcEngine;
    }

    @Override
    public void close() {
        if (logger.isInfoEnabled()) {
            this.printReceiveStreamStatistics();
        }
        this.stop();
        this.closeSendStreams();
        this.srtpControl.cleanup();
        if (this.csrcEngine != null) {
            this.csrcEngine.close();
            this.csrcEngine = null;
        }
        if (this.rtpManager != null) {
            if (logger.isInfoEnabled()) {
                this.printFlowStatistics(this.rtpManager);
            }
            this.rtpManager.removeReceiveStreamListener(this);
            this.rtpManager.removeSendStreamListener(this);
            this.rtpManager.removeSessionListener(this);
            this.rtpManager.removeRemoteListener(this);
            try {
                this.rtpManager.dispose();
                this.rtpManager = null;
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error("Failed to dispose of RTPManager", t);
            }
        }
        if (this.rtpConnector != null) {
            this.rtpConnector.removeTargets();
        }
        this.rtpConnectorTarget = null;
        if (this.deviceSession != null) {
            this.deviceSession.close();
        }
    }

    private void closeSendStreams() {
        this.stopSendStreams(true);
    }

    private void createSendStreams() {
        SourceStream[] streams;
        DataSource dataSource;
        StreamRTPManager rtpManager = this.getRTPManager();
        MediaDeviceSession deviceSession = this.getDeviceSession();
        DataSource dataSource2 = dataSource = deviceSession == null ? null : deviceSession.getOutputDataSource();
        int streamCount = dataSource instanceof PushBufferDataSource ? ((streams = ((PushBufferDataSource)dataSource).getStreams()) == null ? 0 : streams.length) : (dataSource instanceof PushDataSource ? ((streams = ((PushDataSource)dataSource).getStreams()) == null ? 0 : streams.length) : (dataSource instanceof PullBufferDataSource ? ((streams = ((PullBufferDataSource)dataSource).getStreams()) == null ? 0 : streams.length) : (dataSource instanceof PullDataSource ? ((streams = ((PullDataSource)dataSource).getStreams()) == null ? 0 : streams.length) : (dataSource == null ? 0 : 1))));
        this.registerCustomCodecFormats(rtpManager);
        for (int streamIndex = 0; streamIndex < streamCount; ++streamIndex) {
            try {
                SendStream sendStream = rtpManager.createSendStream(dataSource, streamIndex);
                if (logger.isTraceEnabled()) {
                    logger.trace("Created SendStream with hashCode " + sendStream.hashCode() + " for " + MediaStreamImpl.toString(dataSource) + " and streamIndex " + streamIndex + " in RTPManager with hashCode " + rtpManager.hashCode());
                }
                long localSSRC = sendStream.getSSRC() & 0xFFFFFFFFL;
                if (this.getLocalSourceID() == localSSRC) continue;
                this.setLocalSourceID(localSSRC);
                continue;
            }
            catch (IOException ioe) {
                logger.error("Failed to create send stream for data source " + dataSource + " and stream index " + streamIndex, ioe);
                continue;
            }
            catch (UnsupportedFormatException ufe) {
                logger.error("Failed to create send stream for data source " + dataSource + " and stream index " + streamIndex + " because of failed format " + ufe.getFailedFormat(), ufe);
            }
        }
        this.sendStreamsAreCreated = true;
        if (logger.isTraceEnabled()) {
            Vector sendStreams = rtpManager.getSendStreams();
            int sendStreamCount = sendStreams == null ? 0 : sendStreams.size();
            logger.trace("Total number of SendStreams in RTPManager with hashCode " + rtpManager.hashCode() + " is " + sendStreamCount);
        }
    }

    protected void deviceSessionChanged(MediaDeviceSession oldValue, MediaDeviceSession newValue) {
        this.recreateSendStreams();
    }

    private void deviceSessionOutputDataSourceChanged() {
        this.recreateSendStreams();
    }

    private void deviceSessionSsrcListChanged(PropertyChangeEvent ev) {
        long[] ssrcArray = (long[])ev.getNewValue();
        if (ssrcArray == null) {
            this.localContributingSourceIDs = null;
            return;
        }
        int elementsToRemove = 0;
        Vector<Long> remoteSourceIDs = this.remoteSourceIDs;
        for (int i = 0; i < ssrcArray.length; ++i) {
            long csrc = ssrcArray[i];
            if (!remoteSourceIDs.contains(csrc)) continue;
            ++elementsToRemove;
        }
        if (elementsToRemove >= ssrcArray.length) {
            this.localContributingSourceIDs = null;
            return;
        }
        int cc = Math.min(ssrcArray.length - elementsToRemove + 1, 15);
        long[] csrcArray = new long[cc];
        int j = 0;
        for (int i = 0; i < ssrcArray.length && j < csrcArray.length - 1; ++i) {
            long ssrc = ssrcArray[i];
            if (remoteSourceIDs.contains(ssrc)) continue;
            csrcArray[j] = ssrc;
            ++j;
        }
        csrcArray[csrcArray.length - 1] = this.getLocalSourceID();
        this.localContributingSourceIDs = csrcArray;
    }

    private void doSetTarget(MediaStreamTarget target) {
        boolean targetIsSet;
        InetSocketAddress newControlAddr;
        InetSocketAddress newDataAddr;
        if (target == null) {
            newDataAddr = null;
            newControlAddr = null;
        } else {
            newDataAddr = target.getDataAddress();
            newControlAddr = target.getControlAddress();
        }
        if (this.rtpConnectorTarget != null) {
            boolean removeTargets;
            InetSocketAddress oldDataAddr = this.rtpConnectorTarget.getDataAddress();
            boolean bl = oldDataAddr == null ? newDataAddr != null : (removeTargets = !oldDataAddr.equals(newDataAddr));
            if (!removeTargets) {
                InetSocketAddress oldControlAddr = this.rtpConnectorTarget.getControlAddress();
                boolean bl2 = oldControlAddr == null ? newControlAddr != null : (removeTargets = !oldControlAddr.equals(newControlAddr));
            }
            if (removeTargets) {
                this.rtpConnector.removeTargets();
                this.rtpConnectorTarget = null;
            }
        }
        if (target == null) {
            targetIsSet = true;
        } else {
            try {
                int controlPort;
                InetAddress controlInetAddr;
                if (newControlAddr == null) {
                    controlInetAddr = null;
                    controlPort = 0;
                } else {
                    controlInetAddr = newControlAddr.getAddress();
                    controlPort = newControlAddr.getPort();
                }
                this.rtpConnector.addTarget(new SessionAddress(newDataAddr.getAddress(), newDataAddr.getPort(), controlInetAddr, controlPort));
                targetIsSet = true;
            }
            catch (IOException ioe) {
                targetIsSet = false;
                logger.error("Failed to set target " + target, ioe);
            }
        }
        if (targetIsSet) {
            this.rtpConnectorTarget = target;
            if (logger.isTraceEnabled()) {
                logger.trace("Set target of " + this.getClass().getSimpleName() + " with hashCode " + this.hashCode() + " to " + target);
            }
        }
    }

    @Override
    public AbstractMediaDevice getDevice() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession == null ? null : deviceSession.getDevice();
    }

    private MediaDirection getDeviceDirection() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession == null ? MediaDirection.SENDRECV : deviceSession.getDevice().getDirection();
    }

    public MediaDeviceSession getDeviceSession() {
        return this.deviceSession;
    }

    @Override
    public MediaDirection getDirection() {
        return this.direction == null ? this.getDeviceDirection() : this.direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Byte, MediaFormat> getDynamicRTPPayloadTypes() {
        Map<Byte, MediaFormat> map = this.dynamicRTPPayloadTypes;
        synchronized (map) {
            return new HashMap<Byte, MediaFormat>(this.dynamicRTPPayloadTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getDynamicRTPPayloadType(String encoding) {
        Map<Byte, MediaFormat> map = this.dynamicRTPPayloadTypes;
        synchronized (map) {
            for (Map.Entry<Byte, MediaFormat> entry : this.dynamicRTPPayloadTypes.entrySet()) {
                if (!entry.getValue().getEncoding().equals(encoding)) continue;
                return entry.getKey();
            }
            return -1;
        }
    }

    @Override
    public MediaFormat getFormat() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession == null ? null : deviceSession.getFormat();
    }

    @Override
    public long getLocalSourceID() {
        return this.localSourceID;
    }

    @Override
    public InetSocketAddress getRemoteControlAddress() {
        StreamConnector connector;
        if (this.rtpConnector != null && (connector = this.rtpConnector.getConnector()) != null) {
            if (connector.getDataSocket() != null) {
                return (InetSocketAddress)connector.getControlSocket().getRemoteSocketAddress();
            }
            if (connector.getDataTCPSocket() != null) {
                return (InetSocketAddress)connector.getControlTCPSocket().getRemoteSocketAddress();
            }
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteDataAddress() {
        StreamConnector connector;
        StreamConnector streamConnector = connector = this.rtpConnector != null ? this.rtpConnector.getConnector() : null;
        if (connector != null) {
            if (connector.getDataSocket() != null) {
                return (InetSocketAddress)connector.getDataSocket().getRemoteSocketAddress();
            }
            if (connector.getDataTCPSocket() != null) {
                return (InetSocketAddress)connector.getDataTCPSocket().getRemoteSocketAddress();
            }
        }
        return null;
    }

    public InetSocketAddress getLocalControlAddress() {
        StreamConnector connector;
        StreamConnector streamConnector = connector = this.rtpConnector != null ? this.rtpConnector.getConnector() : null;
        if (connector != null) {
            if (connector.getDataSocket() != null) {
                return (InetSocketAddress)connector.getControlSocket().getLocalSocketAddress();
            }
            if (connector.getDataTCPSocket() != null) {
                return (InetSocketAddress)connector.getControlTCPSocket().getLocalSocketAddress();
            }
        }
        return null;
    }

    public InetSocketAddress getLocalDataAddress() {
        StreamConnector connector;
        StreamConnector streamConnector = connector = this.rtpConnector != null ? this.rtpConnector.getConnector() : null;
        if (connector != null) {
            if (connector.getDataSocket() != null) {
                return (InetSocketAddress)connector.getDataSocket().getLocalSocketAddress();
            }
            if (connector.getDataTCPSocket() != null) {
                return (InetSocketAddress)connector.getDataTCPSocket().getLocalSocketAddress();
            }
        }
        return null;
    }

    @Override
    public StreamConnector.Protocol getTransportProtocol() {
        StreamConnector connector;
        StreamConnector streamConnector = connector = this.rtpConnector != null ? this.rtpConnector.getConnector() : null;
        if (connector == null) {
            return null;
        }
        return connector.getProtocol();
    }

    @Override
    public long getRemoteSourceID() {
        return this.remoteSourceIDs.isEmpty() ? -1L : this.remoteSourceIDs.lastElement();
    }

    @Override
    public List<Long> getRemoteSourceIDs() {
        return Collections.unmodifiableList(this.remoteSourceIDs);
    }

    protected AbstractRTPConnector getRTPConnector() {
        return this.rtpConnector;
    }

    public StreamRTPManager getRTPManager() {
        if (this.rtpManager == null) {
            AbstractRTPConnector rtpConnector = this.getRTPConnector();
            if (rtpConnector == null) {
                throw new IllegalStateException("rtpConnector");
            }
            this.rtpManager = new StreamRTPManager(this, this.rtpTranslator);
            this.registerCustomCodecFormats(this.rtpManager);
            this.rtpManager.addReceiveStreamListener(this);
            this.rtpManager.addSendStreamListener(this);
            this.rtpManager.addSessionListener(this);
            this.rtpManager.addRemoteListener(this);
            BufferControl bc = this.rtpManager.getControl(BufferControl.class);
            if (bc != null) {
                this.configureRTPManagerBufferControl(this.rtpManager, bc);
            }
            this.rtpManager.setSSRCFactory(this.ssrcFactory);
            this.rtpManager.initialize(rtpConnector);
            long localSSRC = this.rtpManager.getLocalSSRC();
            this.setLocalSourceID(localSSRC == Long.MAX_VALUE ? -1L : localSSRC & 0xFFFFFFFFL);
        }
        return this.rtpManager;
    }

    @Override
    public SrtpControl getSrtpControl() {
        return this.srtpControl;
    }

    @Override
    public boolean isMute() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession == null ? this.mute : deviceSession.isMute();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public StreamRTPManager queryRTPManager() {
        return this.rtpManager;
    }

    protected void recreateSendStreams() {
        if (this.sendStreamsAreCreated) {
            this.closeSendStreams();
            if (this.getDeviceSession() != null && this.rtpManager != null && (MediaDirection.SENDONLY.equals((Object)this.startedDirection) || MediaDirection.SENDRECV.equals((Object)this.startedDirection))) {
                this.startSendStreams();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCustomCodecFormats(StreamRTPManager rtpManager) {
        Map<Byte, MediaFormat> map = this.dynamicRTPPayloadTypes;
        synchronized (map) {
            for (Map.Entry<Byte, MediaFormat> dynamicRTPPayloadType : this.dynamicRTPPayloadTypes.entrySet()) {
                MediaFormatImpl mediaFormatImpl = (MediaFormatImpl)dynamicRTPPayloadType.getValue();
                rtpManager.addFormat((Format)mediaFormatImpl.getFormat(), dynamicRTPPayloadType.getKey().byteValue());
            }
        }
    }

    protected void rtpConnectorChanged(AbstractRTPConnector oldValue, AbstractRTPConnector newValue) {
        this.srtpControl.setConnector(newValue);
        if (newValue != null) {
            if (newValue instanceof RTPTransformUDPConnector) {
                ((RTPTransformUDPConnector)newValue).setEngine(this.createTransformEngineChain());
            } else if (newValue instanceof RTPTransformTCPConnector) {
                ((RTPTransformTCPConnector)newValue).setEngine(this.createTransformEngineChain());
            }
            if (this.rtpConnectorTarget != null) {
                this.doSetTarget(this.rtpConnectorTarget);
            }
        }
    }

    private void rtpConnectorInputStreamCreated(RTPConnectorInputStream inputStream, boolean data) {
        try {
            this.firePropertyChange(MediaStreamImpl.class.getName() + ".rtpConnector." + (data ? "data" : "control") + "InputStream", null, inputStream);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error(t);
        }
    }

    @Override
    public void setConnector(StreamConnector connector) {
        if (connector == null) {
            throw new NullPointerException("connector");
        }
        AbstractRTPConnector oldValue = this.rtpConnector;
        if (oldValue != null && oldValue.getConnector() == connector) {
            return;
        }
        switch (connector.getProtocol()) {
            case UDP: {
                this.rtpConnector = new RTPTransformUDPConnector(connector){

                    @Override
                    protected TransformUDPInputStream createControlInputStream() throws IOException {
                        TransformUDPInputStream s = super.createControlInputStream();
                        MediaStreamImpl.this.rtpConnectorInputStreamCreated(s, false);
                        return s;
                    }

                    @Override
                    protected TransformUDPInputStream createDataInputStream() throws IOException {
                        TransformUDPInputStream s = super.createDataInputStream();
                        MediaStreamImpl.this.rtpConnectorInputStreamCreated(s, true);
                        if (s != null) {
                            MediaStreamImpl.this.configureDataInputStream(s);
                        }
                        return s;
                    }

                    @Override
                    protected TransformUDPOutputStream createDataOutputStream() throws IOException {
                        TransformUDPOutputStream s = super.createDataOutputStream();
                        if (s != null) {
                            MediaStreamImpl.this.configureDataOutputStream(s);
                        }
                        return s;
                    }
                };
                break;
            }
            case TCP: {
                this.rtpConnector = new RTPTransformTCPConnector(connector){

                    @Override
                    protected TransformTCPInputStream createControlInputStream() throws IOException {
                        TransformTCPInputStream s = super.createControlInputStream();
                        MediaStreamImpl.this.rtpConnectorInputStreamCreated(s, false);
                        return s;
                    }

                    @Override
                    protected TransformTCPInputStream createDataInputStream() throws IOException {
                        TransformTCPInputStream s = super.createDataInputStream();
                        MediaStreamImpl.this.rtpConnectorInputStreamCreated(s, true);
                        if (s != null) {
                            MediaStreamImpl.this.configureDataInputStream(s);
                        }
                        return s;
                    }

                    @Override
                    protected TransformTCPOutputStream createDataOutputStream() throws IOException {
                        TransformTCPOutputStream s = super.createDataOutputStream();
                        if (s != null) {
                            MediaStreamImpl.this.configureDataOutputStream(s);
                        }
                        return s;
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("connector");
            }
        }
        this.rtpConnectorChanged(oldValue, this.rtpConnector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDevice(MediaDevice device) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        AbstractMediaDevice abstractMediaDevice = (AbstractMediaDevice)device;
        if (this.deviceSession == null || this.deviceSession.getDevice() != device) {
            MediaDirection startedDirection;
            MediaFormat format;
            this.assertDirection(this.direction, device.getDirection(), "device");
            MediaDeviceSession oldValue = this.deviceSession;
            if (this.deviceSession != null) {
                format = this.getFormat();
                startedDirection = this.deviceSession.getStartedDirection();
                this.deviceSession.removePropertyChangeListener(this.deviceSessionPropertyChangeListener);
                this.deviceSession.setDisposePlayerOnClose(!(this.deviceSession instanceof VideoMediaDeviceSession));
                this.deviceSession.close();
                this.deviceSession = null;
            } else {
                format = null;
                startedDirection = MediaDirection.INACTIVE;
            }
            this.deviceSession = abstractMediaDevice.createSession();
            if (oldValue != null) {
                this.deviceSession.copyPlayback(oldValue);
            }
            this.deviceSession.addPropertyChangeListener(this.deviceSessionPropertyChangeListener);
            this.direction = null;
            if (this.deviceSession != null) {
                if (format != null) {
                    this.deviceSession.setFormat(format);
                }
                this.deviceSession.setMute(this.mute);
            }
            this.deviceSessionChanged(oldValue, this.deviceSession);
            if (this.deviceSession != null) {
                this.deviceSession.start(startedDirection);
                Lock receiveStreamsReadLock = this.receiveStreamsLock.readLock();
                receiveStreamsReadLock.lock();
                try {
                    for (ReceiveStream receiveStream : this.receiveStreams) {
                        this.deviceSession.addReceiveStream(receiveStream);
                    }
                }
                finally {
                    receiveStreamsReadLock.unlock();
                }
            }
        }
    }

    @Override
    public void setDirection(MediaDirection direction) {
        AbstractRTPConnector connector;
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        if (this.direction == direction) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Changing direction of stream " + this.hashCode() + " from:" + (Object)((Object)this.direction) + " to:" + (Object)((Object)direction));
        }
        this.assertDirection(direction, this.getDeviceDirection(), "direction");
        this.direction = direction;
        switch (this.direction) {
            case INACTIVE: {
                this.stop(MediaDirection.SENDRECV);
                return;
            }
            case RECVONLY: {
                this.stop(MediaDirection.SENDONLY);
                break;
            }
            case SENDONLY: {
                this.stop(MediaDirection.RECVONLY);
                break;
            }
            case SENDRECV: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.started) {
            this.start(this.direction);
        }
        if ((connector = this.getRTPConnector()) != null) {
            connector.setDirection(direction);
        }
    }

    @Override
    public void setFormat(MediaFormat format) {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        MediaFormatImpl<? extends Format> deviceSessionFormat = null;
        if (deviceSession != null && (deviceSessionFormat = deviceSession.getFormat()) != null && deviceSessionFormat.equals(format) && deviceSessionFormat.advancedAttributesAreEqual(deviceSessionFormat.getAdvancedAttributes(), format.getAdvancedAttributes())) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Changing format of stream " + this.hashCode() + " from: " + deviceSessionFormat + " to: " + format);
        }
        this.handleAttributes(format, format.getAdvancedAttributes());
        this.handleAttributes(format, format.getFormatParameters());
        if (deviceSession != null) {
            deviceSession.setFormat(format);
        }
    }

    protected void handleAttributes(MediaFormat format, Map<String, String> attrs) {
    }

    @Override
    public void setMute(boolean mute) {
        if (this.mute != mute) {
            if (logger.isTraceEnabled()) {
                logger.trace((mute ? "Muting" : "Unmuting") + " stream with hashcode " + this.hashCode());
            }
            this.mute = mute;
            MediaDeviceSession deviceSession = this.getDeviceSession();
            if (deviceSession != null) {
                deviceSession.setMute(this.mute);
            }
        }
    }

    @Override
    public MediaStreamTarget getTarget() {
        return this.rtpConnectorTarget;
    }

    @Override
    public void setTarget(MediaStreamTarget target) {
        if (target == null ? this.rtpConnectorTarget == null : target.equals(this.rtpConnectorTarget)) {
            return;
        }
        this.doSetTarget(target);
    }

    @Override
    public void start() {
        this.start(this.getDirection());
        this.started = true;
    }

    private void start(MediaDirection direction) {
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        boolean getRTPManagerForRTPTranslator = true;
        MediaDeviceSession deviceSession = this.getDeviceSession();
        if (direction.allowsSending() && (this.startedDirection == null || !this.startedDirection.allowsSending())) {
            getRTPManagerForRTPTranslator = false;
            this.startSendStreams();
            if (deviceSession != null) {
                deviceSession.start(MediaDirection.SENDONLY);
            }
            if (MediaDirection.RECVONLY.equals((Object)this.startedDirection)) {
                this.startedDirection = MediaDirection.SENDRECV;
            } else if (this.startedDirection == null) {
                this.startedDirection = MediaDirection.SENDONLY;
            }
            if (logger.isInfoEnabled()) {
                MediaType mediaType = this.getMediaType();
                MediaStreamStats stats = this.getMediaStreamStats();
                logger.info((Object)((Object)mediaType) + " codec/freq: " + stats.getEncoding() + "/" + stats.getEncodingClockRate() + " Hz");
                logger.info((Object)((Object)mediaType) + " remote IP/port: " + stats.getRemoteIPAddress() + "/" + String.valueOf(stats.getRemotePort()));
            }
        }
        if (direction.allowsReceiving() && (this.startedDirection == null || !this.startedDirection.allowsReceiving())) {
            getRTPManagerForRTPTranslator = false;
            this.startReceiveStreams();
            if (deviceSession != null) {
                deviceSession.start(MediaDirection.RECVONLY);
            }
            if (MediaDirection.SENDONLY.equals((Object)this.startedDirection)) {
                this.startedDirection = MediaDirection.SENDRECV;
            } else if (this.startedDirection == null) {
                this.startedDirection = MediaDirection.RECVONLY;
            }
        }
        if (getRTPManagerForRTPTranslator && this.rtpTranslator != null) {
            this.getRTPManager();
        }
    }

    private void startReceiveStreams() {
        HashSet<ReceiveStream> streamsToStart;
        block5: {
            StreamRTPManager rtpManager = this.getRTPManager();
            streamsToStart = new HashSet<ReceiveStream>();
            try {
                streamsToStart.addAll(rtpManager.getReceiveStreams());
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block5;
                logger.trace("Failed to retrieve receive streams", ex);
            }
        }
        streamsToStart.addAll(this.getReceiveStreams());
        for (ReceiveStream receiveStream : streamsToStart) {
            try {
                DataSource receiveStreamDataSource = receiveStream.getDataSource();
                if (receiveStreamDataSource == null) continue;
                receiveStreamDataSource.start();
            }
            catch (IOException ioex) {
                logger.warn("Failed to start receive stream " + receiveStream, ioex);
            }
        }
    }

    private void startSendStreams() {
        StreamRTPManager rtpManager;
        Vector sendStreams;
        if (!this.sendStreamsAreCreated) {
            this.createSendStreams();
        }
        if ((sendStreams = (rtpManager = this.getRTPManager()).getSendStreams()) != null) {
            for (SendStream sendStream : sendStreams) {
                try {
                    DataSource sendStreamDataSource = sendStream.getDataSource();
                    sendStreamDataSource.connect();
                    sendStream.start();
                    sendStreamDataSource.start();
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Started SendStream with hashCode " + sendStream.hashCode());
                }
                catch (IOException ioe) {
                    logger.warn("Failed to start stream " + sendStream, ioe);
                }
            }
        }
    }

    @Override
    public void stop() {
        this.stop(MediaDirection.SENDRECV);
        this.started = false;
    }

    private void stop(MediaDirection direction) {
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        if (this.rtpManager == null) {
            return;
        }
        if ((MediaDirection.SENDRECV.equals((Object)direction) || MediaDirection.SENDONLY.equals((Object)direction)) && (MediaDirection.SENDRECV.equals((Object)this.startedDirection) || MediaDirection.SENDONLY.equals((Object)this.startedDirection))) {
            this.stopSendStreams(this instanceof VideoMediaStream);
            if (this.deviceSession != null) {
                this.deviceSession.stop(MediaDirection.SENDONLY);
            }
            if (MediaDirection.SENDRECV.equals((Object)this.startedDirection)) {
                this.startedDirection = MediaDirection.RECVONLY;
            } else if (MediaDirection.SENDONLY.equals((Object)this.startedDirection)) {
                this.startedDirection = null;
            }
        }
        if ((MediaDirection.SENDRECV.equals((Object)direction) || MediaDirection.RECVONLY.equals((Object)direction)) && (MediaDirection.SENDRECV.equals((Object)this.startedDirection) || MediaDirection.RECVONLY.equals((Object)this.startedDirection))) {
            this.stopReceiveStreams();
            if (this.deviceSession != null) {
                this.deviceSession.stop(MediaDirection.RECVONLY);
            }
            if (MediaDirection.SENDRECV.equals((Object)this.startedDirection)) {
                this.startedDirection = MediaDirection.SENDONLY;
            } else if (MediaDirection.RECVONLY.equals((Object)this.startedDirection)) {
                this.startedDirection = null;
            }
        }
    }

    private void stopReceiveStreams() {
        HashSet<ReceiveStream> streamsToStop;
        block6: {
            streamsToStop = new HashSet<ReceiveStream>();
            try {
                streamsToStop.addAll(this.rtpManager.getReceiveStreams());
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block6;
                logger.trace("Failed to retrieve receive streams", ex);
            }
        }
        streamsToStop.addAll(this.getReceiveStreams());
        for (ReceiveStream receiveStream : streamsToStop) {
            try {
                DataSource receiveStreamDataSource;
                if (logger.isTraceEnabled()) {
                    logger.trace("Stopping receive stream with hashcode " + receiveStream.hashCode());
                }
                if ((receiveStreamDataSource = receiveStream.getDataSource()) == null) continue;
                receiveStreamDataSource.stop();
            }
            catch (IOException ioex) {
                logger.warn("Failed to stop receive stream " + receiveStream, ioex);
            }
        }
    }

    private Iterable<SendStream> stopSendStreams(boolean close) {
        if (this.rtpManager == null) {
            return null;
        }
        Vector sendStreams = this.rtpManager.getSendStreams();
        Iterable<SendStream> stoppedSendStreams = this.stopSendStreams(sendStreams, close);
        if (close) {
            this.sendStreamsAreCreated = false;
        }
        return stoppedSendStreams;
    }

    private Iterable<SendStream> stopSendStreams(Iterable<SendStream> sendStreams, boolean close) {
        if (sendStreams == null) {
            return null;
        }
        for (SendStream sendStream : sendStreams) {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Stopping send stream with hashcode " + sendStream.hashCode());
                }
                sendStream.getDataSource().stop();
                sendStream.stop();
                if (!close) continue;
                try {
                    sendStream.close();
                }
                catch (NullPointerException npe) {
                    logger.error("Failed to close send stream " + sendStream, npe);
                }
            }
            catch (IOException ioe) {
                logger.warn("Failed to stop send stream " + sendStream, ioe);
            }
        }
        return sendStreams;
    }

    public static String toString(DataSource dataSource) {
        StringBuffer str = new StringBuffer();
        str.append(dataSource.getClass().getSimpleName());
        str.append(" with hashCode ");
        str.append(dataSource.hashCode());
        MediaLocator locator = dataSource.getLocator();
        if (locator != null) {
            str.append(" and locator ");
            str.append(locator);
        }
        return str.toString();
    }

    @Override
    public void update(ReceiveStreamEvent ev) {
        block10: {
            MediaDeviceSession deviceSession;
            ReceiveStream receiveStream;
            block11: {
                block9: {
                    if (!(ev instanceof NewReceiveStreamEvent)) break block9;
                    ReceiveStream receiveStream2 = ev.getReceiveStream();
                    if (receiveStream2 == null) break block10;
                    long receiveStreamSSRC = 0xFFFFFFFFL & receiveStream2.getSSRC();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Received new ReceiveStream with ssrc " + receiveStreamSSRC);
                    }
                    this.addRemoteSourceID(receiveStreamSSRC);
                    this.addReceiveStream(receiveStream2);
                    break block10;
                }
                if (!(ev instanceof TimeoutEvent)) break block11;
                ReceiveStream evReceiveStream = ev.getReceiveStream();
                Participant participant = ev.getParticipant();
                ArrayList<ReceiveStream> receiveStreamsToRemove = new ArrayList<ReceiveStream>();
                if (evReceiveStream != null) {
                    receiveStreamsToRemove.add(evReceiveStream);
                } else if (participant != null) {
                    List<ReceiveStream> receiveStreams = this.getReceiveStreams();
                    Vector managerReceiveStreams = this.rtpManager.getReceiveStreams();
                    for (ReceiveStream receiveStream3 : receiveStreams) {
                        if (!participant.equals(receiveStream3.getParticipant()) || participant.getStreams().contains(receiveStream3) || managerReceiveStreams.contains(receiveStream3)) continue;
                        receiveStreamsToRemove.add(receiveStream3);
                    }
                }
                for (ReceiveStream receiveStream4 : receiveStreamsToRemove) {
                    this.removeReceiveStream(receiveStream4);
                    DataSource dataSource = receiveStream4.getDataSource();
                    if (dataSource == null) continue;
                    dataSource.disconnect();
                }
                break block10;
            }
            if (!(ev instanceof RemotePayloadChangeEvent) || (receiveStream = ev.getReceiveStream()) == null || (deviceSession = this.getDeviceSession()) == null) break block10;
            TranscodingDataSource transcodingDataSource = deviceSession.getTranscodingDataSource(receiveStream);
            try {
                if (transcodingDataSource != null) {
                    transcodingDataSource.disconnect();
                    transcodingDataSource.connect();
                    transcodingDataSource.start();
                }
                deviceSession.playbackDataSourceChanged(receiveStream.getDataSource());
            }
            catch (IOException e) {
                logger.error("Error re-creating processor in transcoding DataSource", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReceiveStream(ReceiveStream receiveStream) {
        Lock writeLock = this.receiveStreamsLock.writeLock();
        Lock readLock = this.receiveStreamsLock.readLock();
        boolean added = false;
        writeLock.lock();
        try {
            if (!this.receiveStreams.contains(receiveStream) && this.receiveStreams.add(receiveStream)) {
                readLock.lock();
                added = true;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (added) {
            try {
                MediaDeviceSession deviceSession = this.getDeviceSession();
                if (deviceSession != null) {
                    deviceSession.addReceiveStream(receiveStream);
                }
            }
            finally {
                readLock.unlock();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeReceiveStream(ReceiveStream receiveStream) {
        Lock writeLock = this.receiveStreamsLock.writeLock();
        Lock readLock = this.receiveStreamsLock.readLock();
        boolean removed = false;
        writeLock.lock();
        try {
            if (this.receiveStreams.remove(receiveStream)) {
                readLock.lock();
                removed = true;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (removed) {
            try {
                MediaDeviceSession deviceSession = this.getDeviceSession();
                if (deviceSession != null) {
                    deviceSession.removeReceiveStream(receiveStream);
                }
            }
            finally {
                readLock.unlock();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReceiveStream> getReceiveStreams() {
        ArrayList<ReceiveStream> receiveStreams;
        Lock readLock = this.receiveStreamsLock.readLock();
        readLock.lock();
        try {
            receiveStreams = new ArrayList<ReceiveStream>(this.receiveStreams);
        }
        finally {
            readLock.unlock();
        }
        return receiveStreams;
    }

    @Override
    public void update(SendStreamEvent event) {
        if (event instanceof NewSendStreamEvent) {
            long localSourceID = event.getSendStream().getSSRC() & 0xFFFFFFFFL;
            if (this.getLocalSourceID() != localSourceID) {
                this.setLocalSourceID(localSourceID);
            }
        }
    }

    @Override
    public void update(SessionEvent event) {
    }

    @Override
    public void update(RemoteEvent remoteEvent) {
        if (remoteEvent instanceof SenderReportEvent || remoteEvent instanceof ReceiverReportEvent) {
            Report report;
            boolean senderReport = false;
            if (remoteEvent instanceof SenderReportEvent) {
                ++this.numberOfReceivedSenderReports;
                report = ((SenderReportEvent)remoteEvent).getReport();
                senderReport = true;
            } else {
                ++this.numberOfReceivedReceiverReports;
                report = ((ReceiverReportEvent)remoteEvent).getReport();
            }
            Feedback feedback = null;
            long remoteJitter = -1L;
            if (report.getFeedbackReports().size() > 0) {
                feedback = (Feedback)report.getFeedbackReports().get(0);
                remoteJitter = feedback.getJitter();
                if (remoteJitter < this.minRemoteInterArrivalJitter || this.minRemoteInterArrivalJitter == -1L) {
                    this.minRemoteInterArrivalJitter = remoteJitter;
                }
                if (this.maxRemoteInterArrivalJitter < remoteJitter) {
                    this.maxRemoteInterArrivalJitter = remoteJitter;
                }
            }
            if (feedback != null && this.getDirection() != MediaDirection.INACTIVE) {
                Set<PacketLossAwareEncoder> plaes = null;
                MediaDeviceSession deviceSession = this.getDeviceSession();
                if (deviceSession != null) {
                    plaes = deviceSession.getEncoderControls(PacketLossAwareEncoder.class);
                }
                if (plaes != null && !plaes.isEmpty()) {
                    int expectedPacketLoss = feedback.getFractionLost() * 100 / 256;
                    for (PacketLossAwareEncoder plae : plaes) {
                        if (plae == null) continue;
                        plae.setExpectedPacketLoss(expectedPacketLoss);
                    }
                }
            }
            if (logger.isInfoEnabled()) {
                if ((this.numberOfReceivedSenderReports + this.numberOfReceivedReceiverReports) % 4L != 1L) {
                    return;
                }
                StringBuilder buff = new StringBuilder("rtpstat:");
                MediaType mediaType = this.getMediaType();
                String mediaTypeStr = mediaType == null ? "" : mediaType.toString();
                buff.append("Received a ").append(senderReport ? "sender" : "receiver").append(" report for ").append(mediaTypeStr).append(" stream SSRC:").append(this.getLocalSourceID()).append(" [");
                if (senderReport) {
                    buff.append("packet count:").append(((SenderReport)report).getSenderPacketCount()).append(", bytes:").append(((SenderReport)report).getSenderByteCount());
                }
                if (feedback != null) {
                    buff.append(", interarrival jitter:").append(remoteJitter).append(", lost packets:").append(feedback.getNumLost()).append(", time since previous report:").append((int)((double)feedback.getDLSR() / 65.536)).append("ms");
                }
                buff.append(" ]");
                logger.info(buff);
            }
        }
    }

    protected void setLocalSourceID(long localSourceID) {
        if (this.localSourceID != localSourceID) {
            Long oldValue = this.localSourceID;
            this.localSourceID = localSourceID;
            SrtpControl.TransformEngine transformEngine = this.srtpControl.getTransformEngine();
            if (transformEngine instanceof ZRTPTransformEngine) {
                ((ZRTPTransformEngine)transformEngine).setOwnSSRC(this.getLocalSourceID());
            }
            this.firePropertyChange("localSSRCAvailable", oldValue, this.localSourceID);
        }
    }

    protected void addRemoteSourceID(long remoteSourceID) {
        Long oldValue = this.getRemoteSourceID();
        if (!this.remoteSourceIDs.contains(remoteSourceID)) {
            this.remoteSourceIDs.add(remoteSourceID);
        }
        this.firePropertyChange("remoteSSRCAvailable", oldValue, remoteSourceID);
    }

    public long[] getLocalContributingSourceIDs() {
        return this.localContributingSourceIDs;
    }

    public long[] getRemoteContributingSourceIDs() {
        long[] remoteSsrcList = this.getDeviceSession().getRemoteSSRCList();
        return remoteSsrcList;
    }

    protected int getPriority() {
        return Thread.currentThread().getPriority();
    }

    private void printFlowStatistics(StreamRTPManager rtpManager) {
        try {
            if (!logger.isInfoEnabled()) {
                return;
            }
            GlobalTransmissionStats s = rtpManager.getGlobalTransmissionStats();
            StringBuilder buff = new StringBuilder("rtpstat:");
            MediaType mediaType = this.getMediaType();
            String mediaTypeStr = mediaType == null ? "" : mediaType.toString();
            buff.append("call stats for outgoing ").append(mediaTypeStr).append(" stream SSRC:").append(this.getLocalSourceID()).append("\n").append("rtpstat:").append("bytes sent: ").append(s.getBytesSent()).append("\n").append("rtpstat:").append("RTP sent: ").append(s.getRTPSent()).append("\n").append("rtpstat:").append("remote reported min interarrival jitter : ").append(this.minRemoteInterArrivalJitter).append("\n").append("rtpstat:").append("remote reported max interarrival jitter : ").append(this.maxRemoteInterArrivalJitter).append("\n").append("rtpstat:").append("local collisions: ").append(s.getLocalColls()).append("\n").append("rtpstat:").append("remote collisions: ").append(s.getRemoteColls()).append("\n").append("rtpstat:").append("RTCP sent: ").append(s.getRTCPSent()).append("\n").append("rtpstat:").append("transmit failed: ").append(s.getTransmitFailed());
            logger.info(buff);
            GlobalReceptionStats rs = rtpManager.getGlobalReceptionStats();
            MediaFormat format = this.getFormat();
            buff = new StringBuilder("rtpstat:");
            buff.append("call stats for incoming ").append(format == null ? "" : format).append(" stream SSRC:").append(this.getRemoteSourceID()).append("\n").append("rtpstat:").append("packets received: ").append(rs.getPacketsRecd()).append("\n").append("rtpstat:").append("bytes received: ").append(rs.getBytesRecd()).append("\n").append("rtpstat:").append("packets lost: ").append(this.statisticsEngine.getLost()).append("\n").append("rtpstat:").append("min interarrival jitter : ").append(this.statisticsEngine.getMinInterArrivalJitter()).append("\n").append("rtpstat:").append("max interarrival jitter : ").append(this.statisticsEngine.getMaxInterArrivalJitter()).append("\n").append("rtpstat:").append("RTCPs received: ").append(rs.getRTCPRecd()).append("\n").append("rtpstat:").append("bad RTCP packets: ").append(rs.getBadRTCPPkts()).append("\n").append("rtpstat:").append("bad RTP packets: ").append(rs.getBadRTPkts()).append("\n").append("rtpstat:").append("local collisions: ").append(rs.getLocalColls()).append("\n").append("rtpstat:").append("malformed BYEs: ").append(rs.getMalformedBye()).append("\n").append("rtpstat:").append("malformed RRs: ").append(rs.getMalformedRR()).append("\n").append("rtpstat:").append("malformed SDESs: ").append(rs.getMalformedSDES()).append("\n").append("rtpstat:").append("malformed SRs: ").append(rs.getMalformedSR()).append("\n").append("rtpstat:").append("packets looped: ").append(rs.getPacketsLooped()).append("\n").append("rtpstat:").append("remote collisions: ").append(rs.getRemoteColls()).append("\n").append("rtpstat:").append("SRRs received: ").append(rs.getSRRecd()).append("\n").append("rtpstat:").append("transmit failed: ").append(rs.getTransmitFailed()).append("\n").append("rtpstat:").append("unknown types: ").append(rs.getUnknownTypes());
            logger.info(buff);
        }
        catch (Throwable t) {
            logger.error("Error writing statistics", t);
        }
    }

    private void printReceiveStreamStatistics() {
        this.mediaStreamStatsImpl.updateStats();
        StringBuilder buff = new StringBuilder("\nReceive stream stats: discarded RTP packets: ").append(this.mediaStreamStatsImpl.getNbDiscarded()).append("\n").append("Receive stream stats: decoded with FEC: ").append(this.mediaStreamStatsImpl.getNbFec());
        logger.info(buff);
    }

    @Override
    public void setRTPTranslator(RTPTranslator rtpTranslator) {
        if (this.rtpTranslator != rtpTranslator) {
            this.rtpTranslator = rtpTranslator;
        }
    }

    @Override
    public MediaStreamStats getMediaStreamStats() {
        return this.mediaStreamStatsImpl;
    }

    public MediaType getMediaType() {
        MediaFormat format = this.getFormat();
        MediaType mediaType = null;
        if (format != null) {
            mediaType = format.getMediaType();
        }
        if (mediaType == null) {
            MediaDeviceSession deviceSession = this.getDeviceSession();
            if (deviceSession != null) {
                mediaType = deviceSession.getDevice().getMediaType();
            }
            if (mediaType == null) {
                if (this instanceof AudioMediaStream) {
                    mediaType = MediaType.AUDIO;
                } else if (this instanceof VideoMediaStream) {
                    mediaType = MediaType.VIDEO;
                }
            }
        }
        return mediaType;
    }

    @Override
    public void addDynamicRTPPayloadTypeOverride(byte originalPt, byte overloadPt) {
        if (this.ptTransformEngine != null) {
            this.ptTransformEngine.addPTMappingOverride(originalPt, overloadPt);
        }
    }

    @Override
    public void removeReceiveStreamForSsrc(long ssrc) {
        ReceiveStream toRemove = null;
        for (Object o : this.rtpManager.getReceiveStreams()) {
            ReceiveStream receiveStream = (ReceiveStream)o;
            long receiveStreamSSRC = receiveStream.getSSRC() & 0xFFFFFFFFL;
            if (receiveStreamSSRC != ssrc) continue;
            toRemove = receiveStream;
            break;
        }
        if (toRemove != null) {
            this.removeReceiveStream(toRemove);
        }
    }

    @Override
    public void setSSRCFactory(SSRCFactory ssrcFactory) {
        if (this.ssrcFactory != ssrcFactory) {
            this.ssrcFactory = ssrcFactory;
            StreamRTPManager rtpManager = this.rtpManager;
            if (rtpManager != null) {
                rtpManager.setSSRCFactory(ssrcFactory);
            }
        }
    }
}

