/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.video;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.media.AbstractVideoRenderer;
import net.sf.fmj.media.util.BufferToImage;
import net.sf.fmj.utility.FPSCounter;
import net.sf.fmj.utility.LoggerSingleton;

public class SimpleAWTRenderer
extends AbstractVideoRenderer
implements VideoRenderer {
    private static final Logger logger = LoggerSingleton.logger;
    private final Format[] supportedInputFormats = new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 32, 1, 2, 3), new RGBFormat(null, -1, Format.byteArray, -1.0f, 32, 3, 2, 1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 1, 2, 3), new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1), new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, -1, -1, -1, 1, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 8, -1, -1, -1, 1, -1, 0, -1)};
    private AwtVideoComponent component = new AwtVideoComponent();
    private Object[] controls = new Object[]{this};
    private BufferToImage bufferToImage;
    private final FPSCounter fpsCounter = new FPSCounter();

    public int doProcess(Buffer buffer) {
        if (buffer.isEOM()) {
            logger.warning(this.getClass().getSimpleName() + "passed buffer with EOM flag");
            return 0;
        }
        if (buffer.getData() == null) {
            return 1;
        }
        Image image = this.bufferToImage.createImage(buffer);
        this.component.setImage(image);
        return 0;
    }

    public Component getComponent() {
        return this.component;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public String getName() {
        return "Simple AWT Renderer";
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format setInputFormat(Format format) {
        this.bufferToImage = new BufferToImage((VideoFormat)format);
        return super.setInputFormat(format);
    }

    private class AwtVideoComponent
    extends Component {
        private Image image;
        private boolean scaleKeepAspectRatio = false;
        private boolean scale = true;
        private BufferedImage biCompatible;

        private AwtVideoComponent() {
        }

        private BufferedImage getCompatibleBufferedImage() {
            if (this.biCompatible == null || this.biCompatible.getWidth() != this.image.getWidth(null) || this.biCompatible.getHeight() != this.image.getHeight(null)) {
                this.biCompatible = this.getGraphicsConfiguration().createCompatibleImage(this.image.getWidth(null), this.image.getHeight(null));
            }
            return this.biCompatible;
        }

        public Dimension getPreferredSize() {
            if (SimpleAWTRenderer.this.inputFormat == null) {
                return super.getPreferredSize();
            }
            VideoFormat videoFormat = (VideoFormat)SimpleAWTRenderer.this.inputFormat;
            return videoFormat.getSize();
        }

        private Rectangle getVideoRect(boolean scale) {
            int h;
            int y;
            int w;
            int x;
            Dimension preferredSize = this.getPreferredSize();
            Dimension size = this.getSize();
            if (!scale) {
                if (preferredSize.width <= size.width) {
                    x = (size.width - preferredSize.width) / 2;
                    w = preferredSize.width;
                } else {
                    x = 0;
                    w = preferredSize.width;
                }
                if (preferredSize.height <= size.height) {
                    y = (size.height - preferredSize.height) / 2;
                    h = preferredSize.height;
                } else {
                    y = 0;
                    h = preferredSize.height;
                }
            } else if (this.scaleKeepAspectRatio) {
                if ((float)size.width / (float)preferredSize.width < (float)size.height / (float)preferredSize.height) {
                    w = size.width;
                    h = size.width * preferredSize.height / preferredSize.width;
                    x = 0;
                    y = (size.height - h) / 2;
                } else {
                    w = size.height * preferredSize.width / preferredSize.height;
                    h = size.height;
                    x = (size.width - w) / 2;
                    y = 0;
                }
            } else {
                x = 0;
                y = 0;
                w = size.width;
                h = size.height;
            }
            return new Rectangle(x, y, w, h);
        }

        public void paint(Graphics g) {
            if (this.image != null) {
                Rectangle rect = this.getVideoRect(this.scale);
                try {
                    if (this.biCompatible == null) {
                        g.drawImage(this.image, rect.x, rect.y, rect.width, rect.height, null);
                        return;
                    }
                }
                catch (ImagingOpException imagingOpException) {
                    // empty catch block
                }
                this.getCompatibleBufferedImage();
                this.biCompatible.getGraphics().drawImage(this.image, 0, 0, this.image.getWidth(null), this.image.getHeight(null), null);
                g.drawImage(this.biCompatible, rect.x, rect.y, rect.width, rect.height, null);
            }
        }

        public void setImage(Image image) {
            this.image = image;
            this.repaint();
        }

        public void update(Graphics g) {
            this.paint(g);
        }
    }
}

