/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.logging.ILogger;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class VersionMismatchLogRequest
implements ConsoleRequest {
    private String manCenterVersion;

    public VersionMismatchLogRequest(String manCenterVersion) {
        this.manCenterVersion = manCenterVersion;
    }

    public VersionMismatchLogRequest() {
    }

    @Override
    public int getType() {
        return 17;
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        return "SUCCESS";
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        ILogger logger = mcs.getHazelcastInstance().node.getLogger(VersionMismatchLogRequest.class.getName());
        mcs.setVersionMismatch(true);
        logger.severe("The version of the management center is " + this.manCenterVersion);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.manCenterVersion);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.manCenterVersion = in.readUTF();
    }
}

