/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.txn;

import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public class CollectionRollbackBackupOperation
extends CollectionOperation
implements BackupOperation {
    private long itemId;
    private boolean removeOperation;

    public CollectionRollbackBackupOperation() {
    }

    public CollectionRollbackBackupOperation(String name, long itemId, boolean removeOperation) {
        super(name);
        this.itemId = itemId;
        this.removeOperation = removeOperation;
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_ROLLBACK_BACKUP;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        if (this.removeOperation) {
            this.getOrCreateContainer().rollbackRemoveBackup(this.itemId);
        } else {
            this.getOrCreateContainer().rollbackAddBackup(this.itemId);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.removeOperation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.removeOperation = in.readBoolean();
    }
}

