/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.concurrent;

import org.logicalcobwebs.concurrent.FJTaskRunner;
import org.logicalcobwebs.concurrent.FJTaskRunnerGroup;

public abstract class FJTask
implements Runnable {
    private volatile boolean done;

    public static FJTaskRunner getFJTaskRunner() {
        return (FJTaskRunner)Thread.currentThread();
    }

    public static FJTaskRunnerGroup getFJTaskRunnerGroup() {
        return FJTask.getFJTaskRunner().getGroup();
    }

    public final boolean isDone() {
        return this.done;
    }

    protected final void setDone() {
        this.done = true;
    }

    public void cancel() {
        this.setDone();
    }

    public void reset() {
        this.done = false;
    }

    public void start() {
        FJTask.getFJTaskRunnerGroup().executeTask(this);
    }

    public void fork() {
        FJTask.getFJTaskRunner().push(this);
    }

    public static void yield() {
        FJTask.getFJTaskRunner().taskYield();
    }

    public void join() {
        FJTask.getFJTaskRunner().taskJoin(this);
    }

    public static void invoke(FJTask t) {
        if (!t.isDone()) {
            t.run();
            t.setDone();
        }
    }

    public static void coInvoke(FJTask task1, FJTask task2) {
        FJTask.getFJTaskRunner().coInvoke(task1, task2);
    }

    public static void coInvoke(FJTask[] tasks) {
        FJTask.getFJTaskRunner().coInvoke(tasks);
    }

    public static FJTask seq(FJTask[] tasks) {
        return new Seq(tasks);
    }

    public static FJTask par(FJTask[] tasks) {
        return new Par(tasks);
    }

    public static FJTask seq(FJTask task1, FJTask task2) {
        return new Seq2(task1, task2);
    }

    public static FJTask par(FJTask task1, FJTask task2) {
        return new Par2(task1, task2);
    }

    public static class Par2
    extends FJTask {
        protected final FJTask fst;
        protected final FJTask snd;

        public Par2(FJTask task1, FJTask task2) {
            this.fst = task1;
            this.snd = task2;
        }

        public void run() {
            FJTask.coInvoke(this.fst, this.snd);
        }
    }

    public static class Seq2
    extends FJTask {
        protected final FJTask fst;
        protected final FJTask snd;

        public Seq2(FJTask task1, FJTask task2) {
            this.fst = task1;
            this.snd = task2;
        }

        public void run() {
            FJTask.invoke(this.fst);
            FJTask.invoke(this.snd);
        }
    }

    public static class Par
    extends FJTask {
        protected final FJTask[] tasks;

        public Par(FJTask[] tasks) {
            this.tasks = tasks;
        }

        public Par(FJTask task1, FJTask task2) {
            this.tasks = new FJTask[]{task1, task2};
        }

        public void run() {
            FJTask.coInvoke(this.tasks);
        }
    }

    public static class Seq
    extends FJTask {
        protected final FJTask[] tasks;

        public Seq(FJTask[] tasks) {
            this.tasks = tasks;
        }

        public Seq(FJTask task1, FJTask task2) {
            this.tasks = new FJTask[]{task1, task2};
        }

        public void run() {
            for (int i = 0; i < this.tasks.length; ++i) {
                FJTask.invoke(this.tasks[i]);
            }
        }
    }

    public static class Wrap
    extends FJTask {
        protected final Runnable runnable;

        public Wrap(Runnable r) {
            this.runnable = r;
        }

        public void run() {
            this.runnable.run();
        }
    }
}

