/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.media.rtp.RTPConnector;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.NACKPacket;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateStatistics;
import org.jitsi.impl.neomedia.transform.RTPTransformTCPConnector;
import org.jitsi.impl.neomedia.transform.RTPTransformUDPConnector;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.LastNTransformEngine;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.ratecontrol.BitrateController;
import org.jitsi.videobridge.rtcp.BasicBridgeRTCPTerminationStrategy;
import org.jitsi.videobridge.rtcp.NACKHandler;
import org.jitsi.videobridge.simulcast.SimulcastManager;
import org.jitsi.videobridge.transform.RawPacketCache;
import org.jitsi.videobridge.transform.RtpChannelTransformEngine;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoChannel
extends RtpChannel
implements NACKHandler {
    private static final int INCOMING_BITRATE_INTERVAL_MS = 5000;
    private static final Logger logger = Logger.getLogger(VideoChannel.class);
    private boolean adaptiveLastN = false;
    private boolean adaptiveSimulcast = false;
    private BitrateController bitrateController;
    private RateStatistics incomingBitrate = new RateStatistics(5000, 8000.0f);
    private final AtomicBoolean inLastN = new AtomicBoolean(true);
    private Integer lastN;
    private List<WeakReference<Endpoint>> lastNEndpoints;
    private final ReadWriteLock lastNSyncRoot = new ReentrantReadWriteLock();
    private final SimulcastManager simulcastManager = new SimulcastManager(this);

    private static void updateInLastN(VideoChannel cause) {
        Channel[] channels;
        for (Channel channel : channels = cause.getContent().getChannels()) {
            if (!(channel instanceof VideoChannel)) continue;
            try {
                ((VideoChannel)channel).updateInLastN(channels);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error((Object)t);
            }
        }
    }

    public VideoChannel(Content content, String id, String channelBundleId, String transportNamespace, Boolean initiator) throws Exception {
        super(content, id, channelBundleId, transportNamespace, initiator);
        this.setTransformEngine(new RtpChannelTransformEngine(this));
    }

    @Override
    protected boolean acceptDataInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept = super.acceptDataInputStreamDatagramPacket(p);
        if (accept) {
            this.incomingBitrate.update(p.getLength(), System.currentTimeMillis());
            this.simulcastManager.acceptedDataInputStreamDatagramPacket(p);
        }
        return accept;
    }

    private void configureTransformEngineChain(TransformEngineChain chain) {
        TransformEngine[] engines = chain.getEngineChain();
        boolean add = true;
        if (engines != null && engines.length != 0) {
            for (TransformEngine engine : engines) {
                if (!(engine instanceof LastNTransformEngine)) continue;
                add = false;
                break;
            }
        }
        if (add) {
            chain.addEngine((TransformEngine)new LastNTransformEngine(this));
        }
    }

    @Override
    public void describe(ColibriConferenceIQ.ChannelCommon commonIq) {
        ColibriConferenceIQ.Channel iq = (ColibriConferenceIQ.Channel)commonIq;
        super.describe((ColibriConferenceIQ.ChannelCommon)iq);
        iq.setLastN(this.lastN);
    }

    public boolean getAdaptiveLastN() {
        return this.adaptiveLastN;
    }

    public boolean getAdaptiveSimulcast() {
        return this.adaptiveSimulcast;
    }

    private BitrateController getBitrateController() {
        if (this.bitrateController == null) {
            this.bitrateController = new BitrateController(this);
        }
        return this.bitrateController;
    }

    public long getIncomingBitrate() {
        return this.incomingBitrate.getRate(System.currentTimeMillis());
    }

    public int getLastN() {
        Integer lastNInteger = this.lastN;
        return lastNInteger == null ? -1 : lastNInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> getLastNEndpoints() {
        List<Endpoint> endpoints;
        Lock readLock = this.lastNSyncRoot.readLock();
        readLock.lock();
        try {
            if (this.lastNEndpoints == null || this.lastNEndpoints.isEmpty()) {
                endpoints = Collections.emptyList();
            } else {
                endpoints = new ArrayList(this.lastNEndpoints.size());
                for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                    Endpoint endpoint = (Endpoint)wr.get();
                    if (endpoint == null) continue;
                    endpoints.add(endpoint);
                }
            }
            Object var7_6 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            readLock.unlock();
            throw throwable;
        }
        return endpoints;
    }

    private Endpoint getEffectivePinnedEndpoint() {
        Endpoint thisEndpoint = this.getEndpoint();
        Endpoint pinnedEndpoint = thisEndpoint.getPinnedEndpoint();
        return thisEndpoint != null && !thisEndpoint.equals(pinnedEndpoint) ? pinnedEndpoint : null;
    }

    public int getReceivingEndpointCount() {
        int receivingEndpointCount = this.getLastN() == -1 ? this.getContent().getConference().getEndpointCount() : this.getLastNEndpoints().size();
        return receivingEndpointCount;
    }

    public Iterator<Endpoint> getReceivingEndpoints() {
        final List<Endpoint> endpoints = this.getLastN() == -1 ? this.getContent().getConference().getEndpoints() : this.getLastNEndpoints();
        final int lastIx = endpoints.size() - 1;
        return new Iterator<Endpoint>(){
            private int ix = 0;

            @Override
            public boolean hasNext() {
                return this.ix <= lastIx;
            }

            @Override
            public Endpoint next() {
                if (this.hasNext()) {
                    return (Endpoint)endpoints.get(this.ix++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public SimulcastManager getSimulcastManager() {
        return this.simulcastManager;
    }

    private void inLastNChanged(boolean oldValue, boolean newValue) {
        Endpoint endpoint = this.getEndpoint();
        if (endpoint != null) {
            try {
                endpoint.sendMessageOnDataChannel("{\"colibriClass\":\"InLastNChangeEvent\",\"oldValue\":" + oldValue + ",\"newValue\":" + newValue + "}");
            }
            catch (IOException ex) {
                logger.error((Object)"Failed to send message on data channel.", (Throwable)ex);
            }
        }
    }

    public boolean isInLastN() {
        return this.inLastN.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInLastN(Channel channel) {
        int lastN = this.getLastN();
        if (lastN < 0) {
            return true;
        }
        Endpoint channelEndpoint = channel.getEndpoint();
        if (channelEndpoint == null) {
            return true;
        }
        ConferenceSpeechActivity conferenceSpeechActivity = this.conferenceSpeechActivity;
        if (conferenceSpeechActivity == null) {
            return true;
        }
        if (lastN == 0) {
            return false;
        }
        if (this.lastNEndpoints == null) {
            this.speechActivityEndpointsChanged(null);
        }
        Lock readLock = this.lastNSyncRoot.readLock();
        boolean inLastN = false;
        readLock.lock();
        try {
            if (this.lastNEndpoints != null) {
                int n = 0;
                Endpoint pinnedEndpoint = this.getEffectivePinnedEndpoint();
                int nMax = pinnedEndpoint == null ? lastN : lastN - 1;
                Endpoint thisEndpoint = this.getEndpoint();
                for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                    if (n >= nMax) break;
                    Endpoint e = (Endpoint)wr.get();
                    if (e != null) {
                        if (e.equals(thisEndpoint)) continue;
                        if (e.equals(channelEndpoint)) {
                            inLastN = true;
                            break;
                        }
                    }
                    ++n;
                }
                if (!inLastN && pinnedEndpoint != null) {
                    inLastN = channelEndpoint == pinnedEndpoint;
                }
            }
            Object var15_14 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            readLock.unlock();
            throw throwable;
        }
        return inLastN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lastNEndpointsChanged(List<Endpoint> endpointsEnteringLastN) {
        try {
            this.sendLastNEndpointsChangeEventOnDataChannel(endpointsEnteringLastN);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            VideoChannel.updateInLastN(this);
            throw throwable;
        }
        VideoChannel.updateInLastN(this);
    }

    private int lastNIndexOf(List<Endpoint> endpoints, int lastN, Endpoint endpoint) {
        Endpoint thisEndpoint = this.getEndpoint();
        int n = 0;
        for (Endpoint e : endpoints) {
            if (n >= lastN) break;
            if (e.equals(thisEndpoint)) continue;
            if (e.equals(endpoint)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        super.propertyChange(ev);
        String propertyName = ev.getPropertyName();
        if (Endpoint.PINNED_ENDPOINT_PROPERTY_NAME.equals(propertyName)) {
            if (this.getLastN() < 1) {
                return;
            }
            List<Endpoint> channelEndpointsToAskForKeyframes = this.speechActivityEndpointsChanged(null, true);
            if (channelEndpointsToAskForKeyframes != null && !channelEndpointsToAskForKeyframes.isEmpty()) {
                this.getContent().askForKeyframes(channelEndpointsToAskForKeyframes);
            }
        }
    }

    public void receivedREMB(long remb) {
        BitrateController bc = this.getBitrateController();
        if (bc != null) {
            bc.receivedREMB(remb);
        }
    }

    @Override
    boolean rtpTranslatorWillWrite(boolean data, byte[] buffer, int offset, int length, Channel source) {
        boolean accept = true;
        if (data && source != null && (accept = this.isInLastN(source)) && source instanceof VideoChannel) {
            VideoChannel videoChannel = (VideoChannel)source;
            accept = this.simulcastManager.accept(buffer, offset, length, videoChannel);
        }
        return accept;
    }

    @Override
    void sctpConnectionReady(Endpoint endpoint) {
        super.sctpConnectionReady(endpoint);
        if (endpoint.equals(this.getEndpoint())) {
            this.lastNEndpointsChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLastNEndpointsChangeEventOnDataChannel(List<Endpoint> endpointsEnteringLastN) {
        int lastN = this.getLastN();
        if (lastN < 0) {
            return;
        }
        Endpoint thisEndpoint = this.getEndpoint();
        if (thisEndpoint == null) {
            return;
        }
        Lock readLock = this.lastNSyncRoot.readLock();
        StringBuilder lastNEndpointsStr = new StringBuilder();
        List<Endpoint> effectiveEndpointsEnteringLastN = endpointsEnteringLastN;
        if (effectiveEndpointsEnteringLastN == null) {
            effectiveEndpointsEnteringLastN = new ArrayList<Endpoint>(lastN);
        }
        Endpoint pinnedEndpoint = this.getEffectivePinnedEndpoint();
        readLock.lock();
        try {
            if (this.lastNEndpoints != null && !this.lastNEndpoints.isEmpty()) {
                int n = 0;
                boolean foundPinnedEndpoint = pinnedEndpoint == null;
                for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                    if (n >= lastN) break;
                    Endpoint e = (Endpoint)wr.get();
                    if (!foundPinnedEndpoint) {
                        if (n == lastN - 1) {
                            e = pinnedEndpoint;
                        } else {
                            boolean bl = foundPinnedEndpoint = e == pinnedEndpoint;
                        }
                    }
                    if (e != null) {
                        if (e.equals(thisEndpoint)) continue;
                        if (lastNEndpointsStr.length() != 0) {
                            lastNEndpointsStr.append(',');
                        }
                        lastNEndpointsStr.append('\"');
                        lastNEndpointsStr.append(JSONValue.escape((String)e.getID()));
                        lastNEndpointsStr.append('\"');
                        if (effectiveEndpointsEnteringLastN != endpointsEnteringLastN) {
                            effectiveEndpointsEnteringLastN.add(e);
                        }
                    }
                    ++n;
                }
            }
            Object var14_16 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            readLock.unlock();
            throw throwable;
        }
        StringBuilder msg = new StringBuilder("{\"colibriClass\":\"LastNEndpointsChangeEvent\"");
        msg.append(",\"lastNEndpoints\":[");
        msg.append((CharSequence)lastNEndpointsStr);
        msg.append(']');
        endpointsEnteringLastN = effectiveEndpointsEnteringLastN;
        if (endpointsEnteringLastN != null && !endpointsEnteringLastN.isEmpty()) {
            StringBuilder endpointsEnteringLastNStr = new StringBuilder();
            for (Endpoint e : endpointsEnteringLastN) {
                if (endpointsEnteringLastNStr.length() != 0) {
                    endpointsEnteringLastNStr.append(',');
                }
                endpointsEnteringLastNStr.append('\"');
                endpointsEnteringLastNStr.append(JSONValue.escape((String)e.getID()));
                endpointsEnteringLastNStr.append('\"');
            }
            if (endpointsEnteringLastNStr.length() != 0) {
                msg.append(",\"endpointsEnteringLastN\":[");
                msg.append((CharSequence)endpointsEnteringLastNStr);
                msg.append(']');
            }
        }
        msg.append('}');
        try {
            thisEndpoint.sendMessageOnDataChannel(msg.toString());
        }
        catch (IOException e) {
            logger.error((Object)"Failed to send message on data channel.", (Throwable)e);
        }
    }

    @Override
    public void setAdaptiveLastN(boolean adaptiveLastN) {
        this.adaptiveLastN = adaptiveLastN;
        if (adaptiveLastN) {
            this.getContent().setRTCPTerminationStrategyFQN(BasicBridgeRTCPTerminationStrategy.class.getName());
        }
    }

    @Override
    public void setAdaptiveSimulcast(boolean adaptiveSimulcast) {
        this.adaptiveSimulcast = adaptiveSimulcast;
        if (adaptiveSimulcast) {
            this.getContent().setRTCPTerminationStrategyFQN(BasicBridgeRTCPTerminationStrategy.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastN(Integer lastN) {
        if (this.lastN == lastN) {
            return;
        }
        boolean askForKeyframes = this.lastN == null;
        Lock writeLock = this.lastNSyncRoot.writeLock();
        LinkedList<Endpoint> endpointsEnteringLastN = new LinkedList<Endpoint>();
        writeLock.lock();
        try {
            if (this.lastN != null && this.lastN >= 0 && lastN > this.lastN) {
                Endpoint pinnedEndpoint = this.getEffectivePinnedEndpoint();
                int n = pinnedEndpoint != null ? 1 : 0;
                Endpoint thisEndpoint = this.getEndpoint();
                if (this.lastNEndpoints == null) {
                    this.speechActivityEndpointsChanged(null);
                }
                if (this.lastNEndpoints != null) {
                    for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                        if (n >= lastN) break;
                        Endpoint endpoint = (Endpoint)wr.get();
                        if (endpoint != null && (endpoint.equals(thisEndpoint) || endpoint.equals(pinnedEndpoint)) || ++n <= this.lastN || endpoint == null) continue;
                        endpointsEnteringLastN.add(endpoint);
                    }
                }
            }
            this.lastN = lastN;
            Object var12_11 = null;
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            writeLock.unlock();
            throw throwable;
        }
        this.lastNEndpointsChanged(endpointsEnteringLastN);
        if (askForKeyframes) {
            this.getContent().askForKeyframes(new HashSet<Endpoint>(endpointsEnteringLastN));
        }
        this.touch();
    }

    @Override
    List<Endpoint> speechActivityEndpointsChanged(List<Endpoint> endpoints) {
        return this.speechActivityEndpointsChanged(endpoints, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Endpoint> speechActivityEndpointsChanged(List<Endpoint> endpoints, boolean pinnedEndpointChanged) {
        Lock writeLock = this.lastNSyncRoot.writeLock();
        ArrayList<Endpoint> endpointsEnteringLastN = null;
        boolean lastNEndpointsChanged = pinnedEndpointChanged;
        writeLock.lock();
        try {
            int lastN = this.getLastN();
            if (endpoints == null) {
                endpoints = this.conferenceSpeechActivity.getEndpoints();
            }
            if (lastN >= 0) {
                Endpoint thisEndpoint = this.getEndpoint();
                endpointsEnteringLastN = new ArrayList<Endpoint>(lastN);
                Endpoint pinnedEndpoint = this.getEffectivePinnedEndpoint();
                if (pinnedEndpoint != null && lastN > 0) {
                    endpointsEnteringLastN.add(pinnedEndpoint);
                }
                for (Endpoint e : endpoints) {
                    if (endpointsEnteringLastN.size() >= lastN) break;
                    if (e.equals(thisEndpoint) || e.equals(pinnedEndpoint)) continue;
                    endpointsEnteringLastN.add(e);
                }
                if (this.lastNEndpoints != null && !this.lastNEndpoints.isEmpty()) {
                    int n = 0;
                    for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                        if (n >= lastN) break;
                        Endpoint e = (Endpoint)wr.get();
                        if (e != null) {
                            if (e.equals(thisEndpoint)) continue;
                            endpointsEnteringLastN.remove(e);
                            if (this.lastNIndexOf(endpoints, lastN, e) < 0) {
                                lastNEndpointsChanged = true;
                            }
                        }
                        ++n;
                    }
                }
            }
            this.lastNEndpoints = new ArrayList<WeakReference<Endpoint>>(endpoints.size());
            for (Endpoint endpoint : endpoints) {
                this.lastNEndpoints.add(new WeakReference<Endpoint>(endpoint));
            }
            Object var14_14 = null;
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            writeLock.unlock();
            throw throwable;
        }
        if (endpointsEnteringLastN != null && !endpointsEnteringLastN.isEmpty()) {
            lastNEndpointsChanged = true;
        }
        if (lastNEndpointsChanged) {
            this.lastNEndpointsChanged(endpointsEnteringLastN);
        }
        return endpointsEnteringLastN;
    }

    @Override
    protected void streamRTPConnectorChanged(RTPConnector oldValue, RTPConnector newValue) {
        super.streamRTPConnectorChanged(oldValue, newValue);
        Object engine = newValue instanceof RTPTransformTCPConnector ? ((RTPTransformTCPConnector)newValue).getEngine() : (newValue instanceof RTPTransformUDPConnector ? ((RTPTransformUDPConnector)newValue).getEngine() : null);
        if (engine != null && engine instanceof TransformEngineChain) {
            this.configureTransformEngineChain((TransformEngineChain)engine);
        }
    }

    private void updateInLastN(Channel[] channels) {
        boolean inLastN;
        if (channels.length == 0) {
            inLastN = true;
        } else {
            Endpoint endpoint = this.getEndpoint();
            inLastN = true;
            for (Channel c : channels) {
                if (!(this.equals((Object)c) || endpoint != null && endpoint.equals(c.getEndpoint()) || !(inLastN = ((VideoChannel)c).isInLastN(this)))) break;
            }
        }
        if (this.inLastN.compareAndSet(!inLastN, inLastN)) {
            this.inLastNChanged(!inLastN, inLastN);
        }
    }

    @Override
    public void setPayloadTypes(List<PayloadTypePacketExtension> payloadTypes) {
        super.setPayloadTypes(payloadTypes);
        boolean enableRedFilter = true;
        if (payloadTypes == null || payloadTypes.size() == 0) {
            return;
        }
        if (payloadTypes != null) {
            for (PayloadTypePacketExtension payloadTypePacketExtension : payloadTypes) {
                if (!"red".equals(payloadTypePacketExtension.getName())) continue;
                enableRedFilter = false;
                break;
            }
        }
        if (this.transformEngine != null) {
            this.transformEngine.enableREDFilter(enableRedFilter);
        }
    }

    @Override
    public void handleNACK(NACKPacket nackPacket) {
        RawPacketCache cache;
        HashSet lostPackets = new HashSet();
        lostPackets.addAll(nackPacket.getLostPackets());
        long ssrc = nackPacket.sourceSSRC;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received NACK on channel " + this.getID() + " for SSRC " + ssrc + ". Packets reported lost: " + lostPackets));
        }
        if ((cache = this.transformEngine.getCache()) != null) {
            Iterator iter = lostPackets.iterator();
            while (iter.hasNext()) {
                int seq = (Integer)iter.next();
                RawPacket pkt = cache.get(ssrc, seq);
                if (pkt == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Retransmitting packet from cache. SSRC " + ssrc + " seq " + seq));
                }
                this.getStream().injectPacket(this.createPacketForRetransmission(pkt), true, true);
                iter.remove();
            }
        }
        if (!lostPackets.isEmpty() && this.transformEngine.retransmissionsRequestsEnabled() && logger.isDebugEnabled()) {
            logger.debug((Object)"Packets missing from the cache. Ignoring, because retransmission requests are enabled.");
        }
        if (!lostPackets.isEmpty() && !this.transformEngine.retransmissionsRequestsEnabled()) {
            NACKPacket newNack = new NACKPacket(nackPacket.senderSSRC, ssrc, lostPackets);
            RawPacket pkt = null;
            try {
                pkt = newNack.toRawPacket();
            }
            catch (IOException ioe) {
                logger.warn((Object)("Failed to create NACK packet: " + ioe));
            }
            if (pkt != null) {
                HashSet<RtpChannel> channelsToSendTo = new HashSet<RtpChannel>();
                Channel channel = this.getContent().findChannelByReceiveSSRC(ssrc);
                if (channel != null && channel instanceof RtpChannel) {
                    channelsToSendTo.add((RtpChannel)channel);
                } else {
                    for (Channel c : this.getContent().getChannels()) {
                        if (c == null || !(c instanceof RtpChannel) || c == this) continue;
                        channelsToSendTo.add((RtpChannel)c);
                    }
                }
                for (RtpChannel c : channelsToSendTo) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Sending a NACK for SSRC " + ssrc + " , packets " + lostPackets + " on channel " + c.getID()));
                    }
                    c.getStream().injectPacket(pkt, false, true);
                }
            }
        }
    }

    private RawPacket createPacketForRetransmission(RawPacket pkt) {
        return pkt;
    }
}

