/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPSDES;

public class RTCPSDESPacket
extends RTCPPacket {
    public RTCPSDES[] sdes;

    public RTCPSDESPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 202;
    }

    public RTCPSDESPacket(RTCPSDES[] rTCPSDESArray) {
        if (rTCPSDESArray.length > 31) {
            throw new IllegalArgumentException("Too many SDESs");
        }
        this.sdes = rTCPSDESArray;
    }

    public void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.sdes.length);
        dataOutputStream.writeByte(202);
        dataOutputStream.writeShort(this.calcLength() - 4 >> 2);
        for (int i = 0; i < this.sdes.length; ++i) {
            int n;
            dataOutputStream.writeInt(this.sdes[i].ssrc);
            int n2 = 0;
            for (n = 0; n < this.sdes[i].items.length; ++n) {
                dataOutputStream.writeByte(this.sdes[i].items[n].type);
                dataOutputStream.writeByte(this.sdes[i].items[n].data.length);
                dataOutputStream.write(this.sdes[i].items[n].data);
                n2 += 2 + this.sdes[i].items[n].data.length;
            }
            for (n = (n2 + 4 & 0xFFFFFFFC) - n2; n > 0; --n) {
                dataOutputStream.writeByte(0);
            }
        }
    }

    public int calcLength() {
        int n = 4;
        for (int i = 0; i < this.sdes.length; ++i) {
            int n2 = 5;
            for (int j = 0; j < this.sdes[i].items.length; ++j) {
                n2 += 2 + this.sdes[i].items[j].data.length;
            }
            n2 = n2 + 3 & 0xFFFFFFFC;
            n += n2;
        }
        return n;
    }

    public String toString() {
        return "\tRTCP SDES Packet:\n" + RTCPSDES.toString(this.sdes);
    }
}

