/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;

public class RTCPAPPPacket
extends RTCPPacket {
    int ssrc;
    int name;
    int subtype;
    byte[] data;

    public RTCPAPPPacket(int n, int n2, int n3, byte[] byArray) {
        if ((byArray.length & 3) != 0) {
            throw new IllegalArgumentException("Bad data length");
        }
        if (n3 < 0 || n3 > 31) {
            throw new IllegalArgumentException("Bad subtype");
        }
        this.ssrc = n;
        this.name = n2;
        this.subtype = n3;
        this.data = byArray;
        this.type = 204;
        this.received = false;
    }

    public RTCPAPPPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 204;
    }

    public void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.subtype);
        dataOutputStream.writeByte(204);
        dataOutputStream.writeShort(2 + (this.data.length >> 2));
        dataOutputStream.writeInt(this.ssrc);
        dataOutputStream.writeInt(this.name);
        dataOutputStream.write(this.data);
    }

    public int calcLength() {
        return 12 + this.data.length;
    }

    public String nameString(int n) {
        return "" + (char)(n >>> 24) + (char)(n >>> 16 & 0xFF) + (char)(n >>> 8 & 0xFF) + (char)(n & 0xFF);
    }

    public String toString() {
        return "\tRTCP APP Packet from SSRC " + this.ssrc + " with name " + this.nameString(this.name) + " and subtype " + this.subtype + "\n\tData (length " + this.data.length + "): " + new String(this.data) + "\n";
    }
}

