/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.media.Controller;
import javax.media.Time;
import net.sf.fmj.ejmf.toolkit.gui.controls.MouseListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

public class StandardReverseControl
extends MouseListenerControl {
    public StandardReverseControl(Skin skin) {
        super(skin);
    }

    public StandardReverseControl(Skin skin, Controller controller) {
        this(skin);
        this.setController(controller);
    }

    protected Component createControlComponent(Skin skin) {
        return skin.createReverseButton();
    }

    protected EventListener createControlListener() {
        return new MouseAdapter(){
            int priorState;
            float saveRate;

            public void mousePressed(MouseEvent mouseEvent) {
                if (StandardReverseControl.this.isOperational()) {
                    Controller controller = StandardReverseControl.this.getController();
                    this.saveRate = controller.getRate();
                    this.priorState = controller.getState();
                    if (this.priorState == 600) {
                        controller.stop();
                    }
                    controller.setRate(-1.0f * this.saveRate);
                    Time time = controller.getTimeBase().getTime();
                    controller.syncStart(time);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (StandardReverseControl.this.isOperational()) {
                    Controller controller = StandardReverseControl.this.getController();
                    controller.setRate(this.saveRate);
                    if (this.priorState != 600) {
                        controller.stop();
                    }
                }
            }
        };
    }

    protected void setControllerHook(Controller controller) {
        this.setOperational(false);
    }

    protected void setOperational(boolean bl) {
        super.setOperational(bl);
        this.getControlComponent().setEnabled(bl);
    }
}

