/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.vfw;

import com.sun.media.format.AviVideoFormat;
import java.awt.Dimension;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitMapInfo {
    public int biWidth;
    public int biHeight;
    public int biPlanes;
    public int biBitCount;
    public String fourcc;
    public int biSizeImage;
    public int biXPelsPerMeter;
    public int biYPelsPerMeter;
    public int biClrUsed;
    public int biClrImportant;
    public int extraSize;
    public byte[] extraBytes;

    public BitMapInfo() {
        this.fourcc = "";
        this.biPlanes = 1;
        this.biBitCount = 24;
    }

    public BitMapInfo(String string, int n, int n2) {
        this.fourcc = string;
        this.biPlanes = 1;
        this.biBitCount = 24;
        this.biWidth = n;
        this.biHeight = n2;
        if (string.equals("RGB")) {
            this.biSizeImage = this.biWidth * this.biHeight * (this.biBitCount / 8);
        }
    }

    public BitMapInfo(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fourcc = string;
        this.biPlanes = n3;
        this.biBitCount = n4;
        this.biWidth = n;
        this.biHeight = n2;
        this.biSizeImage = n5;
        this.biClrUsed = n6;
        this.biClrImportant = n7;
    }

    public BitMapInfo(VideoFormat videoFormat) {
        if (videoFormat instanceof RGBFormat) {
            RGBFormat rGBFormat = (RGBFormat)videoFormat;
            this.fourcc = rGBFormat.getEncoding().toUpperCase();
            this.biPlanes = 1;
            this.biBitCount = rGBFormat.getBitsPerPixel();
            if (rGBFormat.getSize() == null) {
                this.biWidth = 320;
                this.biHeight = 240;
            } else {
                this.biWidth = rGBFormat.getSize().width;
                this.biHeight = rGBFormat.getSize().height;
            }
            this.biSizeImage = this.biBitCount == -1 ? -2 : this.biWidth * this.biHeight * (this.biBitCount / 8);
            this.biClrUsed = 0;
            this.biClrImportant = 0;
        } else if (videoFormat instanceof AviVideoFormat) {
            AviVideoFormat aviVideoFormat = (AviVideoFormat)videoFormat;
            this.fourcc = aviVideoFormat.getEncoding();
            this.biPlanes = aviVideoFormat.getPlanes();
            this.biBitCount = aviVideoFormat.getBitsPerPixel();
            this.biWidth = aviVideoFormat.getSize().width;
            this.biHeight = aviVideoFormat.getSize().height;
            this.biSizeImage = aviVideoFormat.getImageSize();
            this.biClrUsed = aviVideoFormat.getClrUsed();
            this.biClrImportant = aviVideoFormat.getClrImportant();
        } else if (videoFormat instanceof YUVFormat) {
            YUVFormat yUVFormat = (YUVFormat)videoFormat;
            if (yUVFormat.getYuvType() == 2) {
                this.fourcc = "YV12";
                this.biBitCount = 12;
            } else {
                this.fourcc = videoFormat.getEncoding();
                this.biBitCount = 24;
            }
            this.biWidth = 320;
            this.biHeight = 240;
            this.biPlanes = 1;
            this.biSizeImage = -1;
        } else {
            this.fourcc = videoFormat.getEncoding();
            this.biBitCount = 24;
            this.biWidth = 320;
            this.biHeight = 240;
            this.biPlanes = 1;
            this.biSizeImage = -1;
        }
    }

    public VideoFormat createVideoFormat(Class<?> clazz) {
        return this.createVideoFormat(clazz, -1.0f);
    }

    public VideoFormat createVideoFormat(Class<?> clazz, float f) {
        if (this.fourcc.equals("RGB")) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            if (this.biBitCount == 32) {
                if (clazz == int[].class) {
                    n5 = 0xFF0000;
                    n4 = 65280;
                    n3 = 255;
                } else {
                    n5 = 3;
                    n4 = 2;
                    n3 = 1;
                }
            } else if (this.biBitCount == 24) {
                n5 = 3;
                n4 = 2;
                n3 = 1;
            } else if (this.biBitCount == 16) {
                n5 = 31744;
                n4 = 992;
                n3 = 31;
            } else {
                n3 = -1;
                n4 = -1;
                n5 = -1;
            }
            if (clazz == int[].class) {
                n2 = this.biBitCount / 32;
                n = this.biSizeImage / 4;
            } else if (clazz == byte[].class) {
                n2 = this.biBitCount / 8;
                n = this.biSizeImage;
            } else if (clazz == short[].class) {
                n2 = this.biBitCount / 16;
                n = this.biSizeImage / 2;
            } else {
                boolean bl = false;
                boolean bl2 = false;
                throw new IllegalArgumentException();
            }
            int n6 = n2 * this.biWidth;
            return new RGBFormat(new Dimension(this.biWidth, this.biHeight), n, clazz, f, this.biBitCount, n5, n4, n3, n2, n6, 1, 1);
        }
        if (this.fourcc.equals("YV12")) {
            return new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, byte[].class, f, 2, this.biWidth, this.biWidth / 2, 0, this.biWidth * this.biHeight + this.biWidth * this.biHeight / 4, this.biWidth * this.biHeight);
        }
        if (this.fourcc.equals("I420")) {
            return new YUVFormat(new Dimension(this.biWidth, this.biHeight), this.biSizeImage, byte[].class, f, 2, this.biWidth, this.biWidth / 2, 0, this.biWidth * this.biHeight, this.biWidth * this.biHeight + this.biWidth * this.biHeight / 4);
        }
        return new AviVideoFormat(this.fourcc, new Dimension(this.biWidth, this.biHeight), this.biSizeImage, clazz, f, this.biPlanes, this.biBitCount, this.biSizeImage, this.biXPelsPerMeter, this.biYPelsPerMeter, this.biClrUsed, this.biClrImportant, this.extraBytes);
    }

    public String toString() {
        return "Size = " + this.biWidth + " x " + this.biHeight + "\tPlanes = " + this.biPlanes + "\tBitCount = " + this.biBitCount + "\tFourCC = " + this.fourcc + "\tSizeImage = " + this.biSizeImage + "\nClrUsed = " + this.biClrUsed + "\nClrImportant = " + this.biClrImportant + "\nExtraSize = " + this.extraSize + "\n";
    }
}

