/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.util.Map;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuxServerSocketChannelFactory {
    private static final Logger logger;
    private static final Method OPEN_AND_BIND_METHOD;
    public static final int SOCKET_CHANNEL_READ_TIMEOUT = 15000;
    public static final String SOCKET_REUSE_ADDRESS_PROPERTY_NAME = "socket.reuseAddress";

    public static void closeNoExceptions(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ServerSocketChannel openAndBindMuxServerSocketChannel(Map<String, Object> properties, SocketAddress endpoint, int backlog, DatagramPacketFilter filter) throws IOException {
        Method method = OPEN_AND_BIND_METHOD;
        if (method == null) {
            return MuxServerSocketChannelFactory.openAndBindServerSocketChannel(properties, endpoint, backlog);
        }
        try {
            return (ServerSocketChannel)method.invoke(null, properties, endpoint, backlog, filter);
        }
        catch (IllegalAccessException iaex) {
            IllegalAccessError iaerr = new IllegalAccessError(iaex.getMessage());
            iaerr.initCause(iaex);
            throw iaerr;
        }
        catch (InvocationTargetException itex) {
            Throwable cause = itex.getCause();
            if (cause == null) {
                throw new RuntimeException(itex);
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static ServerSocketChannel openAndBindServerSocketChannel(Map<String, Object> properties, SocketAddress endpoint, int backlog) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        ServerSocket socket = channel.socket();
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                String name = property.getKey();
                if (!SOCKET_REUSE_ADDRESS_PROPERTY_NAME.equals(name)) continue;
                Object value = property.getValue();
                boolean on = value == null ? false : (value instanceof Boolean ? ((Boolean)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue());
                socket.setReuseAddress(on);
            }
        }
        socket.bind(endpoint, backlog);
        return channel;
    }

    static {
        Method method;
        Class<?> clazz;
        logger = Logger.getLogger(MuxServerSocketChannelFactory.class.getName());
        try {
            clazz = Class.forName("org.ice4j.socket.jdk8.MuxServerSocketChannel");
        }
        catch (ClassNotFoundException cnfex) {
            clazz = null;
            logger.warning("ICE4J does not support sharing of listening endpoints (probably because it was not built on JDK 8).");
        }
        catch (LinkageError lerr) {
            clazz = null;
            logger.warning("ICE4J does not support sharing of listening endpoints (probably because it is not running on JDK 8).");
        }
        if (clazz == null) {
            method = null;
        } else {
            try {
                method = clazz.getDeclaredMethod("openAndBind", Map.class, SocketAddress.class, Integer.TYPE, DatagramPacketFilter.class);
            }
            catch (NoSuchMethodException nsmex) {
                throw new RuntimeException(nsmex);
            }
        }
        OPEN_AND_BIND_METHOD = method;
    }
}

