/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.examples.interpreter;

import org.xml.sax.SAXException;
import weblogic.xml.babel.examples.interpreter.BooleanExp;
import weblogic.xml.babel.examples.interpreter.BooleanInterpreter;
import weblogic.xml.babel.examples.interpreter.Context;
import weblogicx.xml.stream.StartElementEvent;
import weblogicx.xml.stream.XMLEventStream;

class Constant
extends BooleanExp {
    private boolean value;

    public Constant() {
    }

    public Constant(String string) throws SAXException {
        this.value = this.stringToBool(string);
    }

    public Constant(boolean bl) {
        this.value = bl;
    }

    public boolean evaluate(Context context) {
        return this.value;
    }

    public BooleanExp copy() {
        return new Constant(true);
    }

    public BooleanExp replace(String string, BooleanExp booleanExp) {
        return this;
    }

    private boolean stringToBool(String string) throws SAXException {
        if (string.equals("false")) {
            return false;
        }
        if (string.equals("true")) {
            return true;
        }
        throw new SAXException("Constants must be true or false");
    }

    public void read(XMLEventStream xMLEventStream) throws SAXException {
        StartElementEvent startElementEvent = xMLEventStream.startElement();
        String string = BooleanInterpreter.getArgument("value", startElementEvent);
        this.value = this.stringToBool(string);
    }

    public String toString() {
        return new Boolean(this.value).toString();
    }
}

