/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPRawSender;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTCPTransmitter {
    RTCPRawSender sender;
    OverallStats stats = null;
    SSRCCache cache;
    int sdescounter = 0;
    SSRCInfo ssrcInfo = null;

    public RTCPTransmitter(SSRCCache cache) {
        this.cache = cache;
        this.stats = cache.sm.defaultstats;
    }

    public RTCPTransmitter(SSRCCache cache, int port, String address) throws UnknownHostException, IOException {
        this(cache, new RTCPRawSender(port, address));
    }

    public RTCPTransmitter(SSRCCache cache, int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(cache, new RTCPRawSender(port, address, sender));
    }

    public RTCPTransmitter(SSRCCache cache, RTCPRawSender sender) {
        this(cache);
        this.setSender(sender);
        this.stats = cache.sm.defaultstats;
    }

    public void bye(int ssrc, byte[] reason) {
        double delay;
        if (!this.cache.rtcpsent) {
            return;
        }
        this.cache.byestate = true;
        Vector repvec = this.makereports();
        Object[] packets = new RTCPPacket[repvec.size() + 1];
        repvec.copyInto(packets);
        int[] ssrclist = new int[]{ssrc};
        RTCPBYEPacket byep = new RTCPBYEPacket(ssrclist, reason);
        packets[packets.length - 1] = byep;
        RTCPCompoundPacket cp = new RTCPCompoundPacket((RTCPPacket[])packets);
        RTCPTransmitter _tmp = this;
        if (this.cache.aliveCount() > 50) {
            this.cache.reset(byep.length);
            delay = this.cache.calcReportInterval(this.ssrcInfo.sender, false);
        } else {
            delay = 0.0;
        }
        try {
            Thread.sleep((long)delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.transmit(cp);
        this.sdescounter = 0;
    }

    public void bye(String reason) {
        if (reason != null) {
            this.bye(this.ssrcInfo.ssrc, reason.getBytes());
        } else {
            this.bye(this.ssrcInfo.ssrc, null);
        }
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    public RTCPRawSender getSender() {
        return this.sender;
    }

    protected RTCPReportBlock[] makerecreports(long time) {
        Vector<RTCPReportBlock> reports = new Vector<RTCPReportBlock>();
        Enumeration<Object> elements = this.cache.cache.elements();
        while (elements.hasMoreElements()) {
            double frac;
            SSRCInfo info = (SSRCInfo)elements.nextElement();
            if (info.ours || !info.sender) continue;
            RTCPReportBlock rep = new RTCPReportBlock();
            rep.ssrc = info.ssrc;
            rep.lastseq = info.maxseq + info.cycles;
            rep.jitter = (int)info.jitter;
            rep.lsr = (int)((info.lastSRntptimestamp & 0xFFFFFFFF0000L) >> 16);
            rep.dlsr = (int)((double)(time - info.lastSRreceiptTime) * 65.536);
            rep.packetslost = (int)(rep.lastseq - (long)info.baseseq + 1L - (long)info.received);
            if (rep.packetslost < 0) {
                rep.packetslost = 0;
            }
            if ((frac = (double)(rep.packetslost - info.prevlost) / (double)(rep.lastseq - (long)info.prevmaxseq)) < 0.0) {
                frac = 0.0;
            }
            rep.fractionlost = (int)(frac * 256.0);
            info.prevmaxseq = (int)rep.lastseq;
            info.prevlost = rep.packetslost;
            reports.addElement(rep);
        }
        Object[] reportsarr = new RTCPReportBlock[reports.size()];
        reports.copyInto(reportsarr);
        return reportsarr;
    }

    protected Vector makereports() {
        RTCPReportBlock[] reports;
        Vector<RTCPPacket> packets = new Vector<RTCPPacket>();
        SSRCInfo ourinfo = this.ssrcInfo;
        boolean senderreport = false;
        if (ourinfo.sender) {
            senderreport = true;
        }
        long time = System.currentTimeMillis();
        RTCPReportBlock[] firstrep = reports = this.makerecreports(time);
        if (reports.length > 31) {
            firstrep = new RTCPReportBlock[31];
            System.arraycopy(reports, 0, firstrep, 0, 31);
        }
        if (senderreport) {
            RTCPSRPacket srp = new RTCPSRPacket(ourinfo.ssrc, firstrep);
            packets.addElement(srp);
            long systime = ourinfo.systime == 0L ? System.currentTimeMillis() : ourinfo.systime;
            long secs = systime / 1000L;
            double msecs = (double)(systime - secs * 1000L) / 1000.0;
            srp.ntptimestamplsw = (int)(msecs * 4.294967296E9);
            srp.ntptimestampmsw = secs;
            srp.rtptimestamp = (int)ourinfo.rtptime;
            srp.packetcount = ourinfo.maxseq - ourinfo.baseseq;
            srp.octetcount = ourinfo.bytesreceived;
        } else {
            RTCPRRPacket rrp = new RTCPRRPacket(ourinfo.ssrc, firstrep);
            packets.addElement(rrp);
        }
        if (firstrep != reports) {
            for (int offset = 31; offset < reports.length; offset += 31) {
                if (reports.length - offset < 31) {
                    firstrep = new RTCPReportBlock[reports.length - offset];
                }
                System.arraycopy(reports, offset, firstrep, 0, firstrep.length);
                RTCPRRPacket rrp = new RTCPRRPacket(ourinfo.ssrc, firstrep);
                packets.addElement(rrp);
            }
        }
        RTCPSDESPacket sp = new RTCPSDESPacket(new RTCPSDES[1]);
        sp.sdes[0] = new RTCPSDES();
        sp.sdes[0].ssrc = this.ssrcInfo.ssrc;
        Vector<RTCPSDESItem> itemvec = new Vector<RTCPSDESItem>();
        itemvec.addElement(new RTCPSDESItem(1, ourinfo.sourceInfo.getCNAME()));
        if (this.sdescounter % 3 == 0) {
            if (ourinfo.name != null && ourinfo.name.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(2, ourinfo.name.getDescription()));
            }
            if (ourinfo.email != null && ourinfo.email.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(3, ourinfo.email.getDescription()));
            }
            if (ourinfo.phone != null && ourinfo.phone.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(4, ourinfo.phone.getDescription()));
            }
            if (ourinfo.loc != null && ourinfo.loc.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(5, ourinfo.loc.getDescription()));
            }
            if (ourinfo.tool != null && ourinfo.tool.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(6, ourinfo.tool.getDescription()));
            }
            if (ourinfo.note != null && ourinfo.note.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(7, ourinfo.note.getDescription()));
            }
        }
        ++this.sdescounter;
        sp.sdes[0].items = new RTCPSDESItem[itemvec.size()];
        itemvec.copyInto(sp.sdes[0].items);
        packets.addElement(sp);
        return packets;
    }

    public void report() {
        Vector repvec = this.makereports();
        Object[] packets = new RTCPPacket[repvec.size()];
        repvec.copyInto(packets);
        RTCPCompoundPacket cp = new RTCPCompoundPacket((RTCPPacket[])packets);
        this.transmit(cp);
    }

    public void setSender(RTCPRawSender s) {
        this.sender = s;
    }

    public void setSSRCInfo(SSRCInfo info) {
        this.ssrcInfo = info;
    }

    protected void transmit(RTCPCompoundPacket p) {
        try {
            this.sender.sendTo(p);
            if (this.ssrcInfo instanceof SendSSRCInfo) {
                ++((SendSSRCInfo)this.ssrcInfo).stats.total_rtcp;
                ++this.cache.sm.transstats.rtcp_sent;
            }
            this.cache.updateavgrtcpsize(p.length);
            if (this.cache.initial) {
                this.cache.initial = false;
            }
            if (!this.cache.rtcpsent) {
                this.cache.rtcpsent = true;
            }
        }
        catch (IOException e) {
            this.stats.update(6, 1);
            ++this.cache.sm.transstats.transmit_failed;
        }
    }
}

