/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.StunCandidateHarvest;
import org.ice4j.ice.harvest.TurnCandidateHarvester;
import org.ice4j.security.LongTermCredential;
import org.ice4j.socket.IceTcpSocketWrapper;
import org.ice4j.socket.MultiplexingSocket;
import org.ice4j.stack.StunStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StunCandidateHarvester
extends CandidateHarvester {
    private static final Logger logger = Logger.getLogger(StunCandidateHarvester.class.getName());
    private final List<StunCandidateHarvest> completedHarvests = new LinkedList<StunCandidateHarvest>();
    private final String shortTermCredentialUsername;
    private final List<StunCandidateHarvest> startedHarvests = new LinkedList<StunCandidateHarvest>();
    public final TransportAddress stunServer;
    private StunStack stunStack;

    public StunCandidateHarvester(TransportAddress stunServer) {
        this(stunServer, null);
    }

    public StunCandidateHarvester(TransportAddress stunServer, String shortTermCredentialUsername) {
        this.stunServer = stunServer;
        this.shortTermCredentialUsername = shortTermCredentialUsername;
        if (System.getProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER") == null) {
            System.setProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER", "400");
        }
        if (System.getProperty("org.ice4j.MAX_RETRANSMISSIONS") == null) {
            System.setProperty("org.ice4j.MAX_RETRANSMISSIONS", "3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completedResolvingCandidate(StunCandidateHarvest harvest) {
        boolean doNotify = false;
        List<StunCandidateHarvest> list = this.startedHarvests;
        synchronized (list) {
            this.startedHarvests.remove(harvest);
            if (this.startedHarvests.isEmpty()) {
                doNotify = true;
            }
        }
        list = this.completedHarvests;
        synchronized (list) {
            if (harvest.getCandidateCount() < 1) {
                this.completedHarvests.remove(harvest);
            } else if (!this.completedHarvests.contains(harvest)) {
                this.completedHarvests.add(harvest);
            }
        }
        list = this.startedHarvests;
        synchronized (list) {
            if (doNotify) {
                this.startedHarvests.notify();
            }
        }
    }

    protected StunCandidateHarvest createHarvest(HostCandidate hostCandidate) {
        return new StunCandidateHarvest(this, hostCandidate);
    }

    protected LongTermCredential createLongTermCredential(StunCandidateHarvest harvest, byte[] realm) {
        return null;
    }

    protected String getShortTermCredentialUsername() {
        return this.shortTermCredentialUsername;
    }

    public StunStack getStunStack() {
        return this.stunStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        logger.fine("starting " + component.toShortString() + " harvest for: " + this.toString());
        this.stunStack = component.getParentStream().getParentAgent().getStunStack();
        for (Candidate list : component.getLocalCandidates()) {
            if (!(list instanceof HostCandidate) || list.getTransport() != this.stunServer.getTransport()) continue;
            this.startResolvingCandidate((HostCandidate)list);
        }
        this.waitForResolutionEnd();
        HashSet<LocalCandidate> candidates = new HashSet<LocalCandidate>();
        List<StunCandidateHarvest> list = this.completedHarvests;
        synchronized (list) {
            for (StunCandidateHarvest completedHarvest : this.completedHarvests) {
                LocalCandidate[] completedHarvestCandidates = completedHarvest.getCandidates();
                if (completedHarvestCandidates == null || completedHarvestCandidates.length == 0) continue;
                candidates.addAll(Arrays.asList(completedHarvestCandidates));
            }
            this.completedHarvests.clear();
        }
        logger.finest("Completed " + component.toShortString() + " harvest: " + this.toString() + ". Found " + candidates.size() + " candidates: " + this.listCandidates(candidates));
        return candidates;
    }

    private String listCandidates(Collection<? extends Candidate<?>> candidates) {
        StringBuilder retval = new StringBuilder();
        for (Candidate<?> candidate : candidates) {
            retval.append(candidate.toShortString());
        }
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResolvingCandidate(HostCandidate hostCand) {
        if (!hostCand.getTransportAddress().canReach(this.stunServer)) {
            return;
        }
        HostCandidate cand = this.getHostCandidate(hostCand);
        if (cand == null) {
            logger.info("server/candidate address type mismatch, skipping candidate in this harvester");
            return;
        }
        StunCandidateHarvest harvest = this.createHarvest(cand);
        if (harvest == null) {
            logger.warning("failed to create harvest");
            return;
        }
        List<StunCandidateHarvest> list = this.startedHarvests;
        synchronized (list) {
            this.startedHarvests.add(harvest);
            boolean started = false;
            try {
                started = harvest.startResolvingCandidate();
            }
            catch (Exception ex) {
                started = false;
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Failed to start resolving host candidate " + hostCand, ex);
                }
            }
            finally {
                if (!started) {
                    this.startedHarvests.remove(harvest);
                    logger.warning("harvest did not start, removed: " + harvest);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResolutionEnd() {
        List<StunCandidateHarvest> list = this.startedHarvests;
        synchronized (list) {
            boolean interrupted = false;
            while (!this.startedHarvests.isEmpty()) {
                try {
                    this.startedHarvests.wait();
                }
                catch (InterruptedException iex) {
                    logger.info("interrupted waiting for harvests to complete, no. startedHarvests = " + this.startedHarvests.size());
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        String proto = this instanceof TurnCandidateHarvester ? "TURN" : "STUN";
        return proto + " harvester(srvr: " + this.stunServer + ")";
    }

    protected HostCandidate getHostCandidate(HostCandidate hostCand) {
        HostCandidate cand = null;
        if (hostCand.getTransport() == Transport.TCP) {
            try {
                Socket sock = new Socket(this.stunServer.getAddress(), this.stunServer.getPort());
                cand = new HostCandidate(new IceTcpSocketWrapper(new MultiplexingSocket(sock)), hostCand.getParentComponent(), Transport.TCP);
                hostCand.getParentComponent().getParentStream().getParentAgent().getStunStack().addSocket(cand.getStunSocket(null));
            }
            catch (Exception io) {
                logger.info("Exception TCP client connect: " + io);
                return null;
            }
        } else {
            cand = hostCand;
        }
        return cand;
    }
}

