/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.impl;

import com.hazelcast.aws.security.EC2RequestSigner;
import com.hazelcast.aws.utility.CloudyUtility;
import com.hazelcast.config.AwsConfig;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeInstances {
    private static final int FIVE_MINUTES = 300000;
    private final EC2RequestSigner rs;
    private AwsConfig awsConfig;
    private Map<String, String> attributes = new HashMap<String, String>();

    public DescribeInstances(AwsConfig awsConfig) {
        this.rs = new EC2RequestSigner(awsConfig.getSecretKey());
        this.attributes.put("Action", this.getClass().getSimpleName());
        this.attributes.put("Version", "2011-05-15");
        this.attributes.put("SignatureVersion", "2");
        this.attributes.put("SignatureMethod", "HmacSHA256");
        this.attributes.put("AWSAccessKeyId", awsConfig.getAccessKey());
        this.attributes.put("Timestamp", this.getFormattedTimestamp());
        this.awsConfig = awsConfig;
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }

    public String getQueryString() {
        return CloudyUtility.getQueryString(this.attributes);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void putSignature(String value) {
        this.attributes.put("Signature", value);
    }

    public <T> T execute(String endpoint) throws Exception {
        this.rs.sign(this, endpoint);
        Object result = this.callService(endpoint);
        return (T)result;
    }

    public Object callService(String endpoint) throws Exception {
        String query = this.getQueryString();
        URL url = new URL("https", endpoint, -1, "/" + query);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoOutput(true);
        httpConnection.connect();
        Object response = CloudyUtility.unmarshalTheResponse(httpConnection.getInputStream(), this.awsConfig);
        return response;
    }
}

