/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rtcp;

import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.BasicRTCPTerminationStrategy;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.rtcp.BridgeRTCPTerminationStrategy;
import org.jitsi.videobridge.rtcp.BridgeReceiverReporting;
import org.jitsi.videobridge.rtcp.BridgeSenderReporting;

public class BasicBridgeRTCPTerminationStrategy
extends BasicRTCPTerminationStrategy
implements BridgeRTCPTerminationStrategy {
    private Conference conference;
    private final BridgeSenderReporting bridgeSenderReporting = new BridgeSenderReporting(this);
    private final BridgeReceiverReporting bridgeReceiverReporting = new BridgeReceiverReporting(this);

    public void setConference(Conference conference) {
        this.conference = conference;
    }

    public Conference getConference() {
        return this.conference;
    }

    public RTCPCompoundPacket transformRTCPPacket(RTCPCompoundPacket inPacket) {
        for (RTCPPacket p : inPacket.packets) {
            if (p == null || p.type != 206) continue;
            RTCPFBPacket psfb = (RTCPFBPacket)p;
            if (psfb.fmt != 15) continue;
            this.receivedREMB((RTCPREMBPacket)psfb);
        }
        RTCPCompoundPacket outPacket = super.transformRTCPPacket(inPacket);
        if (outPacket.packets != null && outPacket.packets.length != 0 && outPacket.packets[0].type == 200) {
            if (this.bridgeSenderReporting.explodeSenderReport(outPacket)) {
                return null;
            }
            return outPacket;
        }
        return outPacket;
    }

    public RTCPPacket[] makeReports() {
        return this.bridgeReceiverReporting.makeReports();
    }

    private void receivedREMB(RTCPREMBPacket remb) {
        Channel channel;
        Conference conference = this.getConference();
        if (conference != null && (channel = conference.findChannelByReceiveSSRC(remb.senderSSRC, MediaType.VIDEO)) != null && channel instanceof VideoChannel) {
            ((VideoChannel)channel).receivedREMB(remb.getBitrate());
        }
    }
}

