/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.metrics;

import java.util.LinkedList;
import java.util.List;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.eventadmin.Event;
import org.jitsi.videobridge.eventadmin.EventHandler;
import org.jitsi.videobridge.metrics.MetricServicePublisher;

public class MetricLoggingHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(MetricLoggingHandler.class);
    private List<MetricServicePublisher> publishers = new LinkedList<MetricServicePublisher>();
    public static final String METRIC_CONFERENCES = "Conferences";
    public static final String METRIC_CHANNELS = "Channels";
    public static final String METRIC_CONFERENCELENGTH = "Conference length";
    public static final String METRIC_CHANNELSTART_POSTFIX = " start";

    public MetricLoggingHandler(ConfigurationService config) {
        List propNames = config.getPropertyNamesByPrefix("org.jitsi.videobridge.metricservice.", false);
        logger.info((Object)("Metric services enabled: " + (propNames == null ? "0" : Integer.valueOf(propNames.size()))));
        if (propNames != null) {
            for (String propName : propNames) {
                logger.info((Object)("Initialising metric service: " + propName));
                try {
                    String serviceClassName = config.getString(propName);
                    Class<?> serviceClass = Class.forName(serviceClassName);
                    MetricServicePublisher publisher = (MetricServicePublisher)serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.publishers.add(publisher);
                }
                catch (Throwable t) {
                    logger.error((Object)"Error initialising metric service", t);
                }
            }
        }
    }

    private void publishNumericMetric(String metricName, int metricValue) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.publishNumericMetric(metricName, metricValue);
            }
            catch (UnsupportedOperationException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(publisher.getName() + " publisher doesn't support numeric metric: " + metricName));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + metricName + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    private void publishStringMetric(String metricName, String metricValue) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.publishStringMetric(metricName, metricValue);
            }
            catch (UnsupportedOperationException e) {
                logger.debug((Object)(publisher.getName() + " publisher doesn't support string metric: " + metricName));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + metricName + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    private void publishIncrementalMetric(String metricName) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.publishIncrementalMetric(metricName);
            }
            catch (UnsupportedOperationException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(publisher.getName() + " publisher doesn't support incremental metric: " + metricName));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + metricName + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    private void publishIncrementalMetric(String metricName, int increment) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.publishIncrementalMetric(metricName, increment);
            }
            catch (UnsupportedOperationException e) {
                logger.debug((Object)(publisher.getName() + " publisher doesn't support incremental metric: " + metricName));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + metricName + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    private void startMeasuredTransaction(String transactionType, String transactionId) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.startMeasuredTransaction(transactionType, transactionId);
            }
            catch (UnsupportedOperationException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(publisher.getName() + " publisher doesn't support measured transaction " + "metric: " + transactionType));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + transactionType + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    private void endMeasuredTransaction(String transactionType, String transactionId) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.endMeasuredTransaction(transactionType, transactionId);
            }
            catch (UnsupportedOperationException e) {
                logger.debug((Object)(publisher.getName() + " publisher doesn't support measured transaction metric: " + transactionType));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + transactionType + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    public void handleEvent(Event event) {
        if (event == null) {
            logger.debug((Object)"Could not handle the event because it was null.");
            return;
        }
        if ("org/jitsi/videobridge/Channel/CREATED".equals(event.getTopic()) || "org/jitsi/videobridge/Channel/EXPIRED".equals(event.getTopic())) {
            Channel channel = (Channel)((Object)event.getProperty("event.source"));
            if (channel == null) {
                logger.debug((Object)"Could not log channel expired event because the channel is null.");
                return;
            }
            Content content = channel.getContent();
            if (content == null) {
                logger.debug((Object)"Could not log channel expired event because the content is null.");
                return;
            }
            Conference conference = content.getConference();
            if (conference == null) {
                logger.debug((Object)"Could not log channel expired event because the conference is null.");
                return;
            }
            Videobridge videobridge = conference.getVideobridge();
            if (videobridge == null) {
                logger.debug((Object)"Could not log channel expired event because the videobridge is null.");
                return;
            }
            this.publishNumericMetric(METRIC_CHANNELS, videobridge.getChannelCount());
        } else if ("org/jitsi/videobridge/Conference/CREATED".equals(event.getTopic())) {
            Conference conference = (Conference)event.getProperty("event.source");
            Videobridge videobridge = conference.getVideobridge();
            if (videobridge == null) {
                logger.debug((Object)"Could not log conference expired event because the videobridge is null.");
                return;
            }
            this.publishNumericMetric(METRIC_CONFERENCES, videobridge.getConferenceCount());
            this.startMeasuredTransaction(METRIC_CONFERENCELENGTH, conference.getID());
        } else if ("org/jitsi/videobridge/Conference/EXPIRED".equals(event.getTopic())) {
            Conference conference = (Conference)event.getProperty("event.source");
            Videobridge videobridge = conference.getVideobridge();
            if (videobridge == null) {
                logger.debug((Object)"Could not log conference expired event because the videobridge is null.");
                return;
            }
            this.publishNumericMetric(METRIC_CONFERENCES, videobridge.getConferenceCount());
            this.endMeasuredTransaction(METRIC_CONFERENCELENGTH, conference.getID());
        } else if ("org/jitsi/videobridge/Endpoint/STREAM_STARTED".equals(event.getTopic())) {
            RtpChannel rtpChannel = (RtpChannel)event.getProperty("event.source");
            this.publishStringMetric(rtpChannel.getClass().getName() + METRIC_CHANNELSTART_POSTFIX, rtpChannel.getStreamTarget().getDataAddress().getHostAddress());
        }
    }
}

