/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.reconnectplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.netaddr.event.ChangeEvent;
import net.java.sip.communicator.service.netaddr.event.NetworkConfigurationChangeListener;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ReconnectPluginActivator
implements BundleActivator,
ServiceListener,
NetworkConfigurationChangeListener,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(ReconnectPluginActivator.class);
    private static BundleContext bundleContext = null;
    private static UIService uiService;
    private static ResourceManagementService resourcesService;
    private static ConfigurationService configurationService;
    private static NotificationService notificationService;
    private NetworkAddressManagerService networkAddressManagerService = null;
    private final Map<ProtocolProviderService, List<String>> autoReconnEnabledProviders = new HashMap<ProtocolProviderService, List<String>>();
    private final Map<ProtocolProviderService, ReconnectTask> currentlyReconnecting = new HashMap<ProtocolProviderService, ReconnectTask>();
    private Set<ProtocolProviderService> needsReconnection = new HashSet<ProtocolProviderService>();
    private Set<ProtocolProviderService> unregisteringProviders = new HashSet<ProtocolProviderService>();
    private Set<String> connectedInterfaces = new HashSet<String>();
    private Timer timer = null;
    private static final int RECONNECT_DELAY_MIN = 2;
    private static final int RECONNECT_DELAY_MAX = 4;
    private static final int MAX_RECONNECT_DELAY = 300;
    public static final String NETWORK_NOTIFICATIONS = "NetworkNotifications";
    public static final String ATLEAST_ONE_CONNECTION_PROP = "net.java.sip.communicator.plugin.reconnectplugin.ATLEAST_ONE_SUCCESSFUL_CONNECTION";
    private Timer delayedNetworkDown;
    private static final long NETWORK_DOWN_THRESHOLD = 30000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        try {
            logger.logEntry();
            ReconnectPluginActivator.bundleContext = bundleContext;
        }
        finally {
            logger.logExit();
        }
        bundleContext.addServiceListener((ServiceListener)this);
        if (this.timer == null) {
            this.timer = new Timer("Reconnect timer", true);
        }
        this.networkAddressManagerService = (NetworkAddressManagerService)ServiceUtils.getService((BundleContext)bundleContext, NetworkAddressManagerService.class);
        this.networkAddressManagerService.addNetworkConfigurationChangeListener((NetworkConfigurationChangeListener)this);
        ServiceReference[] protocolProviderRefs = null;
        try {
            protocolProviderRefs = bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (protocolProviderRefs != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + protocolProviderRefs.length + " already installed providers."));
            }
            for (int i = 0; i < protocolProviderRefs.length; ++i) {
                ProtocolProviderService provider = (ProtocolProviderService)bundleContext.getService(protocolProviderRefs[i]);
                this.handleProviderAdded(provider);
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public static UIService getUIService() {
        if (uiService == null) {
            ServiceReference uiReference = bundleContext.getServiceReference(UIService.class.getName());
            uiService = (UIService)bundleContext.getService(uiReference);
        }
        return uiService;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(ResourceManagementService.class.getName());
            if (serviceReference == null) {
                return null;
            }
            resourcesService = (ResourceManagementService)bundleContext.getService(serviceReference);
        }
        return resourcesService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configurationService = (ConfigurationService)bundleContext.getService(confReference);
        }
        return configurationService;
    }

    public static NotificationService getNotificationService() {
        if (notificationService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(NotificationService.class.getName());
            notificationService = (NotificationService)bundleContext.getService(serviceReference);
            notificationService.registerDefaultNotificationForEvent(NETWORK_NOTIFICATIONS, "PopupMessageAction", null, null);
        }
        return notificationService;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        ServiceReference serviceRef = serviceEvent.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object sService = bundleContext.getService(serviceRef);
        if (sService instanceof NetworkAddressManagerService) {
            switch (serviceEvent.getType()) {
                case 1: {
                    if (this.networkAddressManagerService != null) break;
                    this.networkAddressManagerService = (NetworkAddressManagerService)sService;
                    this.networkAddressManagerService.addNetworkConfigurationChangeListener((NetworkConfigurationChangeListener)this);
                    break;
                }
                case 4: {
                    ((NetworkAddressManagerService)sService).removeNetworkConfigurationChangeListener((NetworkConfigurationChangeListener)this);
                }
            }
            return;
        }
        if (!(sService instanceof ProtocolProviderService)) {
            return;
        }
        switch (serviceEvent.getType()) {
            case 1: {
                this.handleProviderAdded((ProtocolProviderService)sService);
                break;
            }
            case 4: {
                this.handleProviderRemoved((ProtocolProviderService)sService);
            }
        }
    }

    private void handleProviderAdded(ProtocolProviderService provider) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("New protocol provider is comming " + provider.getProtocolName()));
        }
        provider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Provider modified forget every instance of it");
        }
        if (this.hasAtLeastOneSuccessfulConnection(provider)) {
            this.setAtLeastOneSuccessfulConnection(provider, false);
        }
        provider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        this.autoReconnEnabledProviders.remove(provider);
        this.needsReconnection.remove(provider);
        if (this.currentlyReconnecting.containsKey(provider)) {
            this.currentlyReconnecting.remove(provider).cancel();
        }
    }

    public synchronized void configurationChanged(ChangeEvent event) {
        if (event.getType() == 1) {
            if (this.connectedInterfaces.isEmpty()) {
                this.onNetworkUp();
                for (ProtocolProviderService pp : this.needsReconnection) {
                    if (this.currentlyReconnecting.containsKey(pp)) {
                        this.currentlyReconnecting.remove(pp).cancel();
                    }
                    this.reconnect(pp);
                }
                this.needsReconnection.clear();
            }
            this.connectedInterfaces.add((String)event.getSource());
        } else if (event.getType() == 0) {
            String ifaceName = (String)event.getSource();
            this.connectedInterfaces.remove(ifaceName);
            if (this.connectedInterfaces.size() > 0) {
                for (Map.Entry<ProtocolProviderService, List<String>> entry : this.autoReconnEnabledProviders.entrySet()) {
                    if (!entry.getValue().contains(ifaceName)) continue;
                    ProtocolProviderService pp = entry.getKey();
                    if (this.currentlyReconnecting.containsKey(pp)) {
                        this.currentlyReconnecting.remove(pp).cancel();
                    }
                    this.reconnect(pp);
                }
            } else {
                this.needsReconnection.addAll(this.autoReconnEnabledProviders.keySet());
                this.needsReconnection.addAll(this.currentlyReconnecting.keySet());
                for (ProtocolProviderService pp : this.needsReconnection) {
                    if (this.currentlyReconnecting.containsKey(pp)) {
                        this.currentlyReconnecting.remove(pp).cancel();
                    }
                    this.unregister(pp, false, null, null);
                }
                this.connectedInterfaces.clear();
                this.onNetworkDown();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Event received " + event + " src=" + event.getSource()));
            this.traceCurrentPPState();
        }
    }

    private void unregister(final ProtocolProviderService pp, final boolean reconnect, final RegistrationStateChangeListener listener, final ReconnectTask task) {
        this.unregisteringProviders.add(pp);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (pp.getRegistrationState().equals((Object)RegistrationState.UNREGISTERING) || pp.getRegistrationState().equals((Object)RegistrationState.UNREGISTERED) || pp.getRegistrationState().equals((Object)RegistrationState.CONNECTION_FAILED)) {
                        if (reconnect) {
                            if (listener != null) {
                                pp.removeRegistrationStateChangeListener(listener);
                            }
                            if (ReconnectPluginActivator.this.timer == null || task == null) {
                                return;
                            }
                            if (ReconnectPluginActivator.this.currentlyReconnecting.containsKey(pp)) {
                                ((ReconnectTask)ReconnectPluginActivator.this.currentlyReconnecting.remove(pp)).cancel();
                            }
                            ReconnectPluginActivator.this.currentlyReconnecting.put(pp, task);
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Reconnect " + pp.getAccountID().getDisplayName() + " after " + task.delay + " ms."));
                            }
                            ReconnectPluginActivator.this.timer.schedule((TimerTask)task, task.delay);
                        }
                        return;
                    }
                    pp.unregister();
                }
                catch (Throwable t) {
                    logger.error((Object)("Error unregistering pp:" + pp), t);
                }
            }
        }).start();
    }

    private void traceCurrentPPState() {
        logger.trace((Object)("connectedInterfaces: " + this.connectedInterfaces));
        logger.trace((Object)("autoReconnEnabledProviders: " + this.autoReconnEnabledProviders.keySet()));
        logger.trace((Object)("currentlyReconnecting: " + this.currentlyReconnecting.keySet()));
        logger.trace((Object)("needsReconnection: " + this.needsReconnection));
        logger.trace((Object)("unregisteringProviders: " + this.unregisteringProviders));
        logger.trace((Object)"----");
    }

    private void notify(String title, String i18nKey, String[] params, Object tag) {
        HashMap<String, Object> extras = new HashMap<String, Object>();
        extras.put("PopupMessageNotificationHandler.tag", tag);
        ReconnectPluginActivator.getNotificationService().fireNotification(NETWORK_NOTIFICATIONS, title, ReconnectPluginActivator.getResources().getI18NString(i18nKey, params), null, extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (!(evt.getSource() instanceof ProtocolProviderService) || !evt.getNewState().equals((Object)RegistrationState.REGISTERED) && !evt.getNewState().equals((Object)RegistrationState.UNREGISTERED) && !evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED)) {
            return;
        }
        ReconnectPluginActivator reconnectPluginActivator = this;
        synchronized (reconnectPluginActivator) {
            try {
                boolean isServerReturnedErroneousInputEvent;
                ProtocolProviderService pp = (ProtocolProviderService)evt.getSource();
                boolean bl = isServerReturnedErroneousInputEvent = evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) && evt.getReasonCode() == 10;
                if (evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED) && !isServerReturnedErroneousInputEvent) {
                    if (!this.hasAtLeastOneSuccessfulConnection(pp)) {
                        if (evt.getReasonCode() == 3) {
                            this.notify(ReconnectPluginActivator.getResources().getI18NString("service.gui.ERROR"), "service.gui.NON_EXISTING_USER_ID", new String[]{pp.getAccountID().getService()}, pp.getAccountID());
                        } else {
                            this.notify(ReconnectPluginActivator.getResources().getI18NString("service.gui.ERROR"), "plugin.reconnectplugin.CONNECTION_FAILED_MSG", new String[]{pp.getAccountID().getUserID(), pp.getAccountID().getService()}, pp.getAccountID());
                        }
                        return;
                    }
                    if (this.needsReconnection.contains(pp)) {
                        return;
                    }
                    if (this.connectedInterfaces.isEmpty()) {
                        this.needsReconnection.add(pp);
                        if (this.currentlyReconnecting.containsKey(pp)) {
                            this.currentlyReconnecting.remove(pp).cancel();
                        }
                    } else {
                        this.reconnect(pp);
                    }
                    this.unregisteringProviders.remove(pp);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Got Connection Failed for " + pp));
                        this.traceCurrentPPState();
                    }
                } else if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
                    if (!this.hasAtLeastOneSuccessfulConnection(pp)) {
                        this.setAtLeastOneSuccessfulConnection(pp, true);
                    }
                    this.autoReconnEnabledProviders.put(pp, new ArrayList<String>(this.connectedInterfaces));
                    if (this.currentlyReconnecting.containsKey(pp)) {
                        this.currentlyReconnecting.remove(pp).cancel();
                    }
                    this.unregisteringProviders.remove(pp);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Got Registered for " + pp));
                        this.traceCurrentPPState();
                    }
                } else if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERED) || isServerReturnedErroneousInputEvent) {
                    if (evt.isUserRequest() || isServerReturnedErroneousInputEvent) {
                        this.autoReconnEnabledProviders.remove(pp);
                    }
                    if (!this.unregisteringProviders.contains(pp) && this.currentlyReconnecting.containsKey(pp)) {
                        this.currentlyReconnecting.remove(pp).cancel();
                    }
                    this.unregisteringProviders.remove(pp);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Got Unregistered for " + pp));
                        if (!this.currentlyReconnecting.containsKey(pp) && !this.needsReconnection.contains(pp) && logger.isTraceEnabled()) {
                            logger.trace((Object)("Provider is unregistered and will not be reconnected (maybe on user request): " + pp + " / reason:" + evt.getReason() + " / reasonCode:" + evt.getReasonCode() + " / oldState:" + evt.getOldState()), (Throwable)new Exception("Trace exception."));
                        }
                        this.traceCurrentPPState();
                    }
                }
            }
            catch (Throwable ex) {
                logger.error((Object)"Error dispatching protocol registration change", ex);
            }
        }
    }

    private void reconnect(final ProtocolProviderService pp) {
        long delay;
        if (this.currentlyReconnecting.containsKey(pp)) {
            delay = this.currentlyReconnecting.get(pp).delay;
            delay = Math.min(delay * 2L, 300000L);
        } else {
            delay = (long)(2.0 + Math.random() * 4.0) * 1000L;
        }
        final ReconnectTask task = new ReconnectTask(pp);
        task.delay = delay;
        RegistrationStateChangeListener listener = new RegistrationStateChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void registrationStateChanged(RegistrationStateChangeEvent evt) {
                if (evt.getSource() instanceof ProtocolProviderService && (evt.getNewState().equals((Object)RegistrationState.UNREGISTERED) || evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED))) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        pp.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
                        if (ReconnectPluginActivator.this.timer == null) {
                            return;
                        }
                        if (ReconnectPluginActivator.this.connectedInterfaces.size() == 0) {
                            ReconnectPluginActivator.this.needsReconnection.add(pp);
                            if (ReconnectPluginActivator.this.currentlyReconnecting.containsKey(pp)) {
                                ((ReconnectTask)ReconnectPluginActivator.this.currentlyReconnecting.remove(pp)).cancel();
                            }
                            return;
                        }
                        if (ReconnectPluginActivator.this.currentlyReconnecting.containsKey(pp)) {
                            ((ReconnectTask)ReconnectPluginActivator.this.currentlyReconnecting.remove(pp)).cancel();
                        }
                        ReconnectPluginActivator.this.currentlyReconnecting.put(pp, task);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Reconnect " + pp.getAccountID().getDisplayName() + " after " + task.delay + " ms."));
                        }
                        ReconnectPluginActivator.this.timer.schedule((TimerTask)task, task.delay);
                    }
                }
            }
        };
        pp.addRegistrationStateChangeListener(listener);
        this.unregister(pp, true, listener, task);
    }

    private boolean hasAtLeastOneSuccessfulConnection(ProtocolProviderService pp) {
        String value = (String)ReconnectPluginActivator.getConfigurationService().getProperty("net.java.sip.communicator.plugin.reconnectplugin.ATLEAST_ONE_SUCCESSFUL_CONNECTION." + pp.getAccountID().getAccountUniqueID());
        return value != null && value.equals(Boolean.TRUE.toString());
    }

    private void setAtLeastOneSuccessfulConnection(ProtocolProviderService pp, boolean value) {
        ReconnectPluginActivator.getConfigurationService().setProperty("net.java.sip.communicator.plugin.reconnectplugin.ATLEAST_ONE_SUCCESSFUL_CONNECTION." + pp.getAccountID().getAccountUniqueID(), (Object)Boolean.valueOf(value).toString());
    }

    private void onNetworkUp() {
        if (this.delayedNetworkDown != null) {
            this.delayedNetworkDown.cancel();
            this.delayedNetworkDown = null;
        }
    }

    private void onNetworkDown() {
        if (!OSUtils.IS_ANDROID) {
            this.notifyNetworkDown();
        } else if (this.delayedNetworkDown == null) {
            this.delayedNetworkDown = new Timer();
            this.delayedNetworkDown.schedule(new TimerTask(){

                @Override
                public void run() {
                    ReconnectPluginActivator.this.notifyNetworkDown();
                }
            }, 30000L);
        }
    }

    private void notifyNetworkDown() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Network is down!");
        }
        this.notify("", "plugin.reconnectplugin.NETWORK_DOWN", new String[0], this);
    }

    static {
        configurationService = null;
    }

    private class ReconnectTask
    extends TimerTask {
        private ProtocolProviderService provider;
        private long delay;
        private Thread thread = null;

        public ReconnectTask(ProtocolProviderService provider) {
            this.provider = provider;
        }

        @Override
        public void run() {
            if (this.thread == null || !Thread.currentThread().equals(this.thread)) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Start reconnecting " + this.provider.getAccountID().getDisplayName()));
                    }
                    this.provider.register(ReconnectPluginActivator.getUIService().getDefaultSecurityAuthority(this.provider));
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)"cannot re-register provider will keep going", (Throwable)ex);
                }
            }
        }
    }
}

