/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RecurringProcessible;
import org.jitsi.util.Logger;

public class RecurringProcessibleExecutor
implements Executor {
    private static final Logger logger = Logger.getLogger(RecurringProcessibleExecutor.class);
    private final List<RecurringProcessible> recurringProcessibles = new LinkedList<RecurringProcessible>();
    private Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deRegisterRecurringProcessible(RecurringProcessible recurringProcessible) {
        if (recurringProcessible == null) {
            return false;
        }
        List<RecurringProcessible> list = this.recurringProcessibles;
        synchronized (list) {
            boolean removed = this.recurringProcessibles.remove(recurringProcessible);
            if (removed) {
                this.startOrNotifyThread();
            }
            return removed;
        }
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (!(command instanceof RecurringProcessible)) {
            throw new RejectedExecutionException("The class " + command.getClass().getName() + " of command does not implement " + RecurringProcessible.class.getName());
        }
        this.registerRecurringProcessible((RecurringProcessible)((Object)command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process() {
        long timeToNext;
        long minTimeToNext = 100L;
        List<RecurringProcessible> list = this.recurringProcessibles;
        synchronized (list) {
            if (!Thread.currentThread().equals(this.thread) || this.recurringProcessibles.isEmpty()) {
                return false;
            }
            for (RecurringProcessible recurringProcessible : this.recurringProcessibles) {
                timeToNext = recurringProcessible.getTimeUntilNextProcess();
                if (minTimeToNext <= timeToNext) continue;
                minTimeToNext = timeToNext;
            }
        }
        if (minTimeToNext > 0L) {
            list = this.recurringProcessibles;
            synchronized (list) {
                if (!Thread.currentThread().equals(this.thread) || this.recurringProcessibles.isEmpty()) {
                    return false;
                }
                try {
                    this.recurringProcessibles.wait(minTimeToNext);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        }
        list = this.recurringProcessibles;
        synchronized (list) {
            for (RecurringProcessible recurringProcessible : this.recurringProcessibles) {
                timeToNext = recurringProcessible.getTimeUntilNextProcess();
                if (timeToNext >= 1L) continue;
                try {
                    recurringProcessible.process();
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.error("The invocation of the method " + recurringProcessible.getClass().getName() + ".process() threw an exception.", t);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerRecurringProcessible(RecurringProcessible recurringProcessible) {
        if (recurringProcessible == null) {
            throw new NullPointerException("recurringProcessible");
        }
        List<RecurringProcessible> list = this.recurringProcessibles;
        synchronized (list) {
            if (this.recurringProcessibles.contains(recurringProcessible)) {
                return false;
            }
            this.recurringProcessibles.add(0, recurringProcessible);
            this.startOrNotifyThread();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInThread() {
        try {
            while (this.process()) {
            }
        }
        finally {
            List<RecurringProcessible> list = this.recurringProcessibles;
            synchronized (list) {
                if (Thread.currentThread().equals(this.thread)) {
                    this.thread = null;
                    this.startOrNotifyThread();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startOrNotifyThread() {
        List<RecurringProcessible> list = this.recurringProcessibles;
        synchronized (list) {
            if (this.thread == null) {
                if (!this.recurringProcessibles.isEmpty()) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            RecurringProcessibleExecutor.this.runInThread();
                        }
                    };
                    thread.setDaemon(true);
                    thread.setName(RecurringProcessibleExecutor.class.getName() + ".thread");
                    boolean started = false;
                    this.thread = thread;
                    try {
                        thread.start();
                        started = true;
                    }
                    finally {
                        if (!started && thread.equals(this.thread)) {
                            this.thread = null;
                        }
                    }
                }
            } else {
                this.recurringProcessibles.notifyAll();
            }
        }
    }
}

