/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack.util;

import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEngine {
    private static TaskEngine instance = new TaskEngine();
    private Timer timer;
    private ExecutorService executor;
    private Map<TimerTask, TimerTaskWrapper> wrappedTasks = new ConcurrentHashMap<TimerTask, TimerTaskWrapper>();

    public static TaskEngine getInstance() {
        return instance;
    }

    private TaskEngine() {
        this.timer = new Timer("timer-whack", true);
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "pool-whack" + this.threadNumber.getAndIncrement(), 0L);
                thread.setDaemon(true);
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                return thread;
            }
        });
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public void schedule(TimerTask task, long delay) {
        this.timer.schedule((TimerTask)new TimerTaskWrapper(task), delay);
    }

    public void schedule(TimerTask task, Date time) {
        this.timer.schedule((TimerTask)new TimerTaskWrapper(task), time);
    }

    public void schedule(TimerTask task, long delay, long period) {
        TimerTaskWrapper taskWrapper = new TimerTaskWrapper(task);
        this.wrappedTasks.put(task, taskWrapper);
        this.timer.schedule((TimerTask)taskWrapper, delay, period);
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        TimerTaskWrapper taskWrapper = new TimerTaskWrapper(task);
        this.wrappedTasks.put(task, taskWrapper);
        this.timer.schedule((TimerTask)taskWrapper, firstTime, period);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        TimerTaskWrapper taskWrapper = new TimerTaskWrapper(task);
        this.wrappedTasks.put(task, taskWrapper);
        this.timer.scheduleAtFixedRate((TimerTask)taskWrapper, delay, period);
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        TimerTaskWrapper taskWrapper = new TimerTaskWrapper(task);
        this.wrappedTasks.put(task, taskWrapper);
        this.timer.scheduleAtFixedRate((TimerTask)taskWrapper, firstTime, period);
    }

    public void cancelScheduledTask(TimerTask task) {
        TimerTaskWrapper taskWrapper = this.wrappedTasks.remove(task);
        if (taskWrapper != null) {
            taskWrapper.cancel();
        }
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private class TimerTaskWrapper
    extends TimerTask {
        private TimerTask task;

        public TimerTaskWrapper(TimerTask task) {
            this.task = task;
        }

        public void run() {
            TaskEngine.this.executor.submit(this.task);
        }
    }
}

