/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.util.ValidationUtil;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SerializationConfig {
    private int portableVersion;
    private Map<Integer, String> dataSerializableFactoryClasses;
    private Map<Integer, DataSerializableFactory> dataSerializableFactories;
    private Map<Integer, String> portableFactoryClasses;
    private Map<Integer, PortableFactory> portableFactories;
    private GlobalSerializerConfig globalSerializerConfig;
    private Collection<SerializerConfig> serializerConfigs;
    private boolean checkClassDefErrors = true;
    private boolean useNativeByteOrder;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean enableCompression;
    private boolean enableSharedObject = true;
    private boolean allowUnsafe;
    private Set<ClassDefinition> classDefinitions;

    public GlobalSerializerConfig getGlobalSerializerConfig() {
        return this.globalSerializerConfig;
    }

    public SerializationConfig setGlobalSerializerConfig(GlobalSerializerConfig globalSerializerConfig) {
        this.globalSerializerConfig = globalSerializerConfig;
        return this;
    }

    public Collection<SerializerConfig> getSerializerConfigs() {
        if (this.serializerConfigs == null) {
            this.serializerConfigs = new LinkedList<SerializerConfig>();
        }
        return this.serializerConfigs;
    }

    public SerializationConfig addSerializerConfig(SerializerConfig serializerConfig) {
        this.getSerializerConfigs().add(serializerConfig);
        return this;
    }

    public SerializationConfig setSerializerConfigs(Collection<SerializerConfig> serializerConfigs) {
        this.serializerConfigs = serializerConfigs;
        return this;
    }

    public int getPortableVersion() {
        return this.portableVersion;
    }

    public SerializationConfig setPortableVersion(int portableVersion) {
        if (portableVersion < 0) {
            throw new IllegalArgumentException("Portable version cannot be negative!");
        }
        this.portableVersion = portableVersion;
        return this;
    }

    public Map<Integer, String> getDataSerializableFactoryClasses() {
        if (this.dataSerializableFactoryClasses == null) {
            this.dataSerializableFactoryClasses = new HashMap<Integer, String>();
        }
        return this.dataSerializableFactoryClasses;
    }

    public SerializationConfig setDataSerializableFactoryClasses(Map<Integer, String> dataSerializableFactoryClasses) {
        this.dataSerializableFactoryClasses = dataSerializableFactoryClasses;
        return this;
    }

    public SerializationConfig addDataSerializableFactoryClass(int factoryId, String dataSerializableFactoryClass) {
        this.getDataSerializableFactoryClasses().put(factoryId, dataSerializableFactoryClass);
        return this;
    }

    public SerializationConfig addDataSerializableFactoryClass(int factoryId, Class<? extends DataSerializableFactory> dataSerializableFactoryClass) {
        String factoryClassName = ValidationUtil.isNotNull(dataSerializableFactoryClass, "dataSerializableFactoryClass").getName();
        return this.addDataSerializableFactoryClass(factoryId, factoryClassName);
    }

    public Map<Integer, DataSerializableFactory> getDataSerializableFactories() {
        if (this.dataSerializableFactories == null) {
            this.dataSerializableFactories = new HashMap<Integer, DataSerializableFactory>();
        }
        return this.dataSerializableFactories;
    }

    public SerializationConfig setDataSerializableFactories(Map<Integer, DataSerializableFactory> dataSerializableFactories) {
        this.dataSerializableFactories = dataSerializableFactories;
        return this;
    }

    public SerializationConfig addDataSerializableFactory(int factoryId, DataSerializableFactory dataSerializableFactory) {
        this.getDataSerializableFactories().put(factoryId, dataSerializableFactory);
        return this;
    }

    public Map<Integer, String> getPortableFactoryClasses() {
        if (this.portableFactoryClasses == null) {
            this.portableFactoryClasses = new HashMap<Integer, String>();
        }
        return this.portableFactoryClasses;
    }

    public SerializationConfig setPortableFactoryClasses(Map<Integer, String> portableFactoryClasses) {
        this.portableFactoryClasses = portableFactoryClasses;
        return this;
    }

    public SerializationConfig addPortableFactoryClass(int factoryId, Class<? extends PortableFactory> portableFactoryClass) {
        String portableFactoryClassName = ValidationUtil.isNotNull(portableFactoryClass, "portableFactoryClass").getName();
        return this.addPortableFactoryClass(factoryId, portableFactoryClassName);
    }

    public SerializationConfig addPortableFactoryClass(int factoryId, String portableFactoryClass) {
        this.getPortableFactoryClasses().put(factoryId, portableFactoryClass);
        return this;
    }

    public Map<Integer, PortableFactory> getPortableFactories() {
        if (this.portableFactories == null) {
            this.portableFactories = new HashMap<Integer, PortableFactory>();
        }
        return this.portableFactories;
    }

    public SerializationConfig setPortableFactories(Map<Integer, PortableFactory> portableFactories) {
        this.portableFactories = portableFactories;
        return this;
    }

    public SerializationConfig addPortableFactory(int factoryId, PortableFactory portableFactory) {
        this.getPortableFactories().put(factoryId, portableFactory);
        return this;
    }

    public Set<ClassDefinition> getClassDefinitions() {
        if (this.classDefinitions == null) {
            this.classDefinitions = new HashSet<ClassDefinition>();
        }
        return this.classDefinitions;
    }

    public SerializationConfig addClassDefinition(ClassDefinition classDefinition) {
        if (!this.getClassDefinitions().add(classDefinition)) {
            throw new IllegalArgumentException("ClassDefinition for class-id[" + classDefinition.getClassId() + "] already exists!");
        }
        return this;
    }

    public SerializationConfig setClassDefinitions(Set<ClassDefinition> classDefinitions) {
        this.classDefinitions = classDefinitions;
        return this;
    }

    public boolean isCheckClassDefErrors() {
        return this.checkClassDefErrors;
    }

    public SerializationConfig setCheckClassDefErrors(boolean checkClassDefErrors) {
        this.checkClassDefErrors = checkClassDefErrors;
        return this;
    }

    public boolean isUseNativeByteOrder() {
        return this.useNativeByteOrder;
    }

    public SerializationConfig setUseNativeByteOrder(boolean useNativeByteOrder) {
        this.useNativeByteOrder = useNativeByteOrder;
        return this;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public SerializationConfig setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        return this;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public SerializationConfig setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
        return this;
    }

    public boolean isEnableSharedObject() {
        return this.enableSharedObject;
    }

    public SerializationConfig setEnableSharedObject(boolean enableSharedObject) {
        this.enableSharedObject = enableSharedObject;
        return this;
    }

    public boolean isAllowUnsafe() {
        return this.allowUnsafe;
    }

    public SerializationConfig setAllowUnsafe(boolean allowUnsafe) {
        this.allowUnsafe = allowUnsafe;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SerializationConfig{");
        sb.append("portableVersion=").append(this.portableVersion);
        sb.append(", dataSerializableFactoryClasses=").append(this.dataSerializableFactoryClasses);
        sb.append(", dataSerializableFactories=").append(this.dataSerializableFactories);
        sb.append(", portableFactoryClasses=").append(this.portableFactoryClasses);
        sb.append(", portableFactories=").append(this.portableFactories);
        sb.append(", globalSerializerConfig=").append(this.globalSerializerConfig);
        sb.append(", serializerConfigs=").append(this.serializerConfigs);
        sb.append(", checkClassDefErrors=").append(this.checkClassDefErrors);
        sb.append(", classDefinitions=").append(this.classDefinitions);
        sb.append(", byteOrder=").append(this.byteOrder);
        sb.append(", useNativeByteOrder=").append(this.useNativeByteOrder);
        sb.append('}');
        return sb.toString();
    }
}

