/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

public final class DefensiveTools {
    private DefensiveTools() {
    }

    public static final void checkRange(int val, String name, int min) throws IllegalArgumentException {
        if (val < min) {
            throw new IllegalArgumentException(name + " (" + val + ") must " + "be >= " + min);
        }
    }

    public static final void checkRange(int val, String name, int min, int max) throws IllegalArgumentException {
        if (val < min || val > max) {
            throw new IllegalArgumentException(name + " (" + val + ") must " + "be >=" + min + " and <=" + max);
        }
    }

    public static void checkRange(long val, String name, int min) throws IllegalArgumentException {
        if (val < (long)min) {
            throw new IllegalArgumentException(name + " (" + val + ") must " + "be >= " + min);
        }
    }

    public static void checkRange(long val, String name, long min, long max) {
        if (val < min || val > max) {
            throw new IllegalArgumentException(name + " (" + val + ") must " + "be >=" + min + " and <=" + max);
        }
    }

    public static final void checkNull(Object val, String name) throws IllegalArgumentException {
        if (val == null) {
            throw new IllegalArgumentException("value of " + name + " cannot be null");
        }
    }

    public static void checkNullElements(Object[] array, String arrayName) throws IllegalArgumentException {
        DefensiveTools.checkNull(array, arrayName);
        DefensiveTools.checkNullElements(array, arrayName, 0, array.length);
    }

    public static void checkNullElements(Object[] array, String arrayName, int offset, int len) throws IllegalArgumentException {
        DefensiveTools.checkNull(array, arrayName);
        int end = offset + len;
        for (int i = offset; i < end; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException("'" + arrayName + "' array must not contain any null elements at " + "indices " + offset + " through " + (offset + len) + " (" + arrayName + "[" + i + "] == null)");
        }
    }

    public static Object[] getNonnullArray(Object[] array, String name) throws IllegalArgumentException {
        if (array == null) {
            return null;
        }
        array = (Object[])array.clone();
        DefensiveTools.checkNullElements(array, name);
        return array;
    }
}

