/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.net.ClientConn;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.OpenedServiceListener;
import net.kano.joustsim.oscar.ServiceRequestInfo;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.ExternalConnection;
import net.kano.joustsim.oscar.oscar.OscarConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.DefaultServiceArbiterFactory;
import net.kano.joustsim.oscar.oscar.service.MutableService;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.ServiceArbiterFactory;
import net.kano.joustsim.oscar.oscar.service.ServiceArbitrationManager;
import net.kano.joustsim.oscar.oscar.service.ServiceFactory;
import net.kano.joustsim.oscar.oscar.service.ServiceListener;
import net.kano.joustsim.oscar.oscar.service.bos.ExternalBosServiceImpl;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.bos.OpenedExternalServiceListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.RoomFinderServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.icon.IconServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.mailcheck.MailCheckServiceArbiter;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalServiceManager {
    private static final Logger LOGGER = Logger.getLogger(ExternalServiceManager.class.getName());
    private static final int DEFAULT_SERVICE_TIMEOUT = 10000;
    private Set<ServiceRequestInfo<? extends MutableService>> desiredServiceRequests = new HashSet<ServiceRequestInfo<? extends MutableService>>();
    private static final int SERVICE_REQUEST_INTERVAL = 15000;
    private final AimConnection aimConnection;
    private final Object externalServicesLock = new Object();
    private final Map<Integer, ServiceArbiter<? extends MutableService>> externalServices = new HashMap<Integer, ServiceArbiter<? extends MutableService>>();
    private final Map<ServiceArbiter<? extends MutableService>, OscarConnection> externalConnections = new HashMap<ServiceArbiter<? extends MutableService>, OscarConnection>();
    private final Map<Integer, ServiceRequestInfo<? extends MutableService>> pendingServiceRequests = new HashMap<Integer, ServiceRequestInfo<? extends MutableService>>();
    private Map<Integer, Long> serviceRequestTimes = new HashMap<Integer, Long>();
    private final ServiceArbitrationManager arbitrationManager = new ServiceArbitrationManager(){

        @Override
        public void openService(ServiceArbiter<? extends MutableService> arbiter) {
            int family = arbiter.getSnacFamily();
            if (ExternalServiceManager.this.getServiceArbiter(family) == arbiter) {
                ExternalServiceManager.this.requestService(family, arbiter);
            }
        }
    };
    private final Timer serviceTimer = this.createServiceTimer();
    private ServiceArbiterFactory arbiterFactory = new DefaultServiceArbiterFactory();
    private volatile int serviceConnectionTimeout = 10000;

    public static int fixPort(int port) {
        if (port > 0 && port <= 65535) {
            return port;
        }
        return 5190;
    }

    public ExternalServiceManager(AimConnection aimConnection) {
        this.aimConnection = aimConnection;
        aimConnection.addStateListener(new StateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleStateChange(StateEvent event) {
                State newState = event.getNewState();
                if (newState.isFinished()) {
                    ArrayList vals;
                    ExternalServiceManager.this.serviceTimer.cancel();
                    ExternalServiceManager externalServiceManager = ExternalServiceManager.this;
                    synchronized (externalServiceManager) {
                        vals = new ArrayList(ExternalServiceManager.this.externalConnections.values());
                    }
                    for (OscarConnection conn : vals) {
                        conn.disconnect();
                    }
                }
            }
        });
        aimConnection.addOpenedServiceListener(new OpenedServiceListener(){

            @Override
            public void openedServices(AimConnection conn, Collection<? extends Service> services) {
                MainBosService bos = conn.getBosService();
                if (bos == null) {
                    return;
                }
                bos.addServiceListener(new ServiceListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleServiceReady(Service service) {
                        ArrayList infos;
                        ExternalServiceManager externalServiceManager = ExternalServiceManager.this;
                        synchronized (externalServiceManager) {
                            infos = new ArrayList(ExternalServiceManager.this.pendingServiceRequests.values());
                        }
                        for (ServiceRequestInfo req : infos) {
                            ExternalServiceManager.this.makeServiceRequest(req);
                        }
                    }

                    public void handleServiceFinished(Service service) {
                    }
                });
            }

            @Override
            public void closedServices(AimConnection conn, Collection<? extends Service> services) {
            }
        });
    }

    public int getServiceConnectionTimeout() {
        return this.serviceConnectionTimeout;
    }

    public void setServiceConnectionTimeout(int serviceConnectionTimeout) {
        this.serviceConnectionTimeout = serviceConnectionTimeout;
    }

    private Timer createServiceTimer() {
        Timer serviceTimer = new Timer(true);
        serviceTimer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet retry = new HashSet();
                HashSet<ServiceRequestInfo> torequest = new HashSet<ServiceRequestInfo>();
                4 var3_3 = this;
                synchronized (var3_3) {
                    Iterator it;
                    long time = System.currentTimeMillis();
                    Set entries = ExternalServiceManager.this.pendingServiceRequests.entrySet();
                    boolean changed = true;
                    block3: while (changed) {
                        changed = false;
                        it = entries.iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            ServiceRequestInfo request = (ServiceRequestInfo)entry.getValue();
                            long diff = time - request.startTime;
                            if (diff <= (long)ExternalServiceManager.this.serviceConnectionTimeout) continue;
                            LOGGER.info("External service for arbiter " + request.arbiter + "(0x" + Integer.toHexString(request.family) + ") timed out after " + (double)diff / 1000.0 + "s; retrying");
                            retry.add(entry.getKey());
                            request.cancel();
                            it.remove();
                            changed = true;
                            continue block3;
                        }
                    }
                    it = ExternalServiceManager.this.desiredServiceRequests.iterator();
                    while (it.hasNext()) {
                        ServiceRequestInfo s = (ServiceRequestInfo)((Object)it.next());
                        if (System.currentTimeMillis() - s.startTime <= 15000L) continue;
                        it.remove();
                        torequest.add(s);
                    }
                }
                for (ServiceRequestInfo s : torequest) {
                    ExternalServiceManager.this.requestService(s.family, s.arbiter, true);
                }
                Iterator i$ = retry.iterator();
                while (i$.hasNext()) {
                    int service = (Integer)i$.next();
                    ExternalServiceManager.this.requestService(service, ExternalServiceManager.this.getMutableServiceArbiter(service));
                }
            }
        }, 5000L, 5000L);
        return serviceTimer;
    }

    @Nullable
    public ServiceArbiter<? extends Service> getServiceArbiter(int service) {
        return this.getMutableServiceArbiter(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceArbiter<? extends MutableService> getMutableServiceArbiter(int service) {
        ServiceArbiter<? extends MutableService> arbiter;
        Object object = this.externalServicesLock;
        synchronized (object) {
            arbiter = this.externalServices.get(service);
            if (arbiter != null) {
                return arbiter;
            }
            LOGGER.finer("Creating arbiter for service " + service);
            arbiter = this.arbiterFactory.getInstance(this.arbitrationManager, service);
            LOGGER.fine("Created arbiter for service " + service + ": " + arbiter);
            if (arbiter == null) {
                return null;
            }
            this.externalServices.put(service, arbiter);
        }
        this.requestService(service, arbiter);
        return arbiter;
    }

    public IconServiceArbiter getIconServiceArbiter() {
        return this.getArbiter(16, IconServiceArbiter.class);
    }

    public RoomFinderServiceArbiter getChatRoomFinderServiceArbiter() {
        return this.getArbiter(13, RoomFinderServiceArbiter.class);
    }

    public MailCheckServiceArbiter getMailCheckServiceArbiter() {
        return this.getArbiter(24, MailCheckServiceArbiter.class);
    }

    private <A> A getArbiter(int family, Class<A> arbiterClass) {
        ServiceArbiter<? extends Service> arbiter = this.getServiceArbiter(family);
        if (arbiterClass.isInstance(arbiter)) {
            return (A)JavaTools.cast(arbiterClass, arbiter);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshServiceIfNecessary(int family) {
        ServiceArbiter<? extends MutableService> arbiter;
        Object object = this.externalServicesLock;
        synchronized (object) {
            arbiter = this.externalServices.get(family);
        }
        if (arbiter == null) {
            LOGGER.warning("Someone requested refresh of 0x" + Integer.toHexString(family) + " but there's no arbiter");
            return;
        }
        if (!arbiter.shouldKeepAlive()) {
            LOGGER.log(Level.INFO, "Someone requested a refresh of 0x" + Integer.toHexString(family) + " but the arbiter " + arbiter + " keepalive = false");
            return;
        }
        this.requestService(family, arbiter);
    }

    private synchronized <S extends MutableService> void queueServiceRequest(int family, ServiceArbiter<S> arbiter) {
        this.desiredServiceRequests.add(new ServiceRequestInfo<S>(family, arbiter));
    }

    private synchronized boolean requestedRecently(int family) {
        Long num = this.serviceRequestTimes.get(family);
        return num == null || System.currentTimeMillis() - num < 15000L;
    }

    private <S extends MutableService> void requestService(int family, ServiceArbiter<S> arbiter) {
        this.requestService(family, arbiter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S extends MutableService> void requestService(int family, ServiceArbiter<S> arbiter, boolean definitely) {
        ServiceRequestInfo<S> request;
        ExternalServiceManager externalServiceManager = this;
        synchronized (externalServiceManager) {
            if (this.pendingServiceRequests.containsKey(family)) {
                return;
            }
            if (this.externalConnections.containsKey(arbiter)) {
                LOGGER.finer("Someone requested 0x" + Integer.toHexString(family) + " but there's already an external connection: " + this.externalConnections.get(arbiter));
                return;
            }
            if (!definitely && this.requestedRecently(family)) {
                this.queueServiceRequest(family, arbiter);
                return;
            }
            request = new ServiceRequestInfo<S>(family, arbiter);
            this.pendingServiceRequests.put(family, request);
            this.serviceRequestTimes.put(family, System.currentTimeMillis());
        }
        this.makeServiceRequest(request);
    }

    private <S extends MutableService> void makeServiceRequest(ServiceRequestInfo<S> request) {
        int family = request.family;
        LOGGER.fine("Requesting external service " + family + " for " + request.arbiter);
        MainBosService bosService = this.aimConnection.getBosService();
        if (bosService == null) {
            return;
        }
        bosService.requestService(family, new ArbitratedExternalServiceListener<S>(request));
    }

    private synchronized <S extends MutableService> boolean clearRequest(ServiceRequestInfo<S> request) {
        boolean removed = this.pendingServiceRequests.values().remove(request);
        if (removed) {
            LOGGER.fine("External connection request " + request + " cleared");
        } else {
            LOGGER.fine("External connection request " + request + " was not cleared " + "because it is obsolete");
        }
        return removed;
    }

    private synchronized void clearExternalConnection(OscarConnection conn, ServiceArbiter<? extends MutableService> arbiter) {
        if (this.getExternalConnection(arbiter) == conn) {
            this.externalConnections.remove(arbiter);
        }
    }

    private synchronized OscarConnection getExternalConnection(ServiceArbiter<? extends MutableService> arbiter) {
        return this.externalConnections.get(arbiter);
    }

    private synchronized boolean storeExternalConnection(BasicConnection conn, ServiceRequestInfo<? extends MutableService> request) {
        this.externalConnections.put(request.arbiter, conn);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArbitratedExternalServiceListener<S extends MutableService>
    implements OpenedExternalServiceListener {
        private final ServiceRequestInfo<S> request;

        public ArbitratedExternalServiceListener(ServiceRequestInfo<S> request) {
            this.request = request;
        }

        @Override
        public void handleServiceRedirect(MainBosService service, int serviceFamily, String host, int port, ByteBlock flapCookie) {
            LOGGER.fine("Connecting to " + host + ":" + port + " for external " + "service " + serviceFamily);
            ExternalConnection conn = new ExternalConnection(host, ExternalServiceManager.fixPort(port), serviceFamily);
            conn.getClientFlapConn().setSocketFactory(ExternalServiceManager.this.aimConnection.getProxy().getSocketFactory());
            conn.setCookie(flapCookie);
            conn.setServiceFactory(new ExternalServiceFactory(serviceFamily, this.request.arbiter));
            conn.addOscarListener(new ExternalServiceConnListener<S>(serviceFamily, this.request));
            boolean isnew = ExternalServiceManager.this.storeExternalConnection(conn, this.request);
            if (isnew) {
                conn.connect();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalServiceConnListener<S extends MutableService>
    implements OscarConnListener {
        private final int serviceFamily;
        private final ServiceRequestInfo<S> request;

        public ExternalServiceConnListener(int serviceFamily, ServiceRequestInfo<S> arbiter) {
            this.request = arbiter;
            this.serviceFamily = serviceFamily;
        }

        @Override
        public void registeredSnacFamilies(OscarConnection conn) {
        }

        @Override
        public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
            ClientConn.State state = event.getClientConnEvent().getNewState();
            if (state == ClientConn.STATE_FAILED || state == ClientConn.STATE_NOT_CONNECTED) {
                LOGGER.info("External service connection died for service " + this.serviceFamily + " ( " + this.request + ")");
                conn.removeOscarListener(this);
                ExternalServiceManager.this.clearExternalConnection(conn, this.request.arbiter);
                ExternalServiceManager.this.refreshServiceIfNecessary(this.serviceFamily);
            }
        }

        @Override
        public void allFamiliesReady(OscarConnection conn) {
            LOGGER.fine("External service connection for " + this.request.arbiter + " is connected and ready");
            ExternalServiceManager.this.clearRequest(this.request);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExternalServiceFactory<S extends MutableService>
    implements ServiceFactory {
        private final int serviceFamily;
        private final ServiceArbiter<S> arbiter;

        public ExternalServiceFactory(int serviceFamily, ServiceArbiter<S> arbiter) {
            this.serviceFamily = serviceFamily;
            this.arbiter = arbiter;
        }

        @Override
        public MutableService getService(OscarConnection conn, int family) {
            if (family == 1) {
                return new ExternalBosServiceImpl(ExternalServiceManager.this.aimConnection, conn);
            }
            if (family == this.serviceFamily) {
                return this.arbiter.createService(ExternalServiceManager.this.aimConnection, conn);
            }
            LOGGER.warning("External service " + this.serviceFamily + " wants to open service " + family);
            return null;
        }
    }
}

