/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MapStoreConfigReadOnly;
import java.util.Properties;

public class MapStoreConfig {
    public static final int DEFAULT_WRITE_DELAY_SECONDS = 0;
    private boolean enabled = true;
    private String className = null;
    private String factoryClassName = null;
    private int writeDelaySeconds = 0;
    private Object implementation;
    private Object factoryImplementation;
    private Properties properties = new Properties();
    private MapStoreConfigReadOnly readOnly;

    public MapStoreConfig() {
    }

    public MapStoreConfig(MapStoreConfig config) {
        this.enabled = config.isEnabled();
        this.className = config.getClassName();
        this.implementation = config.getImplementation();
        this.factoryClassName = config.getFactoryClassName();
        this.factoryImplementation = config.getFactoryImplementation();
        this.writeDelaySeconds = config.getWriteDelaySeconds();
        this.properties = config.getProperties() != null ? new Properties(config.getProperties()) : null;
    }

    public MapStoreConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new MapStoreConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getClassName() {
        return this.className;
    }

    public MapStoreConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public MapStoreConfig setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
        return this;
    }

    public int getWriteDelaySeconds() {
        return this.writeDelaySeconds;
    }

    public MapStoreConfig setWriteDelaySeconds(int writeDelaySeconds) {
        this.writeDelaySeconds = writeDelaySeconds;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MapStoreConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MapStoreConfig setImplementation(Object implementation) {
        this.implementation = implementation;
        return this;
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public MapStoreConfig setFactoryImplementation(Object factoryImplementation) {
        this.factoryImplementation = factoryImplementation;
        return this;
    }

    public Object getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public MapStoreConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public MapStoreConfig setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        return "MapStoreConfig{className='" + this.className + '\'' + ", enabled=" + this.enabled + ", writeDelaySeconds=" + this.writeDelaySeconds + ", implementation=" + this.implementation + ", properties=" + this.properties + '}';
    }
}

