/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.ConfigCheck;
import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.Credentials;
import java.io.IOException;

public class JoinRequest
extends JoinMessage
implements DataSerializable {
    private Credentials credentials;
    private int tryCount = 0;

    public JoinRequest() {
    }

    public JoinRequest(byte packetVersion, int buildNumber, Address address, String uuid, ConfigCheck config, Credentials credentials, int memberCount, int tryCount) {
        super(packetVersion, buildNumber, address, uuid, config, memberCount);
        this.credentials = credentials;
        this.tryCount = tryCount;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.credentials = (Credentials)in.readObject();
        if (this.credentials != null) {
            this.credentials.setEndpoint(this.getAddress().getHost());
        }
        this.tryCount = in.readInt();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.credentials);
        out.writeInt(this.tryCount);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JoinRequest");
        sb.append("{packetVersion=").append(this.packetVersion);
        sb.append(", buildNumber=").append(this.buildNumber);
        sb.append(", address=").append(this.address);
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append(", credentials=").append(this.credentials);
        sb.append(", memberCount=").append(this.memberCount);
        sb.append(", tryCount=").append(this.tryCount);
        sb.append('}');
        return sb.toString();
    }
}

