/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.RTPPacket;

public class RTPPacketParser {
    public RTPPacket parse(Packet packet) throws BadFormatException {
        RTPPacket rTPPacket = new RTPPacket(packet);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(rTPPacket.data, rTPPacket.offset, rTPPacket.length));
        try {
            int n;
            int n2 = dataInputStream.readUnsignedByte();
            if ((n2 & 0xC0) != 128) {
                throw new BadFormatException();
            }
            if ((n2 & 0x10) != 0) {
                rTPPacket.extensionPresent = true;
            }
            int n3 = 0;
            if ((n2 & 0x20) != 0) {
                n3 = rTPPacket.data[rTPPacket.offset + rTPPacket.length - 1] & 0xFF;
            }
            n2 &= 0xF;
            rTPPacket.payloadType = dataInputStream.readUnsignedByte();
            rTPPacket.marker = rTPPacket.payloadType >> 7;
            rTPPacket.payloadType &= 0x7F;
            rTPPacket.seqnum = dataInputStream.readUnsignedShort();
            rTPPacket.timestamp = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
            rTPPacket.ssrc = dataInputStream.readInt();
            int n4 = 0;
            rTPPacket.csrc = new int[n2];
            for (n = 0; n < rTPPacket.csrc.length; ++n) {
                rTPPacket.csrc[n] = dataInputStream.readInt();
            }
            n4 += 12 + (rTPPacket.csrc.length << 2);
            if (rTPPacket.extensionPresent) {
                rTPPacket.extensionType = dataInputStream.readUnsignedShort();
                n = dataInputStream.readUnsignedShort();
                rTPPacket.extension = new byte[n <<= 2];
                dataInputStream.readFully(rTPPacket.extension);
                n4 += n + 4;
            }
            rTPPacket.payloadlength = rTPPacket.length - (n4 + n3);
            if (rTPPacket.payloadlength < 0) {
                throw new BadFormatException();
            }
            rTPPacket.payloadoffset = n4 + rTPPacket.offset;
        }
        catch (EOFException eOFException) {
            throw new BadFormatException("Unexpected end of RTP packet");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        return rTPPacket;
    }
}

