/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import com.lti.utils.StringUtils;
import com.lti.utils.synchronization.ProducerConsumerQueue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Format;
import net.sf.fmj.utility.FormatArgUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlMovieSAXHandler
extends DefaultHandler {
    private final ProducerConsumerQueue qMeta = new ProducerConsumerQueue();
    private final Map<Integer, ProducerConsumerQueue> qBuffers = new HashMap<Integer, ProducerConsumerQueue>();
    private final Map<Integer, Format> formatsMap = new HashMap<Integer, Format>();
    private int currentTrack = -1;
    private Buffer currentBuffer;
    private StringBuilder currentDataChars;
    private int state = 0;
    private static final int INIT = 0;
    private static final int AWAIT_BUFFER = 10;
    private static final int AWAIT_DATA = 11;
    private static final int READ_DATA = 12;

    XmlMovieSAXHandler() {
    }

    private static int getIntAttr(Attributes attributes, String string) throws SAXException {
        int n = attributes.getIndex(string);
        if (n < 0) {
            throw new SAXException("Missing attribute: " + string);
        }
        return XmlMovieSAXHandler.getIntAttr(attributes, string, 0);
    }

    private static int getIntAttr(Attributes attributes, String string, int n) throws SAXException {
        int n2 = attributes.getIndex(string);
        if (n2 < 0) {
            return n;
        }
        String string2 = attributes.getValue(n2);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Expected integer: " + string2, numberFormatException);
        }
    }

    private static long getLongAttr(Attributes attributes, String string) throws SAXException {
        int n = attributes.getIndex(string);
        if (n < 0) {
            throw new SAXException("Missing attribute: " + string);
        }
        return XmlMovieSAXHandler.getLongAttr(attributes, string, 0L);
    }

    private static long getLongAttr(Attributes attributes, String string, long l) throws SAXException {
        int n = attributes.getIndex(string);
        if (n < 0) {
            return l;
        }
        String string2 = attributes.getValue(n);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("Expected long: " + string2, numberFormatException);
        }
    }

    private static String getStringAttr(Attributes attributes, String string) throws SAXException {
        int n = attributes.getIndex(string);
        if (n < 0) {
            throw new SAXException("Missing attribute: " + string);
        }
        return XmlMovieSAXHandler.getStringAttr(attributes, string, null);
    }

    private static String getStringAttr(Attributes attributes, String string, String string2) throws SAXException {
        int n = attributes.getIndex(string);
        if (n < 0) {
            return string2;
        }
        String string3 = attributes.getValue(n);
        return string3;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.state == 12) {
            String string = new String(cArray, n, n2);
            this.currentDataChars.append(string);
        } else {
            String string = new String(cArray, n, n2);
            if ((string = string.trim()).length() > 0) {
                throw new SAXException("characters unexpected, state=" + this.state + " chars=" + string);
            }
        }
    }

    public void endDocument() throws SAXException {
        if (this.qBuffers != null) {
            for (ProducerConsumerQueue producerConsumerQueue : this.qBuffers.values()) {
                if (producerConsumerQueue == null) continue;
                Buffer buffer = new Buffer();
                buffer.setEOM(true);
                try {
                    producerConsumerQueue.put(buffer);
                }
                catch (InterruptedException interruptedException) {
                    throw new SAXException(interruptedException);
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("Tracks")) {
            if (this.formatsMap.size() == 0) {
                throw new SAXException("No tracks");
            }
            try {
                Format[] formatArray = new Format[this.formatsMap.size()];
                for (int i = 0; i < formatArray.length; ++i) {
                    Format format = this.formatsMap.get(i);
                    if (format == null) {
                        throw new SAXException("Expected format for track " + i);
                    }
                    formatArray[i] = format;
                }
                this.qMeta.put(formatArray);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else if (string2.equals("Data")) {
            byte[] byArray = StringUtils.hexStringToByteArray(this.currentDataChars.toString());
            this.currentBuffer.setData(byArray);
            this.currentBuffer.setOffset(0);
            this.currentBuffer.setLength(byArray.length);
            try {
                this.qBuffers.get(this.currentTrack).put(this.currentBuffer);
            }
            catch (InterruptedException interruptedException) {
                throw new SAXException(interruptedException);
            }
            this.currentBuffer = null;
            this.currentTrack = -1;
            this.currentDataChars = null;
            this.state = 10;
        }
    }

    public void postError(Exception exception) throws InterruptedException {
        if (this.qMeta != null) {
            this.qMeta.put(exception);
        }
        if (this.qBuffers != null) {
            for (ProducerConsumerQueue producerConsumerQueue : this.qBuffers.values()) {
                if (producerConsumerQueue == null) continue;
                producerConsumerQueue.put(exception);
            }
        }
    }

    public Buffer readBuffer(int n) throws SAXException, IOException, InterruptedException {
        Object t = this.qBuffers.get(n).get();
        if (t instanceof Buffer) {
            return (Buffer)t;
        }
        if (t instanceof SAXException) {
            throw (SAXException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new RuntimeException("Unknown object in queue: " + t);
    }

    public Format[] readTracksInfo() throws SAXException, IOException, InterruptedException {
        Object t = this.qMeta.get();
        if (t instanceof Format[]) {
            return (Format[])t;
        }
        if (t instanceof SAXException) {
            throw (SAXException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new RuntimeException("Unknown object in queue: " + t);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string2.equals("XmlMovie")) {
                String string4 = attributes.getValue(attributes.getIndex("version"));
                if (!string4.equals("1.0")) {
                    throw new SAXException("Expection XmlMovie version 1.0");
                }
            } else if (string2.equals("Track")) {
                int n = XmlMovieSAXHandler.getIntAttr(attributes, "index");
                String string5 = XmlMovieSAXHandler.getStringAttr(attributes, "format");
                Format format = FormatArgUtils.parse(string5);
                this.formatsMap.put(n, format);
                this.qBuffers.put(n, new ProducerConsumerQueue());
            } else if (string2.equals("Buffer")) {
                this.currentTrack = XmlMovieSAXHandler.getIntAttr(attributes, "track");
                long l = XmlMovieSAXHandler.getLongAttr(attributes, "sequenceNumber", 0x7FFFFFFFFFFFFFFEL);
                long l2 = XmlMovieSAXHandler.getLongAttr(attributes, "timeStamp");
                long l3 = XmlMovieSAXHandler.getLongAttr(attributes, "duration", -1L);
                int n = XmlMovieSAXHandler.getIntAttr(attributes, "flags", 0);
                String string6 = XmlMovieSAXHandler.getStringAttr(attributes, "format", null);
                Format format = string6 == null ? this.formatsMap.get(this.currentTrack) : FormatArgUtils.parse(string6);
                Buffer buffer = new Buffer();
                buffer.setSequenceNumber(l);
                buffer.setTimeStamp(l2);
                buffer.setDuration(l3);
                buffer.setFlags(n);
                buffer.setFormat(format);
                this.currentBuffer = buffer;
                this.currentDataChars = new StringBuilder();
                this.state = 11;
            } else if (string2.equals("Data")) {
                if (this.state != 11) {
                    throw new SAXException("Not expecting Data element");
                }
                this.state = 12;
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }
}

