/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.util.List;
import java.util.Vector;
import javax.media.ControllerEvent;
import net.sf.fmj.media.util.MediaThread;

public abstract class ThreadedEventQueue
extends MediaThread {
    private List<ControllerEvent> eventQueue = new Vector<ControllerEvent>();
    private boolean killed = false;

    public ThreadedEventQueue() {
        this.useControlPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchEvents() {
        ControllerEvent controllerEvent = null;
        ThreadedEventQueue threadedEventQueue = this;
        synchronized (threadedEventQueue) {
            try {
                while (!this.killed && this.eventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                System.err.println("MediaNode event thread " + interruptedException);
                return true;
            }
            if (this.eventQueue.size() > 0) {
                controllerEvent = this.eventQueue.remove(0);
            }
        }
        if (controllerEvent != null) {
            this.processEvent(controllerEvent);
        }
        return !this.killed || this.eventQueue.size() != 0;
    }

    public synchronized void kill() {
        this.killed = true;
        this.notifyAll();
    }

    public synchronized void postEvent(ControllerEvent controllerEvent) {
        this.eventQueue.add(controllerEvent);
        this.notifyAll();
    }

    protected abstract void processEvent(ControllerEvent var1);

    public void run() {
        while (this.dispatchEvents()) {
        }
    }
}

