/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.RTPControlImpl;
import net.sf.fmj.media.rtp.RTPDemultiplexer;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SourceRTPPacket;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.SSRCTable;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class RTPReceiver
extends PacketFilter {
    final SSRCCache cache;
    final RTPDemultiplexer rtpdemultiplexer;
    int lastseqnum = -1;
    private boolean rtcpstarted = false;
    private final String content;
    final SSRCTable<RTPPacket> probationList = new SSRCTable();
    static final int MAX_DROPOUT = 3000;
    static final int MAX_MISORDER = 100;
    static final int SEQ_MOD = 65536;
    static final int MIN_SEQUENTIAL = 2;
    private boolean initBC = false;
    public final String controlstr;
    private int errorPayload = -1;

    public RTPReceiver(SSRCCache sSRCCache, RTPDemultiplexer rTPDemultiplexer) {
        this.content = "";
        this.controlstr = "javax.media.rtp.RTPControl";
        this.cache = sSRCCache;
        this.rtpdemultiplexer = rTPDemultiplexer;
        this.setConsumer(null);
    }

    public RTPReceiver(SSRCCache sSRCCache, RTPDemultiplexer rTPDemultiplexer, DatagramSocket datagramSocket) {
        this(sSRCCache, rTPDemultiplexer, new RTPRawReceiver(datagramSocket, sSRCCache.sm.defaultstats));
    }

    public RTPReceiver(SSRCCache sSRCCache, RTPDemultiplexer rTPDemultiplexer, int n, String string) throws UnknownHostException, IOException {
        this(sSRCCache, rTPDemultiplexer, new RTPRawReceiver(n & 0xFFFFFFFE, string, sSRCCache.sm.defaultstats));
    }

    public RTPReceiver(SSRCCache sSRCCache, RTPDemultiplexer rTPDemultiplexer, PacketSource packetSource) {
        this(sSRCCache, rTPDemultiplexer);
        this.setSource(packetSource);
    }

    public String filtername() {
        return "RTP Packet Receiver";
    }

    public Packet handlePacket(Packet packet) {
        return this.handlePacket((RTPPacket)packet);
    }

    public Packet handlePacket(Packet packet, int n) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress, boolean bl) {
        return null;
    }

    public Packet handlePacket(RTPPacket rTPPacket) {
        Serializable serializable;
        Object object;
        int n;
        int n2;
        InetAddress inetAddress;
        Object object2;
        Object object3;
        if (rTPPacket.payloadType == 13) {
            return rTPPacket;
        }
        if (rTPPacket.payloadType == 126) {
            return null;
        }
        if (rTPPacket.base instanceof UDPPacket) {
            object3 = ((UDPPacket)rTPPacket.base).remoteAddress;
            if (this.cache.sm.bindtome && !this.cache.sm.isBroadcast(this.cache.sm.dataaddress) && !((InetAddress)object3).equals(this.cache.sm.dataaddress)) {
                return null;
            }
        }
        if (rTPPacket.base instanceof UDPPacket) {
            object2 = (UDPPacket)rTPPacket.base;
            inetAddress = object2.remoteAddress;
            n2 = object2.remotePort;
        } else {
            inetAddress = null;
            n2 = 0;
        }
        object3 = this.cache.get(rTPPacket.ssrc, inetAddress, n2, 1);
        if (object3 == null) {
            return null;
        }
        for (n = 0; n < rTPPacket.csrc.length; ++n) {
            int n3;
            InetAddress inetAddress2;
            if (rTPPacket.base instanceof UDPPacket) {
                UDPPacket uDPPacket = (UDPPacket)rTPPacket.base;
                inetAddress2 = uDPPacket.remoteAddress;
                n3 = uDPPacket.remotePort;
            } else {
                inetAddress2 = null;
                n3 = 0;
            }
            object = this.cache.get(rTPPacket.csrc[n], inetAddress2, n3, 1);
            if (object == null) continue;
            object.lastHeardFrom = rTPPacket.receiptTime;
        }
        if (!((SSRCInfo)object3).sender) {
            ((SSRCInfo)object3).initsource(rTPPacket.seqnum);
            ((SSRCInfo)object3).payloadType = rTPPacket.payloadType;
        }
        if ((n = rTPPacket.seqnum - ((SSRCInfo)object3).maxseq) > 0) {
            if (((SSRCInfo)object3).maxseq + 1 != rTPPacket.seqnum) {
                ((SSRCInfo)object3).stats.update(0, n - 1);
            }
        } else if (n < 0 && n > -100) {
            ((SSRCInfo)object3).stats.update(0, -1);
        }
        if (((SSRCInfo)object3).wrapped) {
            ((SSRCInfo)object3).wrapped = false;
        }
        n2 = 0;
        if (((SSRCInfo)object3).probation > 0) {
            if (rTPPacket.seqnum == ((SSRCInfo)object3).maxseq + 1) {
                --((SSRCInfo)object3).probation;
                ((SSRCInfo)object3).maxseq = rTPPacket.seqnum;
                if (((SSRCInfo)object3).probation == 0) {
                    n2 = 1;
                }
            } else {
                ((SSRCInfo)object3).probation = 1;
                ((SSRCInfo)object3).maxseq = rTPPacket.seqnum;
                ((SSRCInfo)object3).stats.update(2);
            }
        } else if (n < 3000 && n != 0) {
            if (rTPPacket.seqnum < ((SSRCInfo)object3).baseseq && n < -32767) {
                ((SSRCInfo)object3).cycles += 65536;
                ((SSRCInfo)object3).wrapped = true;
            }
            ((SSRCInfo)object3).maxseq = rTPPacket.seqnum;
        } else if (n <= 65436 && n != 0) {
            ((SSRCInfo)object3).stats.update(3);
            if (rTPPacket.seqnum == ((SSRCInfo)object3).lastbadseq) {
                ((SSRCInfo)object3).initsource(rTPPacket.seqnum);
            } else {
                ((SSRCInfo)object3).lastbadseq = rTPPacket.seqnum + 1 & 0xFFFF;
            }
        } else {
            ((SSRCInfo)object3).stats.update(4);
        }
        if (this.cache.sm.isUnicast()) {
            object2 = ((UDPPacket)rTPPacket.base).remoteAddress;
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports((InetAddress)object2);
                this.rtcpstarted = true;
                object = this.cache.sm.controladdress.getAddress();
                int n4 = object[3] & 0xFF;
                if ((n4 & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    serializable = null;
                    boolean bl = true;
                    try {
                        serializable = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        bl = false;
                    }
                    if (bl) {
                        this.cache.sm.addUnicastAddr((InetAddress)serializable);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr((InetAddress)object2)) {
                this.cache.sm.addUnicastAddr((InetAddress)object2);
            }
        }
        ++((SSRCInfo)object3).received;
        ((SSRCInfo)object3).stats.update(1);
        if (((SSRCInfo)object3).probation > 0) {
            this.probationList.put(((SSRCInfo)object3).ssrc, rTPPacket.clone());
            return null;
        }
        ((SSRCInfo)object3).maxseq = rTPPacket.seqnum;
        if (((SSRCInfo)object3).lastPayloadType != -1 && ((SSRCInfo)object3).lastPayloadType != rTPPacket.payloadType) {
            ((SSRCInfo)object3).currentformat = null;
            if (((SSRCInfo)object3).dsource != null && (object2 = (RTPControlImpl)((SSRCInfo)object3).dsource.getControl(this.controlstr)) != null) {
                object2.currentformat = null;
                object2.payload = -1;
            }
            if (((SSRCInfo)object3).dsource != null) {
                try {
                    Log.warning("Stopping stream because of payload type mismatch: expecting pt=" + ((SSRCInfo)object3).lastPayloadType + ", got pt=" + rTPPacket.payloadType);
                    ((SSRCInfo)object3).dsource.stop();
                }
                catch (IOException iOException) {
                    System.err.println("Stopping DataSource after PCE " + iOException.getMessage());
                }
            }
            ((SSRCInfo)object3).lastPayloadType = rTPPacket.payloadType;
            object2 = new RemotePayloadChangeEvent(this.cache.sm, (ReceiveStream)object3, ((SSRCInfo)object3).lastPayloadType, rTPPacket.payloadType);
            this.cache.eventhandler.postEvent((RTPEvent)object2);
        }
        if (((SSRCInfo)object3).currentformat == null) {
            ((SSRCInfo)object3).currentformat = this.cache.sm.formatinfo.get(rTPPacket.payloadType);
            if (((SSRCInfo)object3).currentformat == null) {
                if (this.errorPayload != rTPPacket.payloadType) {
                    Log.error("No format has been registered for RTP payload type " + rTPPacket.payloadType);
                    this.errorPayload = rTPPacket.payloadType;
                }
                return rTPPacket;
            }
            if (((SSRCInfo)object3).dstream != null) {
                ((SSRCInfo)object3).dstream.setFormat(((SSRCInfo)object3).currentformat);
            }
        }
        if (((SSRCInfo)object3).currentformat == null) {
            System.err.println("No Format for PT= " + rTPPacket.payloadType);
            return rTPPacket;
        }
        if (((SSRCInfo)object3).dsource != null && (object2 = (RTPControlImpl)((SSRCInfo)object3).dsource.getControl(this.controlstr)) != null) {
            object = this.cache.sm.formatinfo.get(rTPPacket.payloadType);
            object2.currentformat = object;
        }
        if (!this.initBC) {
            ((BufferControlImpl)this.cache.sm.buffercontrol).initBufferControl(((SSRCInfo)object3).currentformat);
            this.initBC = true;
        }
        if (!((SSRCInfo)object3).streamconnect) {
            object2 = this.cache.sm.dslist.get(((SSRCInfo)object3).ssrc);
            if (object2 == null) {
                object = this.cache.sm.getDataSource(null);
                if (object == null) {
                    object2 = this.cache.sm.createNewDS(null);
                    this.cache.sm.setDefaultDSassigned(((SSRCInfo)object3).ssrc);
                } else if (!this.cache.sm.isDefaultDSassigned()) {
                    object2 = object;
                    this.cache.sm.setDefaultDSassigned(((SSRCInfo)object3).ssrc);
                } else {
                    object2 = this.cache.sm.createNewDS(((SSRCInfo)object3).ssrc);
                }
            }
            object = object2.getStreams();
            ((SSRCInfo)object3).dsource = object2;
            ((SSRCInfo)object3).dstream = (RTPSourceStream)object[0];
            ((SSRCInfo)object3).dstream.setContentDescriptor(this.content);
            ((SSRCInfo)object3).dstream.setFormat(((SSRCInfo)object3).currentformat);
            RTPControlImpl rTPControlImpl = (RTPControlImpl)((SSRCInfo)object3).dsource.getControl(this.controlstr);
            if (rTPControlImpl != null) {
                serializable = this.cache.sm.formatinfo.get(rTPPacket.payloadType);
                rTPControlImpl.currentformat = serializable;
                rTPControlImpl.stream = object3;
            }
            ((SSRCInfo)object3).streamconnect = true;
        }
        if (((SSRCInfo)object3).dsource != null) {
            ((SSRCInfo)object3).active = true;
        }
        if (!((SSRCInfo)object3).newrecvstream) {
            object2 = new NewReceiveStreamEvent(this.cache.sm, (ReceiveStream)object3);
            ((SSRCInfo)object3).newrecvstream = true;
            this.cache.eventhandler.postEvent((RTPEvent)object2);
        }
        if (((SSRCInfo)object3).lastRTPReceiptTime != 0L && ((SSRCInfo)object3).lastPayloadType == rTPPacket.payloadType) {
            long l = rTPPacket.receiptTime - ((SSRCInfo)object3).lastRTPReceiptTime;
            long l2 = rTPPacket.timestamp - ((SSRCInfo)object3).lasttimestamp;
            double d = (l = l * (long)this.cache.clockrate[((SSRCInfo)object3).payloadType] / 1000L) - l2;
            if (d < 0.0) {
                d = -d;
            }
            ((SSRCInfo)object3).jitter += 0.0625 * (d - ((SSRCInfo)object3).jitter);
        }
        ((SSRCInfo)object3).lastRTPReceiptTime = rTPPacket.receiptTime;
        ((SSRCInfo)object3).lasttimestamp = rTPPacket.timestamp;
        ((SSRCInfo)object3).payloadType = rTPPacket.payloadType;
        ((SSRCInfo)object3).lastPayloadType = rTPPacket.payloadType;
        ((SSRCInfo)object3).bytesreceived += rTPPacket.payloadlength;
        ((SSRCInfo)object3).lastHeardFrom = rTPPacket.receiptTime;
        if (((SSRCInfo)object3).quiet) {
            ((SSRCInfo)object3).quiet = false;
            ActiveReceiveStreamEvent activeReceiveStreamEvent = new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ((SSRCInfo)object3).sourceInfo, object3 instanceof ReceiveStream ? (ReceiveStream)object3 : null);
            this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
        }
        SourceRTPPacket sourceRTPPacket = new SourceRTPPacket(rTPPacket, (SSRCInfo)object3);
        if (((SSRCInfo)object3).dsource != null) {
            if (n2 != 0 && (object = this.probationList.remove(((SSRCInfo)object3).ssrc)) != null) {
                this.rtpdemultiplexer.demuxpayload(new SourceRTPPacket((RTPPacket)object, (SSRCInfo)object3));
            }
            this.rtpdemultiplexer.demuxpayload(sourceRTPPacket);
        }
        return rTPPacket;
    }
}

