/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.video;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;
import javax.swing.JComponent;
import net.sf.fmj.media.AbstractVideoRenderer;
import net.sf.fmj.media.util.BufferToImage;
import net.sf.fmj.utility.FPSCounter;
import net.sf.fmj.utility.LoggerSingleton;

public class SimpleSwingRenderer
extends AbstractVideoRenderer
implements VideoRenderer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean PAINT_IMMEDIATELY = false;
    private static final boolean TRACE_FPS = false;
    private final Format[] supportedInputFormats = new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 32, 1, 2, 3), new RGBFormat(null, -1, Format.byteArray, -1.0f, 32, 3, 2, 1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 1, 2, 3), new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1), new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, -1, -1, -1, 1, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 8, -1, -1, -1, 1, -1, 0, -1)};
    private SwingVideoComponent component = new SwingVideoComponent();
    private Object[] controls = new Object[]{this};
    private BufferToImage bufferToImage;
    private final FPSCounter fpsCounter = new FPSCounter();

    public int doProcess(Buffer buffer) {
        if (buffer.isEOM()) {
            logger.warning(this.getClass().getSimpleName() + "passed buffer with EOM flag");
            return 0;
        }
        if (buffer.getData() == null) {
            return 1;
        }
        Image image = this.bufferToImage.createImage(buffer);
        this.component.setImage(image);
        return 0;
    }

    public Component getComponent() {
        return this.component;
    }

    public Object[] getControls() {
        return this.controls;
    }

    public String getName() {
        return "Simple Swing Renderer";
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format setInputFormat(Format format) {
        this.bufferToImage = new BufferToImage((VideoFormat)format);
        return super.setInputFormat(format);
    }

    private class SwingVideoComponent
    extends JComponent {
        private Image image;
        private boolean scale = true;
        private BufferedImage biCompatible;

        public SwingVideoComponent() {
            this.setDoubleBuffered(false);
        }

        private BufferedImage getCompatibleBufferedImage() {
            if (this.biCompatible == null || this.biCompatible.getWidth() != this.image.getWidth(null) || this.biCompatible.getHeight() != this.image.getHeight(null)) {
                this.biCompatible = this.getGraphicsConfiguration().createCompatibleImage(this.image.getWidth(null), this.image.getHeight(null));
            }
            return this.biCompatible;
        }

        public Dimension getPreferredSize() {
            if (SimpleSwingRenderer.this.inputFormat == null) {
                return super.getPreferredSize();
            }
            VideoFormat videoFormat = (VideoFormat)SimpleSwingRenderer.this.inputFormat;
            return videoFormat.getSize();
        }

        private Rectangle getVideoRect(boolean bl) {
            int n;
            int n2;
            int n3;
            int n4;
            Dimension dimension = this.getPreferredSize();
            Dimension dimension2 = this.getSize();
            if (!bl) {
                if (dimension.width <= dimension2.width) {
                    n4 = (dimension2.width - dimension.width) / 2;
                    n3 = dimension.width;
                } else {
                    n4 = 0;
                    n3 = dimension.width;
                }
                if (dimension.height <= dimension2.height) {
                    n2 = (dimension2.height - dimension.height) / 2;
                    n = dimension.height;
                } else {
                    n2 = 0;
                    n = dimension.height;
                }
            } else if ((float)dimension2.width / (float)dimension.width < (float)dimension2.height / (float)dimension.height) {
                n3 = dimension2.width;
                n = dimension2.width * dimension.height / dimension.width;
                n4 = 0;
                n2 = (dimension2.height - n) / 2;
            } else {
                n3 = dimension2.height * dimension.width / dimension.height;
                n = dimension2.height;
                n4 = (dimension2.width - n3) / 2;
                n2 = 0;
            }
            return new Rectangle(n4, n2, n3, n);
        }

        public void paint(Graphics graphics) {
            if (this.image != null) {
                Rectangle rectangle = this.getVideoRect(this.scale);
                try {
                    if (this.biCompatible == null) {
                        graphics.drawImage(this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                        return;
                    }
                }
                catch (ImagingOpException imagingOpException) {
                    // empty catch block
                }
                this.getCompatibleBufferedImage();
                this.biCompatible.getGraphics().drawImage(this.image, 0, 0, this.image.getWidth(null), this.image.getHeight(null), null);
                graphics.drawImage(this.biCompatible, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            }
        }

        public void setImage(Image image) {
            this.image = image;
            this.repaint();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

