/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.datasink.rtp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.fmj.media.datasink.rtp.ParsedRTPUrl;
import net.sf.fmj.media.datasink.rtp.ParsedRTPUrlElement;
import net.sf.fmj.media.datasink.rtp.RTPUrlParserException;

public class RTPUrlParser {
    private static final Pattern pattern = Pattern.compile("rtp://([a-zA-Z_/\\.0-9]+)(:([0-9]+))(/(audio|video)(/([0-9]+))?)(\\&([a-zA-Z_/\\.0-9]+)(:([0-9]+))(/(audio|video)(/([0-9]+))?))?");

    private static ParsedRTPUrlElement extract(Matcher matcher, int n) throws RTPUrlParserException {
        ParsedRTPUrlElement parsedRTPUrlElement = new ParsedRTPUrlElement();
        try {
            parsedRTPUrlElement.host = matcher.group(n + 1);
            parsedRTPUrlElement.port = Integer.parseInt(matcher.group(n + 3));
            parsedRTPUrlElement.type = matcher.group(n + 5);
            if (matcher.group(n + 7) != null) {
                parsedRTPUrlElement.ttl = Integer.parseInt(matcher.group(n + 7));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new RTPUrlParserException(numberFormatException);
        }
        return parsedRTPUrlElement;
    }

    public static ParsedRTPUrl parse(String string) throws RTPUrlParserException {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new RTPUrlParserException("URL does not match regular expression for RTP URLs");
        }
        ParsedRTPUrlElement parsedRTPUrlElement = RTPUrlParser.extract(matcher, 0);
        if (matcher.group(9) == null) {
            return new ParsedRTPUrl(parsedRTPUrlElement);
        }
        ParsedRTPUrlElement parsedRTPUrlElement2 = RTPUrlParser.extract(matcher, 8);
        if (parsedRTPUrlElement2.type.equals(parsedRTPUrlElement.type)) {
            throw new RTPUrlParserException("Both elements of the RTP URL have type " + parsedRTPUrlElement.type);
        }
        return new ParsedRTPUrl(parsedRTPUrlElement, parsedRTPUrlElement2);
    }
}

