/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.StopTimeSetError;
import javax.media.Time;
import javax.media.TimeBase;

public class AbstractClock
implements Clock {
    private TimeBase systemtimebase;
    private TimeBase timebase;
    private Time mediaStartTime;
    private Time mediaStopTime;
    private Time timeBaseStartTime;
    private float rate;
    private boolean isStarted;

    public AbstractClock() {
        this.timebase = this.systemtimebase = Manager.getSystemTimeBase();
        this.mediaStartTime = new Time(0L);
        this.mediaStopTime = Clock.RESET;
        this.rate = 1.0f;
        this.isStarted = false;
    }

    private synchronized Time calculateMediaTime() {
        long l;
        long l2 = this.timebase.getNanoseconds();
        if (l2 < (l = this.timeBaseStartTime.getNanoseconds())) {
            return this.mediaStartTime;
        }
        long l3 = this.mediaStartTime.getNanoseconds();
        long l4 = (long)((float)(l2 - l) * this.rate + (float)l3);
        return new Time(l4);
    }

    public synchronized long getMediaNanoseconds() {
        return this.getMediaTime().getNanoseconds();
    }

    protected Time getMediaStartTime() {
        return this.mediaStartTime;
    }

    public synchronized Time getMediaTime() {
        if (!this.isStarted) {
            return this.mediaStartTime;
        }
        return this.calculateMediaTime();
    }

    public synchronized float getRate() {
        return this.rate;
    }

    public synchronized Time getStopTime() {
        return this.mediaStopTime;
    }

    public synchronized Time getSyncTime() {
        long l;
        long l2;
        if (this.isStarted && (l2 = this.timeBaseStartTime.getNanoseconds()) >= (l = this.getTimeBase().getNanoseconds())) {
            return new Time(l - l2);
        }
        return this.getMediaTime();
    }

    public synchronized TimeBase getTimeBase() {
        return this.timebase;
    }

    protected Time getTimeBaseStartTime() {
        return this.timeBaseStartTime;
    }

    public synchronized Time mapToTimeBase(Time time) throws ClockStoppedException {
        if (!this.isStarted) {
            throw new ClockStoppedException("Cannot map media time to time-base time on a Stopped Clock");
        }
        long l = time.getNanoseconds();
        long l2 = this.mediaStartTime.getNanoseconds();
        long l3 = this.timeBaseStartTime.getNanoseconds();
        return new Time((long)((float)(l - l2) / this.rate + (float)l3));
    }

    public synchronized void setMediaTime(Time time) {
        if (this.isStarted) {
            throw new ClockStartedError("Cannot set media time on a Started Clock");
        }
        this.mediaStartTime = time;
    }

    public synchronized float setRate(float f) {
        if (this.isStarted) {
            throw new ClockStartedError("Cannot set rate on a Started Clock");
        }
        if (f != 0.0f) {
            this.rate = f;
        }
        return this.rate;
    }

    public synchronized void setStopTime(Time time) {
        if (this.isStarted && this.mediaStopTime != RESET) {
            throw new StopTimeSetError("Stop time may be set only once on a Started Clock");
        }
        this.mediaStopTime = time;
    }

    public synchronized void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (this.isStarted) {
            throw new ClockStartedError("Cannot set time base on a Started Clock");
        }
        this.timebase = timeBase == null ? this.systemtimebase : timeBase;
    }

    public synchronized void stop() {
        if (this.isStarted) {
            this.mediaStartTime = this.calculateMediaTime();
            this.isStarted = false;
        }
    }

    public synchronized void syncStart(Time time) {
        if (this.isStarted) {
            throw new ClockStartedError("syncStart() cannot be called on a started Clock");
        }
        long l = this.getTimeBase().getNanoseconds();
        long l2 = time.getNanoseconds();
        this.timeBaseStartTime = l2 - l > 0L ? new Time(l2) : new Time(l);
        this.isStarted = true;
    }
}

