/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.util.EventListener;
import javax.media.Controller;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.MediaTimeSetEvent;
import javax.media.PrefetchCompleteEvent;
import javax.media.RestartingEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.fmj.ejmf.toolkit.gui.controls.ChangeListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.ProgressBar;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimer;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerEvent;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerListener;
import net.sf.fmj.ejmf.toolkit.util.TimeSource;

public class StandardProgressControl
extends ChangeListenerControl
implements ControllerListener,
TimeSource,
SourcedTimerListener {
    private boolean firstPrefetch = true;
    private SourcedTimer controlTimer;
    private long duration;
    private static final int TIMER_TICK = 250;

    public StandardProgressControl(Skin skin) {
        super(skin);
    }

    public StandardProgressControl(Skin skin, Controller controller) {
        this(skin);
        this.setController(controller);
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (this.isOperational()) {
            if (controllerEvent instanceof StartEvent || controllerEvent instanceof RestartingEvent) {
                this.controlTimer.start();
            } else if (controllerEvent instanceof StopEvent || controllerEvent instanceof ControllerErrorEvent) {
                this.controlTimer.stop();
            } else if (controllerEvent instanceof MediaTimeSetEvent) {
                this.setValue(this.getTime());
            }
        } else if (this.firstPrefetch && controllerEvent instanceof PrefetchCompleteEvent) {
            this.firstPrefetch = false;
            this.init();
        }
    }

    protected Component createControlComponent(Skin skin) {
        return skin.createProgressSlider();
    }

    protected EventListener createControlListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ProgressBar progressBar = (ProgressBar)changeEvent.getSource();
                int n = progressBar.getValue();
                long l = (long)n * StandardProgressControl.this.duration / (long)(progressBar.getMaximum() - progressBar.getMinimum());
                Controller controller = StandardProgressControl.this.getController();
                int n2 = controller.getState();
                if (n2 == 600) {
                    controller.stop();
                }
                controller.setMediaTime(new Time(l));
                if (n2 == 600) {
                    Time time = controller.getTimeBase().getTime();
                    controller.syncStart(time);
                }
            }
        };
    }

    public long getConversionDivisor() {
        return 1000000000L;
    }

    public long getTime() {
        return this.getController().getMediaNanoseconds();
    }

    private void init() {
        boolean bl;
        Time time = this.getController().getDuration();
        boolean bl2 = bl = time != Duration.DURATION_UNBOUNDED && time != Duration.DURATION_UNKNOWN;
        if (bl) {
            this.duration = time.getNanoseconds();
            bl = this.duration != 0L;
        }
        this.setOperational(bl);
        if (bl) {
            this.controlTimer = new SourcedTimer((TimeSource)this, 250);
            this.controlTimer.addSourcedTimerListener(this);
            Time time2 = this.getController().getMediaTime();
            long l = time2.getNanoseconds();
            this.setValue(l);
            if (this.getController().getState() == 600) {
                this.controlTimer.start();
            }
        }
    }

    protected void setControllerHook(Controller controller) {
        this.setOperational(false);
        this.getController().addControllerListener(this);
        if (controller.getState() >= 500) {
            this.init();
        }
    }

    public void setValue(long l) {
        if (!this.isOperational()) {
            return;
        }
        ProgressBar progressBar = (ProgressBar)((Object)this.getControlComponent());
        long l2 = progressBar.getMaximum() - progressBar.getMinimum();
        int n = (int)(l2 * l / this.duration);
        SwingUtilities.invokeLater(new SetProgressSliderValueThread(progressBar, n));
    }

    public void timerUpdate(SourcedTimerEvent sourcedTimerEvent) {
        this.setValue(this.getTime());
    }

    class SetProgressSliderValueThread
    implements Runnable {
        int value;
        ProgressBar bar;

        public SetProgressSliderValueThread(ProgressBar progressBar, int n) {
            this.value = n;
            this.bar = progressBar;
        }

        public void run() {
            this.bar.setValue(this.value);
        }
    }

    class EnableComponentThread
    implements Runnable {
        EnableComponentThread() {
        }

        public void run() {
            StandardProgressControl.this.getControlComponent().setEnabled(StandardProgressControl.this.isOperational());
        }
    }
}

