/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import uk.ltd.getahead.dwr.util.Logger;
import uk.ltd.getahead.dwr.util.WriterOutputStream;

public final class SwallowingHttpServletResponse
extends HttpServletResponseWrapper
implements HttpServletResponse {
    private static final Logger log = Logger.getLogger(SwallowingHttpServletResponse.class);
    private final ServletOutputStream oout;
    private final PrintWriter pout;
    private int bufferSize;

    public SwallowingHttpServletResponse(HttpServletResponse response, Writer sout) {
        super(response);
        this.pout = new PrintWriter(sout);
        this.oout = new WriterOutputStream(sout);
        this.bufferSize = response.getBufferSize();
    }

    public ServletOutputStream getOutputStream() {
        return this.oout;
    }

    public PrintWriter getWriter() {
        return this.pout;
    }

    public void flushBuffer() throws IOException {
        this.pout.flush();
    }

    public void sendError(int sc, String msg) {
        log.warn("Ignoring call to sendError(" + sc + ", " + msg + ')');
    }

    public void sendError(int sc) {
        log.warn("Ignoring call to sendError(" + sc + ')');
    }

    public void sendRedirect(String location) {
        log.warn("Ignoring call to sendRedirect(" + location + ')');
    }

    public void setStatus(int sc) {
        log.warn("Ignoring call to setStatus(" + sc + ')');
    }

    public void setStatus(int sc, String sm) {
        log.warn("Ignoring call to setStatus(" + sc + ", " + sm + ')');
    }

    public void setContentLength(int i) {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

