/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import java.lang.reflect.Type;

public abstract class ChainedFactory
implements Factory<Converter<?>> {
    private Factory<? extends Converter<?>> next;

    protected ChainedFactory() {
    }

    protected ChainedFactory(Factory<Converter<?>> next) {
        this.next = next;
    }

    @Override
    public Converter<?> create(Type type, Genson genson) {
        Converter<?> converter;
        Converter<?> nextConverter = null;
        if (this.next != null) {
            nextConverter = this.next.create(type, genson);
        }
        return (converter = this.create(type, genson, nextConverter)) == null ? nextConverter : converter;
    }

    protected abstract Converter<?> create(Type var1, Genson var2, Converter<?> var3);

    public final <T extends Factory<? extends Converter<?>>> T withNext(T next) {
        if (this.next != null) {
            throw new IllegalStateException("next factory has already been set for " + this.getClass() + " you can not override it!");
        }
        this.next = next;
        return next;
    }

    public final <T extends Factory<? extends Converter<?>>> T append(T next) {
        ChainedFactory f = this;
        while (f.next() != null) {
            if (!(f.next() instanceof ChainedFactory)) {
                throw new UnsupportedOperationException("Last element in the chain is not a ChainedFactory");
            }
            f = (ChainedFactory)f.next();
        }
        return f.withNext(next);
    }

    public final Factory<? extends Converter<?>> next() {
        return this.next;
    }
}

