/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.exceptions.VException;
import com.voxeo.utils.Closer;
import com.voxeo.utils.ReadOnlyIterator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineIterator
extends ReadOnlyIterator<String>
implements Closeable {
    private boolean closeIstream = false;
    private BufferedReader istream;
    private String text;
    private int lineStartIndex = -1;
    private int currentIndex = -1;
    private String nextLine = null;

    public LineIterator(String text) {
        this.text = text;
        this.lineStartIndex = 0;
        this.currentIndex = -1;
    }

    public LineIterator(InputStream istream, boolean closeIstream) {
        this.closeIstream = closeIstream;
        this.istream = new BufferedReader(new InputStreamReader(istream));
    }

    public LineIterator(InputStream istream) {
        this(istream, false);
    }

    public LineIterator(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)), true);
    }

    public LineIterator(URL url) throws IOException {
        this(new BufferedInputStream(url.openStream()), true);
    }

    @Override
    public boolean hasNext() {
        if (this.nextLine == null) {
            this.findNextLine();
        }
        return this.nextLine != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        try {
            if (this.nextLine == null) {
                this.findNextLine();
                if (this.nextLine == null) {
                    throw new NoSuchElementException();
                }
            }
            String string = this.nextLine;
            return string;
        }
        finally {
            this.nextLine = null;
        }
    }

    private void findNextLine() {
        if (this.istream != null) {
            try {
                this.nextLine = this.istream.readLine();
            }
            catch (IOException e) {
                if (this.closeIstream) {
                    Closer.close(this.istream);
                    this.istream = null;
                }
                throw new VException(e);
            }
        } else if (this.text != null) {
            if (this.lineStartIndex >= this.text.length()) {
                return;
            }
            while (this.nextLine == null && this.currentIndex + 1 < this.text.length()) {
                ++this.currentIndex;
                char current = this.text.charAt(this.currentIndex);
                switch (current) {
                    case '\r': {
                        break;
                    }
                    case '\n': {
                        this.nextLine = this.text.substring(this.lineStartIndex, this.currentIndex);
                        this.lineStartIndex = this.currentIndex + 1;
                    }
                }
            }
            if (this.nextLine == null) {
                this.nextLine = this.text.substring(this.lineStartIndex, this.currentIndex + 1);
                this.lineStartIndex = this.currentIndex + 1;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closeIstream && this.istream != null) {
            this.istream.close();
            this.istream = null;
        }
    }
}

