/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Multiplexer;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.MediaTimeBase;
import net.sf.fmj.media.control.MonitorAdapter;
import net.sf.fmj.media.protocol.BasicPushBufferDataSource;
import net.sf.fmj.media.protocol.BasicSourceStream;
import net.sf.fmj.media.util.MediaThread;

public class RawBufferMux
extends BasicPlugIn
implements Multiplexer,
Clock {
    protected ContentDescriptor[] supported = null;
    protected ContentDescriptor contentDesc = null;
    protected RawBufferDataSource source = null;
    protected RawBufferSourceStream[] streams = null;
    protected BasicClock clock = null;
    protected RawMuxTimeBase timeBase = null;
    protected long[] mediaTime;
    protected int masterTrackID = -1;
    boolean sourceDisconnected = false;
    boolean allowDrop = false;
    boolean hasRead = false;
    protected int numTracks = 0;
    protected Format[] trackFormats;
    protected MonitorAdapter[] mc = null;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = -1L;
    long mediaStartTime = -1L;

    public RawBufferMux() {
        this.supported = new ContentDescriptor[1];
        this.supported[0] = new ContentDescriptor("raw");
        this.timeBase = new RawMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
        for (int i = 0; i < this.mc.length; ++i) {
            if (this.mc[i] == null) continue;
            this.mc[i].close();
        }
    }

    public DataSource getDataOutput() {
        return this.source;
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public String getName() {
        return "Raw Buffer Multiplexer";
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null), new VideoFormat(null)};
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formatArray) {
        return this.supported;
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    public boolean initializeTracks(Format[] formatArray) {
        if (this.source.getStreams() != null) {
            throw new Error("initializeTracks has been called previously. ");
        }
        this.source.initialize(formatArray);
        this.streams = (RawBufferSourceStream[])this.source.getStreams();
        return true;
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        return this.clock.mapToTimeBase(time);
    }

    public void open() throws ResourceUnavailableException {
        int n;
        this.initializeTracks(this.trackFormats);
        if (this.source == null || this.source.getStreams() == null) {
            throw new ResourceUnavailableException("DataSource and SourceStreams were not created succesfully.");
        }
        try {
            this.source.connect();
        }
        catch (IOException iOException) {
            throw new ResourceUnavailableException(iOException.getMessage());
        }
        int n2 = 0;
        this.mediaTime = new long[this.trackFormats.length];
        this.mc = new MonitorAdapter[this.trackFormats.length];
        for (n = 0; n < this.trackFormats.length; ++n) {
            this.mediaTime[n] = 0L;
            if (!(this.trackFormats[n] instanceof VideoFormat) && !(this.trackFormats[n] instanceof AudioFormat)) continue;
            this.mc[n] = new MonitorAdapter(this.trackFormats[n], this);
            if (this.mc[n] == null) continue;
            ++n2;
        }
        int n3 = 0;
        this.controls = new Control[n2];
        for (n = 0; n < this.mc.length; ++n) {
            if (this.mc[n] == null) continue;
            this.controls[n3++] = this.mc[n];
        }
    }

    public int process(Buffer buffer, int n) {
        if ((buffer.getFlags() & 0x1000) != 0) {
            buffer.setFlags(buffer.getFlags() & 0xFFFFEFFF | 0x100);
        }
        if (this.mc[n] != null && this.mc[n].isEnabled()) {
            this.mc[n].process(buffer);
        }
        if (this.streams == null || buffer == null || n >= this.streams.length) {
            return 1;
        }
        this.updateTime(buffer, n);
        return this.streams[n].process(buffer);
    }

    public void reset() {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i].reset();
            if (this.mc[i] == null) continue;
            this.mc[i].reset();
        }
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) {
        if (RawBufferMux.matches(contentDescriptor, this.supported) == null) {
            return null;
        }
        this.contentDesc = contentDescriptor;
        this.source = new RawBufferDataSource();
        return this.contentDesc;
    }

    public Format setInputFormat(Format format, int n) {
        if (n < this.numTracks) {
            this.trackFormats[n] = format;
        }
        for (int i = 0; i < this.numTracks; ++i) {
            if (this.trackFormats[i] != null) continue;
            return format;
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaTime(Time time) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(time);
            for (int i = 0; i < this.mediaTime.length; ++i) {
                this.mediaTime[i] = time.getNanoseconds();
            }
            this.timeBase.update();
            this.systemStartTime = System.currentTimeMillis();
            this.mediaStartTime = time.getNanoseconds() / 1000000L;
        }
    }

    public int setNumTracks(int n) {
        this.numTracks = n;
        this.trackFormats = new Format[n];
        for (int i = 0; i < n; ++i) {
            this.trackFormats[i] = null;
        }
        return n;
    }

    public float setRate(float f) {
        if (f == this.clock.getRate()) {
            return f;
        }
        return this.clock.setRate(1.0f);
    }

    public void setStopTime(Time time) {
        this.clock.setStopTime(time);
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (timeBase != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStart(Time time) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.clock.syncStart(time);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis();
            this.mediaStartTime = this.getMediaNanoseconds() / 1000000L;
        }
    }

    protected void updateTime(Buffer buffer, int n) {
        if (buffer.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(buffer.getFormat())) {
                if (buffer.getTimeStamp() < 0L) {
                    if (this.systemStartTime >= 0L) {
                        this.mediaTime[n] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
                    }
                } else {
                    this.mediaTime[n] = buffer.getTimeStamp();
                }
            } else {
                long l = ((AudioFormat)buffer.getFormat()).computeDuration(buffer.getLength());
                if (l >= 0L) {
                    int n2 = n;
                    this.mediaTime[n2] = this.mediaTime[n2] + l;
                } else {
                    this.mediaTime[n] = buffer.getTimeStamp();
                }
            }
        } else if (buffer.getTimeStamp() < 0L) {
            if (this.systemStartTime >= 0L) {
                this.mediaTime[n] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
            }
        } else {
            this.mediaTime[n] = buffer.getTimeStamp();
        }
        this.timeBase.update();
    }

    class RawMuxTimeBase
    extends MediaTimeBase {
        long ticks = 0L;
        boolean updated = false;

        RawMuxTimeBase() {
        }

        public long getMediaTime() {
            if (RawBufferMux.this.masterTrackID >= 0) {
                return RawBufferMux.this.mediaTime[RawBufferMux.this.masterTrackID];
            }
            if (!this.updated) {
                return this.ticks;
            }
            if (RawBufferMux.this.mediaTime.length == 1) {
                this.ticks = RawBufferMux.this.mediaTime[0];
            } else {
                this.ticks = RawBufferMux.this.mediaTime[0];
                for (int i = 1; i < RawBufferMux.this.mediaTime.length; ++i) {
                    if (RawBufferMux.this.mediaTime[i] >= this.ticks) continue;
                    this.ticks = RawBufferMux.this.mediaTime[i];
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }
    }

    class RawBufferSourceStream
    extends BasicSourceStream
    implements PushBufferStream,
    Runnable {
        Format format = null;
        CircularBuffer bufferQ;
        boolean started = false;
        Object startReq = new Integer(0);
        BufferTransferHandler handler = null;
        Thread streamThread = null;
        boolean closed = false;
        boolean draining = false;
        Object drainSync = new Object();

        public RawBufferSourceStream(Format format) {
            this.contentDescriptor = RawBufferMux.this.contentDesc;
            this.format = format;
            this.bufferQ = new CircularBuffer(5);
            this.streamThread = new MediaThread(this, "RawBufferStream Thread");
            if (this.streamThread != null) {
                this.streamThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            this.closed = true;
            if (this.streamThread != null) {
                try {
                    this.reset();
                    Object object = this.startReq;
                    synchronized (object) {
                        this.startReq.notifyAll();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int process(Buffer buffer) {
            Buffer buffer2;
            Object object;
            Object object2 = this.bufferQ;
            synchronized (object2) {
                if (RawBufferMux.this.allowDrop && !this.bufferQ.canWrite() && this.bufferQ.canRead() && (((Buffer)(object = this.bufferQ.peek())).getFlags() & 0x20) == 0) {
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                while (!this.bufferQ.canWrite() && !this.closed) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
                if (this.closed) {
                    return 0;
                }
                buffer2 = this.bufferQ.getEmptyBuffer();
            }
            object2 = buffer2.getData();
            object = buffer2.getHeader();
            buffer2.setData(buffer.getData());
            buffer2.setHeader(buffer.getHeader());
            buffer.setData(object2);
            buffer.setHeader(object);
            buffer2.setLength(buffer.getLength());
            buffer2.setEOM(buffer.isEOM());
            buffer2.setFlags(buffer.getFlags());
            buffer2.setRtpTimeStamp(buffer.getRtpTimeStamp());
            buffer2.setHeaderExtension(buffer.getHeaderExtension());
            buffer2.setTimeStamp(buffer.getTimeStamp());
            buffer2.setFormat(buffer.getFormat());
            buffer2.setOffset(buffer.getOffset());
            buffer2.setSequenceNumber(buffer.getSequenceNumber());
            if (buffer.isEOM()) {
                this.draining = true;
            }
            Object object3 = this.bufferQ;
            synchronized (object3) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
            if (buffer.isEOM()) {
                object3 = this.drainSync;
                synchronized (object3) {
                    try {
                        if (this.draining) {
                            this.drainSync.wait(3000L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(Buffer buffer) throws IOException {
            if (this.closed) {
                throw new IOException("The source stream is closed");
            }
            Buffer buffer2 = null;
            Object object = this.bufferQ;
            synchronized (object) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
                buffer2 = this.bufferQ.read();
            }
            if (buffer2.isEOM()) {
                object = this.drainSync;
                synchronized (object) {
                    if (this.draining) {
                        this.draining = false;
                        this.drainSync.notifyAll();
                    }
                }
            }
            object = buffer.getData();
            Object object2 = buffer.getHeader();
            buffer.copy(buffer2);
            buffer2.setData(object);
            buffer2.setHeader(object2);
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                RawBufferMux.this.hasRead = true;
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset() {
            Object object = this.bufferQ;
            synchronized (object) {
                while (this.bufferQ.canRead()) {
                    Buffer buffer = this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                this.bufferQ.notifyAll();
            }
            object = this.drainSync;
            synchronized (object) {
                if (this.draining) {
                    this.draining = false;
                    this.drainSync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Object object = this.startReq;
                    synchronized (object) {
                        while (!this.started && !this.closed) {
                            this.startReq.wait();
                        }
                    }
                    object = this.bufferQ;
                    synchronized (object) {
                        do {
                            if (!RawBufferMux.this.hasRead) {
                                this.bufferQ.wait(250L);
                            }
                            RawBufferMux.this.hasRead = false;
                        } while (!this.bufferQ.canRead() && !this.closed && this.started);
                    }
                    if (this.closed) {
                        return;
                    }
                    if (!this.started || this.handler == null) continue;
                    this.handler.transferData(this);
                }
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Thread " + interruptedException.getMessage());
                return;
            }
        }

        public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
            this.handler = bufferTransferHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void start() {
            Object object = this.startReq;
            synchronized (object) {
                if (this.started) {
                    return;
                }
                this.started = true;
                this.startReq.notifyAll();
            }
            object = this.bufferQ;
            synchronized (object) {
                RawBufferMux.this.hasRead = true;
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stop() {
            Object object = this.startReq;
            synchronized (object) {
                this.started = false;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }
    }

    class RawBufferDataSource
    extends BasicPushBufferDataSource {
        public RawBufferDataSource() {
            if (RawBufferMux.this.contentDesc == null) {
                return;
            }
            this.contentType = RawBufferMux.this.contentDesc.getContentType();
        }

        public void connect() throws IOException {
            super.connect();
            RawBufferMux.this.sourceDisconnected = false;
        }

        public void disconnect() {
            super.disconnect();
            RawBufferMux.this.sourceDisconnected = true;
            for (int i = 0; i < RawBufferMux.this.streams.length; ++i) {
                RawBufferMux.this.streams[i].stop();
                RawBufferMux.this.streams[i].close();
            }
        }

        public PushBufferStream[] getStreams() {
            return RawBufferMux.this.streams;
        }

        private void initialize(Format[] formatArray) {
            RawBufferMux.this.streams = new RawBufferSourceStream[formatArray.length];
            for (int i = 0; i < formatArray.length; ++i) {
                RawBufferMux.this.streams[i] = new RawBufferSourceStream(formatArray[i]);
            }
        }

        public void start() throws IOException {
            super.start();
            for (int i = 0; i < RawBufferMux.this.streams.length; ++i) {
                RawBufferMux.this.streams[i].start();
            }
        }

        public void stop() throws IOException {
            super.stop();
            for (int i = 0; i < RawBufferMux.this.streams.length; ++i) {
                RawBufferMux.this.streams[i].stop();
            }
        }
    }
}

